
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An annotation that adds a text markup to a page.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for MarkupAnnotationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MarkupAnnotationType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseAnnotationType">
 *       <all>
 *         <element name="position" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice maxOccurs="unbounded" minOccurs="0">
 *                   <element name="pathElement" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
 *                   <element name="quadrilateral" type="{http://schema.webpdf.de/1.0/operation}QuadrilateralType"/>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </all>
 *       <attribute name="markupType" type="{http://schema.webpdf.de/1.0/operation}MarkupsAnnotationType" default="highlight" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MarkupAnnotationType", propOrder = {
    "position"
})
public class MarkupAnnotationType
    extends BaseAnnotationType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the pathelements in which the annotation shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     */
    protected MarkupAnnotationType.Position position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the type of markup. The following values are available:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;highlight = Highlights text&lt;/li&gt;&lt;li&gt;underline = Underlines text with a straight line&lt;/li&gt;&lt;li&gt;strikeOut = Strikes text through&lt;/li&gt;&lt;li&gt;squiggly = Underlines text with a squiggly line&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "markupType")
    protected MarkupsAnnotationType markupType;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the pathelements in which the annotation shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MarkupAnnotationType.Position }
     *     
     */
    public MarkupAnnotationType.Position getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link MarkupAnnotationType.Position }
     *     
     * @see #getPosition()
     */
    public void setPosition(MarkupAnnotationType.Position value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the type of markup. The following values are available:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;highlight = Highlights text&lt;/li&gt;&lt;li&gt;underline = Underlines text with a straight line&lt;/li&gt;&lt;li&gt;strikeOut = Strikes text through&lt;/li&gt;&lt;li&gt;squiggly = Underlines text with a squiggly line&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MarkupsAnnotationType }
     *     
     */
    public MarkupsAnnotationType getMarkupType() {
        if (markupType == null) {
            return MarkupsAnnotationType.HIGHLIGHT;
        } else {
            return markupType;
        }
    }

    /**
     * Sets the value of the markupType property.
     * 
     * @param value
     *     allowed object is
     *     {@link MarkupsAnnotationType }
     *     
     * @see #getMarkupType()
     */
    public void setMarkupType(MarkupsAnnotationType value) {
        this.markupType = value;
    }

    public boolean isSetMarkupType() {
        return (this.markupType!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded" minOccurs="0">
     *         <element name="pathElement" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
     *         <element name="quadrilateral" type="{http://schema.webpdf.de/1.0/operation}QuadrilateralType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "pathElement",
        "quadrilateral"
    })
    public static class Position {

        protected List<RectangleType> pathElement;
        protected List<QuadrilateralType> quadrilateral;

        /**
         * Gets the value of the pathElement property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the pathElement property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getPathElement().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link RectangleType }
         * </p>
         * 
         * 
         * @return
         *     The value of the pathElement property.
         */
        public List<RectangleType> getPathElement() {
            if (pathElement == null) {
                pathElement = new ArrayList<>();
            }
            return this.pathElement;
        }

        public boolean isSetPathElement() {
            return ((this.pathElement!= null)&&(!this.pathElement.isEmpty()));
        }

        public void unsetPathElement() {
            this.pathElement = null;
        }

        /**
         * Gets the value of the quadrilateral property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the quadrilateral property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getQuadrilateral().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link QuadrilateralType }
         * </p>
         * 
         * 
         * @return
         *     The value of the quadrilateral property.
         */
        public List<QuadrilateralType> getQuadrilateral() {
            if (quadrilateral == null) {
                quadrilateral = new ArrayList<>();
            }
            return this.quadrilateral;
        }

        public boolean isSetQuadrilateral() {
            return ((this.quadrilateral!= null)&&(!this.quadrilateral.isEmpty()));
        }

        public void unsetQuadrilateral() {
            this.quadrilateral = null;
        }

    }

}
