
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines which sub-windows will be opened when the PDF document is opened.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = No special view&lt;/li&gt;&lt;li&gt;outlines = Opens the "Bookmarks" tab&lt;/li&gt;&lt;li&gt;thumbnails = Opens the "Thumbnails" tab&lt;/li&gt;&lt;li&gt;fullscreen = Opens the document in full screen mode&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for InitialViewType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="InitialViewType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="outlines"/>
 *     <enumeration value="thumbnails"/>
 *     <enumeration value="fullscreen"/>
 *     <enumeration value="layers"/>
 *     <enumeration value="attachments"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "InitialViewType")
@XmlEnum
public enum InitialViewType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("outlines")
    OUTLINES("outlines"),
    @XmlEnumValue("thumbnails")
    THUMBNAILS("thumbnails"),
    @XmlEnumValue("fullscreen")
    FULLSCREEN("fullscreen"),
    @XmlEnumValue("layers")
    LAYERS("layers"),
    @XmlEnumValue("attachments")
    ATTACHMENTS("attachments");
    private final String value;

    InitialViewType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static InitialViewType fromValue(String v) {
        for (InitialViewType c: InitialViewType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
