
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the SSL options for all HTTP requests.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for HttpSettingsSSLType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="HttpSettingsSSLType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all minOccurs="0">
 *         <element name="protocols" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <sequence maxOccurs="unbounded">
 *                   <element name="protocol" type="{http://schema.webpdf.de/1.0/operation}HttpSettingsSSLProtocolType" maxOccurs="unbounded"/>
 *                 </sequence>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="ciphers" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <sequence maxOccurs="unbounded">
 *                   <element name="cipher" type="{http://schema.webpdf.de/1.0/operation}HttpSettingsSSLCipherType" maxOccurs="unbounded"/>
 *                 </sequence>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </all>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "HttpSettingsSSLType", propOrder = {

})
public class HttpSettingsSSLType {

    protected HttpSettingsSSLType.Protocols protocols;
    protected HttpSettingsSSLType.Ciphers ciphers;

    /**
     * Gets the value of the protocols property.
     * 
     * @return
     *     possible object is
     *     {@link HttpSettingsSSLType.Protocols }
     *     
     */
    public HttpSettingsSSLType.Protocols getProtocols() {
        return protocols;
    }

    /**
     * Sets the value of the protocols property.
     * 
     * @param value
     *     allowed object is
     *     {@link HttpSettingsSSLType.Protocols }
     *     
     */
    public void setProtocols(HttpSettingsSSLType.Protocols value) {
        this.protocols = value;
    }

    public boolean isSetProtocols() {
        return (this.protocols!= null);
    }

    /**
     * Gets the value of the ciphers property.
     * 
     * @return
     *     possible object is
     *     {@link HttpSettingsSSLType.Ciphers }
     *     
     */
    public HttpSettingsSSLType.Ciphers getCiphers() {
        return ciphers;
    }

    /**
     * Sets the value of the ciphers property.
     * 
     * @param value
     *     allowed object is
     *     {@link HttpSettingsSSLType.Ciphers }
     *     
     */
    public void setCiphers(HttpSettingsSSLType.Ciphers value) {
        this.ciphers = value;
    }

    public boolean isSetCiphers() {
        return (this.ciphers!= null);
    }


    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the list of allowed TLS ciphers for the HTTP requests.&lt;/p&gt;
     * </pre>
     * 
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <sequence maxOccurs="unbounded">
     *         <element name="cipher" type="{http://schema.webpdf.de/1.0/operation}HttpSettingsSSLCipherType" maxOccurs="unbounded"/>
     *       </sequence>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "cipher"
    })
    public static class Ciphers {

        @XmlElement(required = true, defaultValue = "")
        protected List<String> cipher;

        /**
         * Gets the value of the cipher property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the cipher property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getCipher().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link String }
         * </p>
         * 
         * 
         * @return
         *     The value of the cipher property.
         */
        public List<String> getCipher() {
            if (cipher == null) {
                cipher = new ArrayList<>();
            }
            return this.cipher;
        }

        public boolean isSetCipher() {
            return ((this.cipher!= null)&&(!this.cipher.isEmpty()));
        }

        public void unsetCipher() {
            this.cipher = null;
        }

    }


    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the allowed TLS protocols for the HTTP requests.&lt;/p&gt;
     * </pre>
     * 
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <sequence maxOccurs="unbounded">
     *         <element name="protocol" type="{http://schema.webpdf.de/1.0/operation}HttpSettingsSSLProtocolType" maxOccurs="unbounded"/>
     *       </sequence>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "protocol"
    })
    public static class Protocols {

        @XmlElement(required = true, defaultValue = "TLSv1.2")
        @XmlSchemaType(name = "string")
        protected List<HttpSettingsSSLProtocolType> protocol;

        /**
         * Gets the value of the protocol property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the protocol property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getProtocol().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link HttpSettingsSSLProtocolType }
         * </p>
         * 
         * 
         * @return
         *     The value of the protocol property.
         */
        public List<HttpSettingsSSLProtocolType> getProtocol() {
            if (protocol == null) {
                protocol = new ArrayList<>();
            }
            return this.protocol;
        }

        public boolean isSetProtocol() {
            return ((this.protocol!= null)&&(!this.protocol.isEmpty()));
        }

        public void unsetProtocol() {
            this.protocol = null;
        }

    }

}
