
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the TLS protocol type for SSL connections.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for HttpSettingsSSLProtocolType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="HttpSettingsSSLProtocolType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="TLSv1"/>
 *     <enumeration value="TLSv1.1"/>
 *     <enumeration value="TLSv1.2"/>
 *     <enumeration value="TLSv1.3"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "HttpSettingsSSLProtocolType")
@XmlEnum
public enum HttpSettingsSSLProtocolType {

    @XmlEnumValue("TLSv1")
    TLS_V1("TLSv1"),
    @XmlEnumValue("TLSv1.1")
    TLS_V1_1("TLSv1.1"),
    @XmlEnumValue("TLSv1.2")
    TLS_V1_2("TLSv1.2"),
    @XmlEnumValue("TLSv1.3")
    TLS_V1_3("TLSv1.3");
    private final String value;

    HttpSettingsSSLProtocolType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static HttpSettingsSSLProtocolType fromValue(String v) {
        for (HttpSettingsSSLProtocolType c: HttpSettingsSSLProtocolType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
