
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify whether the selected font should be obtained from your operating system or from the "templates/fonts" folder (in your webPDF installation path).&#13;
 *                     Possible values:&#13;
 *                     &lt;ul&gt;&lt;li&gt;system = It will be possible to select from the fonts available system-wide.&lt;/li&gt;&lt;li&gt;folder =It will be possible to select from the fonts in "templates/fonts".&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for FontOriginModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="FontOriginModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="system"/>
 *     <enumeration value="folder"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "FontOriginModeType")
@XmlEnum
public enum FontOriginModeType {

    @XmlEnumValue("system")
    SYSTEM("system"),
    @XmlEnumValue("folder")
    FOLDER("folder");
    private final String value;

    FontOriginModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static FontOriginModeType fromValue(String v) {
        for (FontOriginModeType c: FontOriginModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
