
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p174123_="https://jakarta.ee/xml/ns/jaxb" xmlns:p235432_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the format how to pass the documents to be used for merging.&#13;
 *                     &lt;ul&gt;&lt;li&gt;pdf = A single PDF file&lt;/li&gt;&lt;li&gt;zip = It is a ZIP file that contains one or more PDF documents.&lt;/li&gt;&lt;li&gt;id = It is a semicolon separated list of document ID's referencing documents already on the server (REST API only).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p174123_="https://jakarta.ee/xml/ns/jaxb" xmlns:p235432_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     The "id" parameter can be used only with REST API. Each document that has been uploaded to the server via REST API has a unique ID. This ID can be used to reference the document. In the content of the "data" element, the list is passed as BASE64 content.&#13;
 *                     Example for two documents:&lt;ul&gt;&lt;li&gt;List of documents: 3bde686a47284a2da3bfce62bd6bb8bd;f5c2b314d0c74fd0878d1f4ca310b0ad&lt;/li&gt;&lt;li&gt;BASE64 encoded: M2JkZTY4NmE0NzI4NGEyZGEzYmZjZTYyYmQ2YmI4YmQ7ZjVjMmIzMTRkMGM3NGZkMDg3OGQxZjRjYTMxMGIwYWQ=&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for FileDataFormatType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="FileDataFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="pdf"/>
 *     <enumeration value="zip"/>
 *     <enumeration value="id"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "FileDataFormatType")
@XmlEnum
public enum FileDataFormatType {

    @XmlEnumValue("pdf")
    PDF("pdf"),
    @XmlEnumValue("zip")
    ZIP("zip"),
    @XmlEnumValue("id")
    ID("id");
    private final String value;

    FileDataFormatType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static FileDataFormatType fromValue(String v) {
        for (FileDataFormatType c: FileDataFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
