
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;These settings are only used for e-mail documents. The "MIME" (eml; RFC-822) and Outlook (msg) e-mail formats are supported.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ConverterMailType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ConverterMailType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="downloadImages" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="adjustFonts" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="attachmentMode" type="{http://schema.webpdf.de/1.0/operation}AttachmentModeType" default="embed" />
 *       <attribute name="ignoreMissingBodyChunk" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="useBackground" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="resizeImages" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="resizeTables" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="reduceImageSize" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ConverterMailType")
public class ConverterMailType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then externally referenced images in the HTML content of the e-mail are downloaded and inserted into the document. If false, the images are not downloaded and the external references to the image are removed, leaving already embedded images intact. This option can slow down the conversion if many images are included or if, for example, e-mail documents are converted in which the images can no longer be retrieved.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "downloadImages")
    protected Boolean downloadImages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then the font specifications "Arial", "Helvetica" and "Sans-Serif" in HTML documents and e-mails (which are based on HTML) are automatically replaced by the "Arial Unicode MS" font. The improves the appearance of the typeface in the PDF result.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "adjustFonts")
    protected Boolean adjustFonts;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the manner in which attachments are to be processed in e-mails.&#13;
     *                         &lt;ul&gt;&lt;li&gt;embed = Embed in original format&lt;/li&gt;&lt;li&gt;remove = Remove attachments&lt;/li&gt;&lt;li&gt;convert = Converts the attachments to PDF format and embeds them as an attachment&lt;/li&gt;&lt;li&gt;convertMerge = Converts the attachments to PDF format and appends them as additional page(s) at the end&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If conversion to PDF format is not possible when using "convert" or "convertMerge", the attachment will be embedded in its original format.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "attachmentMode")
    protected AttachmentModeType attachmentMode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this option is enabled, an error will not be triggered (the conversion will not be aborted) for e-mails if there is no body element in the file structure. However, this should not be confused with an e-mail not having any content.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "ignoreMissingBodyChunk")
    protected Boolean ignoreMissingBodyChunk;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then a background defined in the e-mail (in the HTML content) is also output in the PDF document. If "false", the background will be hidden.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "useBackground")
    protected Boolean useBackground;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, then an attempt is made to fit all images that are not in a table to the maximum page width in the PDF document. The graphics will be scaled (while maintaining the aspect ratio) to fit the width of the page and not be cut off. Please note that this may cause the original formatting of the email to be lost or to deviate from the original due to the scaling.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If the "resizeImages" option is enabled, you must expect that the original appearance of the e-mail document will no longer be preserved.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "resizeImages")
    protected Boolean resizeImages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, then an attempt is made to fit all tables to the maximum page width in the PDF document. An attempt is made to reduce the individual columns of a table so that the table fits completely within the page width. This works only for simple tables originally defined with dynamic sizes and not for nested tables (table-in-table). Please note that this may cause the original formatting of the email to be lost or to deviate from the original due to scaling.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If the option "resizeTables" is activated, you must expect that the original appearance of the e-mail document is no longer preserved. The recalculation of the table columns may also result in very narrow columns in the output.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "resizeTables")
    protected Boolean resizeTables;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then all images are reduced in their pixel size so that they fit into the maximum page width.&#13;
     *                         This only applies to images that have been resized using the &lt;code&gt;resizeImages&lt;/code&gt; option.&#13;
     *                         These images are reduced to the maximum number of pixels required to fit the page width.&#13;
     *                         Images that are not affected by the &lt;code&gt;resizeImages&lt;/code&gt; option are not resized.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If you activate the &lt;code&gt;reduceImageSize&lt;/code&gt; option, you must also activate &lt;code&gt;resizeImages&lt;/code&gt; and only resized images will be affected by this option.&#13;
     *                         This option also leads to a significant reduction in the number of pixels in images, which can lead to an improved document size.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "reduceImageSize")
    protected Boolean reduceImageSize;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then externally referenced images in the HTML content of the e-mail are downloaded and inserted into the document. If false, the images are not downloaded and the external references to the image are removed, leaving already embedded images intact. This option can slow down the conversion if many images are included or if, for example, e-mail documents are converted in which the images can no longer be retrieved.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isDownloadImages() {
        if (downloadImages == null) {
            return false;
        } else {
            return downloadImages;
        }
    }

    /**
     * Sets the value of the downloadImages property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isDownloadImages()
     */
    public void setDownloadImages(boolean value) {
        this.downloadImages = value;
    }

    public boolean isSetDownloadImages() {
        return (this.downloadImages!= null);
    }

    public void unsetDownloadImages() {
        this.downloadImages = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then the font specifications "Arial", "Helvetica" and "Sans-Serif" in HTML documents and e-mails (which are based on HTML) are automatically replaced by the "Arial Unicode MS" font. The improves the appearance of the typeface in the PDF result.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isAdjustFonts() {
        if (adjustFonts == null) {
            return false;
        } else {
            return adjustFonts;
        }
    }

    /**
     * Sets the value of the adjustFonts property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isAdjustFonts()
     */
    public void setAdjustFonts(boolean value) {
        this.adjustFonts = value;
    }

    public boolean isSetAdjustFonts() {
        return (this.adjustFonts!= null);
    }

    public void unsetAdjustFonts() {
        this.adjustFonts = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the manner in which attachments are to be processed in e-mails.&#13;
     *                         &lt;ul&gt;&lt;li&gt;embed = Embed in original format&lt;/li&gt;&lt;li&gt;remove = Remove attachments&lt;/li&gt;&lt;li&gt;convert = Converts the attachments to PDF format and embeds them as an attachment&lt;/li&gt;&lt;li&gt;convertMerge = Converts the attachments to PDF format and appends them as additional page(s) at the end&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If conversion to PDF format is not possible when using "convert" or "convertMerge", the attachment will be embedded in its original format.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link AttachmentModeType }
     *     
     */
    public AttachmentModeType getAttachmentMode() {
        if (attachmentMode == null) {
            return AttachmentModeType.EMBED;
        } else {
            return attachmentMode;
        }
    }

    /**
     * Sets the value of the attachmentMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link AttachmentModeType }
     *     
     * @see #getAttachmentMode()
     */
    public void setAttachmentMode(AttachmentModeType value) {
        this.attachmentMode = value;
    }

    public boolean isSetAttachmentMode() {
        return (this.attachmentMode!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this option is enabled, an error will not be triggered (the conversion will not be aborted) for e-mails if there is no body element in the file structure. However, this should not be confused with an e-mail not having any content.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isIgnoreMissingBodyChunk() {
        if (ignoreMissingBodyChunk == null) {
            return false;
        } else {
            return ignoreMissingBodyChunk;
        }
    }

    /**
     * Sets the value of the ignoreMissingBodyChunk property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isIgnoreMissingBodyChunk()
     */
    public void setIgnoreMissingBodyChunk(boolean value) {
        this.ignoreMissingBodyChunk = value;
    }

    public boolean isSetIgnoreMissingBodyChunk() {
        return (this.ignoreMissingBodyChunk!= null);
    }

    public void unsetIgnoreMissingBodyChunk() {
        this.ignoreMissingBodyChunk = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then a background defined in the e-mail (in the HTML content) is also output in the PDF document. If "false", the background will be hidden.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isUseBackground() {
        if (useBackground == null) {
            return true;
        } else {
            return useBackground;
        }
    }

    /**
     * Sets the value of the useBackground property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isUseBackground()
     */
    public void setUseBackground(boolean value) {
        this.useBackground = value;
    }

    public boolean isSetUseBackground() {
        return (this.useBackground!= null);
    }

    public void unsetUseBackground() {
        this.useBackground = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, then an attempt is made to fit all images that are not in a table to the maximum page width in the PDF document. The graphics will be scaled (while maintaining the aspect ratio) to fit the width of the page and not be cut off. Please note that this may cause the original formatting of the email to be lost or to deviate from the original due to the scaling.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If the "resizeImages" option is enabled, you must expect that the original appearance of the e-mail document will no longer be preserved.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isResizeImages() {
        if (resizeImages == null) {
            return false;
        } else {
            return resizeImages;
        }
    }

    /**
     * Sets the value of the resizeImages property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isResizeImages()
     */
    public void setResizeImages(boolean value) {
        this.resizeImages = value;
    }

    public boolean isSetResizeImages() {
        return (this.resizeImages!= null);
    }

    public void unsetResizeImages() {
        this.resizeImages = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, then an attempt is made to fit all tables to the maximum page width in the PDF document. An attempt is made to reduce the individual columns of a table so that the table fits completely within the page width. This works only for simple tables originally defined with dynamic sizes and not for nested tables (table-in-table). Please note that this may cause the original formatting of the email to be lost or to deviate from the original due to scaling.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If the option "resizeTables" is activated, you must expect that the original appearance of the e-mail document is no longer preserved. The recalculation of the table columns may also result in very narrow columns in the output.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isResizeTables() {
        if (resizeTables == null) {
            return false;
        } else {
            return resizeTables;
        }
    }

    /**
     * Sets the value of the resizeTables property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isResizeTables()
     */
    public void setResizeTables(boolean value) {
        this.resizeTables = value;
    }

    public boolean isSetResizeTables() {
        return (this.resizeTables!= null);
    }

    public void unsetResizeTables() {
        this.resizeTables = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then all images are reduced in their pixel size so that they fit into the maximum page width.&#13;
     *                         This only applies to images that have been resized using the &lt;code&gt;resizeImages&lt;/code&gt; option.&#13;
     *                         These images are reduced to the maximum number of pixels required to fit the page width.&#13;
     *                         Images that are not affected by the &lt;code&gt;resizeImages&lt;/code&gt; option are not resized.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If you activate the &lt;code&gt;reduceImageSize&lt;/code&gt; option, you must also activate &lt;code&gt;resizeImages&lt;/code&gt; and only resized images will be affected by this option.&#13;
     *                         This option also leads to a significant reduction in the number of pixels in images, which can lead to an improved document size.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isReduceImageSize() {
        if (reduceImageSize == null) {
            return false;
        } else {
            return reduceImageSize;
        }
    }

    /**
     * Sets the value of the reduceImageSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isReduceImageSize()
     */
    public void setReduceImageSize(boolean value) {
        this.reduceImageSize = value;
    }

    public boolean isSetReduceImageSize() {
        return (this.reduceImageSize!= null);
    }

    public void unsetReduceImageSize() {
        this.reduceImageSize = null;
    }

}
