
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Combines object definitions of the document into so-called "object streams" and compresses them. This operation is recommended especially for larger documents with many objects. The size of contained resources (such as graphics and fonts) cannot be reduced in this way.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for CompressSettingsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="CompressSettingsType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}CompressType">
 *       <attribute name="compressProfile" type="{http://schema.webpdf.de/1.0/operation}CompressProfileType" default="never" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CompressSettingsType")
public class CompressSettingsType
    extends CompressType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the profile for automatic document compression and thus defines whether compression should be applied when saving.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;always = PDF documents should always be compressed when saved.&lt;/li&gt;&lt;li&gt;never = PDF documents should not be automatically compressed.&lt;/li&gt;&lt;li&gt;recompress = PDF documents should only be compressed automatically if they were already compressed previously.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "compressProfile")
    protected CompressProfileType compressProfile;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the profile for automatic document compression and thus defines whether compression should be applied when saving.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;always = PDF documents should always be compressed when saved.&lt;/li&gt;&lt;li&gt;never = PDF documents should not be automatically compressed.&lt;/li&gt;&lt;li&gt;recompress = PDF documents should only be compressed automatically if they were already compressed previously.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link CompressProfileType }
     *     
     */
    public CompressProfileType getCompressProfile() {
        if (compressProfile == null) {
            return CompressProfileType.NEVER;
        } else {
            return compressProfile;
        }
    }

    /**
     * Sets the value of the compressProfile property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompressProfileType }
     *     
     * @see #getCompressProfile()
     */
    public void setCompressProfile(CompressProfileType value) {
        this.compressProfile = value;
    }

    public boolean isSetCompressProfile() {
        return (this.compressProfile!= null);
    }

}
