
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to change the dimensions of a specific box in a specific page range in the document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BoxesResizeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BoxesResizeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="dimensions">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="x" default="0">
 *                   <simpleType>
 *                     <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *                       <minInclusive value="0"/>
 *                     </restriction>
 *                   </simpleType>
 *                 </attribute>
 *                 <attribute name="y" default="0">
 *                   <simpleType>
 *                     <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *                       <minInclusive value="0"/>
 *                     </restriction>
 *                   </simpleType>
 *                 </attribute>
 *                 <attribute name="width" default="0">
 *                   <simpleType>
 *                     <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *                       <minInclusive value="0"/>
 *                     </restriction>
 *                   </simpleType>
 *                 </attribute>
 *                 <attribute name="height" default="0">
 *                   <simpleType>
 *                     <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *                       <minInclusive value="0"/>
 *                     </restriction>
 *                   </simpleType>
 *                 </attribute>
 *                 <attribute name="metrics" type="{http://schema.webpdf.de/1.0/operation}MetricsType" default="mm" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </all>
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="box" type="{http://schema.webpdf.de/1.0/operation}PageBoxType" default="media_box" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BoxesResizeType", propOrder = {

})
public class BoxesResizeType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the position and dimensions of a containing element.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlElement(required = true)
    protected BoxesResizeType.Dimensions dimensions;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page(s) in which boxes should be scaled. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). To specify "all pages," use an asterisk ("*").&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the box that should be scaled.&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "box")
    protected PageBoxType box;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the position and dimensions of a containing element.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BoxesResizeType.Dimensions }
     *     
     */
    public BoxesResizeType.Dimensions getDimensions() {
        return dimensions;
    }

    /**
     * Sets the value of the dimensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link BoxesResizeType.Dimensions }
     *     
     * @see #getDimensions()
     */
    public void setDimensions(BoxesResizeType.Dimensions value) {
        this.dimensions = value;
    }

    public boolean isSetDimensions() {
        return (this.dimensions!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page(s) in which boxes should be scaled. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). To specify "all pages," use an asterisk ("*").&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        return pages;
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the box that should be scaled.&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PageBoxType }
     *     
     */
    public PageBoxType getBox() {
        if (box == null) {
            return PageBoxType.MEDIA_BOX;
        } else {
            return box;
        }
    }

    /**
     * Sets the value of the box property.
     * 
     * @param value
     *     allowed object is
     *     {@link PageBoxType }
     *     
     * @see #getBox()
     */
    public void setBox(PageBoxType value) {
        this.box = value;
    }

    public boolean isSetBox() {
        return (this.box!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="x" default="0">
     *         <simpleType>
     *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
     *             <minInclusive value="0"/>
     *           </restriction>
     *         </simpleType>
     *       </attribute>
     *       <attribute name="y" default="0">
     *         <simpleType>
     *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
     *             <minInclusive value="0"/>
     *           </restriction>
     *         </simpleType>
     *       </attribute>
     *       <attribute name="width" default="0">
     *         <simpleType>
     *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
     *             <minInclusive value="0"/>
     *           </restriction>
     *         </simpleType>
     *       </attribute>
     *       <attribute name="height" default="0">
     *         <simpleType>
     *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
     *             <minInclusive value="0"/>
     *           </restriction>
     *         </simpleType>
     *       </attribute>
     *       <attribute name="metrics" type="{http://schema.webpdf.de/1.0/operation}MetricsType" default="mm" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Dimensions {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The horizontal displacement of the element.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "x")
        protected Float x;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The vertical displacement of the element.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "y")
        protected Float y;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The width of the element.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "width")
        protected Float width;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The height of the element.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "height")
        protected Float height;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Unit of measurement for specifying dimensions and items:&#13;
         *                                     &lt;ul&gt;&lt;li&gt;pt = Points(1/72 inch)&lt;/li&gt;&lt;li&gt;pc = Picas(12 points)&lt;/li&gt;&lt;li&gt;px = Pixels(1/96 inch)&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "metrics")
        protected MetricsType metrics;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The horizontal displacement of the element.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Float }
         *     
         */
        public float getX() {
            if (x == null) {
                return  0.0F;
            } else {
                return x;
            }
        }

        /**
         * Sets the value of the x property.
         * 
         * @param value
         *     allowed object is
         *     {@link Float }
         *     
         * @see #getX()
         */
        public void setX(float value) {
            this.x = value;
        }

        public boolean isSetX() {
            return (this.x!= null);
        }

        public void unsetX() {
            this.x = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The vertical displacement of the element.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Float }
         *     
         */
        public float getY() {
            if (y == null) {
                return  0.0F;
            } else {
                return y;
            }
        }

        /**
         * Sets the value of the y property.
         * 
         * @param value
         *     allowed object is
         *     {@link Float }
         *     
         * @see #getY()
         */
        public void setY(float value) {
            this.y = value;
        }

        public boolean isSetY() {
            return (this.y!= null);
        }

        public void unsetY() {
            this.y = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The width of the element.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Float }
         *     
         */
        public float getWidth() {
            if (width == null) {
                return  0.0F;
            } else {
                return width;
            }
        }

        /**
         * Sets the value of the width property.
         * 
         * @param value
         *     allowed object is
         *     {@link Float }
         *     
         * @see #getWidth()
         */
        public void setWidth(float value) {
            this.width = value;
        }

        public boolean isSetWidth() {
            return (this.width!= null);
        }

        public void unsetWidth() {
            this.width = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The height of the element.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Float }
         *     
         */
        public float getHeight() {
            if (height == null) {
                return  0.0F;
            } else {
                return height;
            }
        }

        /**
         * Sets the value of the height property.
         * 
         * @param value
         *     allowed object is
         *     {@link Float }
         *     
         * @see #getHeight()
         */
        public void setHeight(float value) {
            this.height = value;
        }

        public boolean isSetHeight() {
            return (this.height!= null);
        }

        public void unsetHeight() {
            this.height = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Unit of measurement for specifying dimensions and items:&#13;
         *                                     &lt;ul&gt;&lt;li&gt;pt = Points(1/72 inch)&lt;/li&gt;&lt;li&gt;pc = Picas(12 points)&lt;/li&gt;&lt;li&gt;px = Pixels(1/96 inch)&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link MetricsType }
         *     
         */
        public MetricsType getMetrics() {
            if (metrics == null) {
                return MetricsType.MM;
            } else {
                return metrics;
            }
        }

        /**
         * Sets the value of the metrics property.
         * 
         * @param value
         *     allowed object is
         *     {@link MetricsType }
         *     
         * @see #getMetrics()
         */
        public void setMetrics(MetricsType value) {
            this.metrics = value;
        }

        public boolean isSetMetrics() {
            return (this.metrics!= null);
        }

    }

}
