
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines a border for a rendered geometrical element.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BorderType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BorderType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="borderWidth" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="borderStyle" type="{http://schema.webpdf.de/1.0/operation}BorderStyleType" default="solid" />
 *       <attribute name="dashLength" default="3">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="gapLength" default="3">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BorderType")
public class BorderType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the border width/strength/thickness.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "borderWidth")
    protected Integer borderWidth;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the border style.&#13;
     *                         &lt;ul&gt;&lt;li&gt;solid = A solid line border.&lt;/li&gt;&lt;li&gt;dashed = A dashed border using the given dash and gap length.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "borderStyle")
    protected BorderStyleType borderStyle;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The interval length of dashes for a border with a "dashed" style.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "dashLength")
    protected Integer dashLength;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The interval length of gaps for a border with a "dashed" style.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "gapLength")
    protected Integer gapLength;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the border width/strength/thickness.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getBorderWidth() {
        if (borderWidth == null) {
            return  1;
        } else {
            return borderWidth;
        }
    }

    /**
     * Sets the value of the borderWidth property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getBorderWidth()
     */
    public void setBorderWidth(int value) {
        this.borderWidth = value;
    }

    public boolean isSetBorderWidth() {
        return (this.borderWidth!= null);
    }

    public void unsetBorderWidth() {
        this.borderWidth = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the border style.&#13;
     *                         &lt;ul&gt;&lt;li&gt;solid = A solid line border.&lt;/li&gt;&lt;li&gt;dashed = A dashed border using the given dash and gap length.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BorderStyleType }
     *     
     */
    public BorderStyleType getBorderStyle() {
        if (borderStyle == null) {
            return BorderStyleType.SOLID;
        } else {
            return borderStyle;
        }
    }

    /**
     * Sets the value of the borderStyle property.
     * 
     * @param value
     *     allowed object is
     *     {@link BorderStyleType }
     *     
     * @see #getBorderStyle()
     */
    public void setBorderStyle(BorderStyleType value) {
        this.borderStyle = value;
    }

    public boolean isSetBorderStyle() {
        return (this.borderStyle!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The interval length of dashes for a border with a "dashed" style.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDashLength() {
        if (dashLength == null) {
            return  3;
        } else {
            return dashLength;
        }
    }

    /**
     * Sets the value of the dashLength property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getDashLength()
     */
    public void setDashLength(int value) {
        this.dashLength = value;
    }

    public boolean isSetDashLength() {
        return (this.dashLength!= null);
    }

    public void unsetDashLength() {
        this.dashLength = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The interval length of gaps for a border with a "dashed" style.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getGapLength() {
        if (gapLength == null) {
            return  3;
        } else {
            return gapLength;
        }
    }

    /**
     * Sets the value of the gapLength property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getGapLength()
     */
    public void setGapLength(int value) {
        this.gapLength = value;
    }

    public boolean isSetGapLength() {
        return (this.gapLength!= null);
    }

    public void unsetGapLength() {
        this.gapLength = null;
    }

}
