
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;General attributes for the content elements.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BaseExtractionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BaseExtractionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="fileFormat" default="xml">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}ExtractionFileFormatType">
 *             <enumeration value="json"/>
 *             <enumeration value="text"/>
 *             <enumeration value="xml"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BaseExtractionType")
@XmlSeeAlso({
    ExtractionTextType.class,
    ExtractionLinksType.class,
    ExtractionInfoType.class,
    ExtractionWordsType.class,
    ExtractionParagraphsType.class
})
public class BaseExtractionType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the output format for the PDF document text contents being extracted.&#13;
     *                         &lt;ul&gt;&lt;li&gt;text = Text document&lt;/li&gt;&lt;li&gt;xml = XML document&lt;/li&gt;&lt;li&gt;json = JSON data structure&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fileFormat")
    protected ExtractionFileFormatType fileFormat;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define which page(s) should be used for the extraction mode. The page number can be either an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). A blank value or "*" selects all pages of the PDF document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the output format for the PDF document text contents being extracted.&#13;
     *                         &lt;ul&gt;&lt;li&gt;text = Text document&lt;/li&gt;&lt;li&gt;xml = XML document&lt;/li&gt;&lt;li&gt;json = JSON data structure&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ExtractionFileFormatType }
     *     
     */
    public ExtractionFileFormatType getFileFormat() {
        if (fileFormat == null) {
            return ExtractionFileFormatType.XML;
        } else {
            return fileFormat;
        }
    }

    /**
     * Sets the value of the fileFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtractionFileFormatType }
     *     
     * @see #getFileFormat()
     */
    public void setFileFormat(ExtractionFileFormatType value) {
        this.fileFormat = value;
    }

    public boolean isSetFileFormat() {
        return (this.fileFormat!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define which page(s) should be used for the extraction mode. The page number can be either an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). A blank value or "*" selects all pages of the PDF document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

}
