
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import net.webpdf.wsclient.schema.ParameterInterface;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The "Barcode" web service can be used to generate and recognize barcodes in PDF documents.&#13;
 *                     The &lt;code&gt;&amp;lt;add&amp;gt;&lt;/code&gt; element is used to add barcodes, while the &lt;code&gt;&amp;lt;detect&amp;gt;&lt;/code&gt; element is used to read existing barcodes.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BarcodeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BarcodeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice>
 *         <element name="add">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice maxOccurs="unbounded">
 *                   <element name="aztec" type="{http://schema.webpdf.de/1.0/operation}AztecBarcodeType"/>
 *                   <element name="codabar" type="{http://schema.webpdf.de/1.0/operation}CodabarBarcodeType"/>
 *                   <element name="code128" type="{http://schema.webpdf.de/1.0/operation}Code128BarcodeType"/>
 *                   <element name="code39" type="{http://schema.webpdf.de/1.0/operation}Code39BarcodeType"/>
 *                   <element name="datamatrix" type="{http://schema.webpdf.de/1.0/operation}DataMatrixBarcodeType"/>
 *                   <element name="ean13" type="{http://schema.webpdf.de/1.0/operation}Ean13BarcodeType"/>
 *                   <element name="ean8" type="{http://schema.webpdf.de/1.0/operation}Ean8BarcodeType"/>
 *                   <element name="itf" type="{http://schema.webpdf.de/1.0/operation}ItfBarcodeType"/>
 *                   <element name="pdf417" type="{http://schema.webpdf.de/1.0/operation}Pdf417BarcodeType"/>
 *                   <element name="qrcode" type="{http://schema.webpdf.de/1.0/operation}QrBarcodeType"/>
 *                   <element name="upca" type="{http://schema.webpdf.de/1.0/operation}UpcaBarcodeType"/>
 *                   <element name="qrswiss" type="{http://schema.webpdf.de/1.0/operation}QrSwissPaymentBarcodeType"/>
 *                 </choice>
 *                 <attribute name="outputFormat" type="{http://schema.webpdf.de/1.0/operation}BarcodeCreateOutputFormatType" default="pdf" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="detect">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice maxOccurs="unbounded">
 *                   <element name="selection" type="{http://schema.webpdf.de/1.0/operation}BarcodeSelectionType"/>
 *                 </choice>
 *                 <attribute name="outputFormat" type="{http://schema.webpdf.de/1.0/operation}BarcodeDetectOutputFormatType" default="json" />
 *                 <attribute name="inputFormat" type="{http://schema.webpdf.de/1.0/operation}BarcodeDetectInputFormatType" default="pdf" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </choice>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BarcodeType", propOrder = {
    "add",
    "detect"
})
public class BarcodeType
    implements ParameterInterface
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to add a new barcode to the document.&lt;/p&gt;
     * </pre>
     * 
     */
    protected BarcodeType.Add add;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This operation is used to define the barcode recognition parameters. The system will attempt to find barcodes inside the area defined with &lt;code&gt;&amp;lt;scanArea&amp;gt;&lt;/code&gt;. The recognition process itself is controlled with &lt;code&gt;&amp;lt;selection&amp;gt;&lt;/code&gt;.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     */
    protected BarcodeType.Detect detect;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to add a new barcode to the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BarcodeType.Add }
     *     
     */
    public BarcodeType.Add getAdd() {
        return add;
    }

    /**
     * Sets the value of the add property.
     * 
     * @param value
     *     allowed object is
     *     {@link BarcodeType.Add }
     *     
     * @see #getAdd()
     */
    public void setAdd(BarcodeType.Add value) {
        this.add = value;
    }

    public boolean isSetAdd() {
        return (this.add!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This operation is used to define the barcode recognition parameters. The system will attempt to find barcodes inside the area defined with &lt;code&gt;&amp;lt;scanArea&amp;gt;&lt;/code&gt;. The recognition process itself is controlled with &lt;code&gt;&amp;lt;selection&amp;gt;&lt;/code&gt;.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BarcodeType.Detect }
     *     
     */
    public BarcodeType.Detect getDetect() {
        return detect;
    }

    /**
     * Sets the value of the detect property.
     * 
     * @param value
     *     allowed object is
     *     {@link BarcodeType.Detect }
     *     
     * @see #getDetect()
     */
    public void setDetect(BarcodeType.Detect value) {
        this.detect = value;
    }

    public boolean isSetDetect() {
        return (this.detect!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded">
     *         <element name="aztec" type="{http://schema.webpdf.de/1.0/operation}AztecBarcodeType"/>
     *         <element name="codabar" type="{http://schema.webpdf.de/1.0/operation}CodabarBarcodeType"/>
     *         <element name="code128" type="{http://schema.webpdf.de/1.0/operation}Code128BarcodeType"/>
     *         <element name="code39" type="{http://schema.webpdf.de/1.0/operation}Code39BarcodeType"/>
     *         <element name="datamatrix" type="{http://schema.webpdf.de/1.0/operation}DataMatrixBarcodeType"/>
     *         <element name="ean13" type="{http://schema.webpdf.de/1.0/operation}Ean13BarcodeType"/>
     *         <element name="ean8" type="{http://schema.webpdf.de/1.0/operation}Ean8BarcodeType"/>
     *         <element name="itf" type="{http://schema.webpdf.de/1.0/operation}ItfBarcodeType"/>
     *         <element name="pdf417" type="{http://schema.webpdf.de/1.0/operation}Pdf417BarcodeType"/>
     *         <element name="qrcode" type="{http://schema.webpdf.de/1.0/operation}QrBarcodeType"/>
     *         <element name="upca" type="{http://schema.webpdf.de/1.0/operation}UpcaBarcodeType"/>
     *         <element name="qrswiss" type="{http://schema.webpdf.de/1.0/operation}QrSwissPaymentBarcodeType"/>
     *       </choice>
     *       <attribute name="outputFormat" type="{http://schema.webpdf.de/1.0/operation}BarcodeCreateOutputFormatType" default="pdf" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "aztec",
        "codabar",
        "code128",
        "code39",
        "datamatrix",
        "ean13",
        "ean8",
        "itf",
        "pdf417",
        "qrcode",
        "upca",
        "qrswiss"
    })
    public static class Add {

        protected List<AztecBarcodeType> aztec;
        protected List<CodabarBarcodeType> codabar;
        protected List<Code128BarcodeType> code128;
        protected List<Code39BarcodeType> code39;
        protected List<DataMatrixBarcodeType> datamatrix;
        protected List<Ean13BarcodeType> ean13;
        protected List<Ean8BarcodeType> ean8;
        protected List<ItfBarcodeType> itf;
        protected List<Pdf417BarcodeType> pdf417;
        protected List<QrBarcodeType> qrcode;
        protected List<UpcaBarcodeType> upca;
        protected List<QrSwissPaymentBarcodeType> qrswiss;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the output format for the barcode generation. The resulting document will be created by this webservice, where selected image formats will completly ignore a possibly given PDF source document and will only contain the barcode image.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
         *                                     This parameter is for internal use only. Please only set this value to anything other than "pdf", if you are really sure that you need to do so.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "outputFormat")
        protected BarcodeCreateOutputFormatType outputFormat;

        /**
         * Gets the value of the aztec property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the aztec property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getAztec().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link AztecBarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the aztec property.
         */
        public List<AztecBarcodeType> getAztec() {
            if (aztec == null) {
                aztec = new ArrayList<>();
            }
            return this.aztec;
        }

        public boolean isSetAztec() {
            return ((this.aztec!= null)&&(!this.aztec.isEmpty()));
        }

        public void unsetAztec() {
            this.aztec = null;
        }

        /**
         * Gets the value of the codabar property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the codabar property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getCodabar().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link CodabarBarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the codabar property.
         */
        public List<CodabarBarcodeType> getCodabar() {
            if (codabar == null) {
                codabar = new ArrayList<>();
            }
            return this.codabar;
        }

        public boolean isSetCodabar() {
            return ((this.codabar!= null)&&(!this.codabar.isEmpty()));
        }

        public void unsetCodabar() {
            this.codabar = null;
        }

        /**
         * Gets the value of the code128 property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the code128 property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getCode128().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link Code128BarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the code128 property.
         */
        public List<Code128BarcodeType> getCode128() {
            if (code128 == null) {
                code128 = new ArrayList<>();
            }
            return this.code128;
        }

        public boolean isSetCode128() {
            return ((this.code128 != null)&&(!this.code128 .isEmpty()));
        }

        public void unsetCode128() {
            this.code128 = null;
        }

        /**
         * Gets the value of the code39 property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the code39 property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getCode39().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link Code39BarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the code39 property.
         */
        public List<Code39BarcodeType> getCode39() {
            if (code39 == null) {
                code39 = new ArrayList<>();
            }
            return this.code39;
        }

        public boolean isSetCode39() {
            return ((this.code39 != null)&&(!this.code39 .isEmpty()));
        }

        public void unsetCode39() {
            this.code39 = null;
        }

        /**
         * Gets the value of the datamatrix property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the datamatrix property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getDatamatrix().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link DataMatrixBarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the datamatrix property.
         */
        public List<DataMatrixBarcodeType> getDatamatrix() {
            if (datamatrix == null) {
                datamatrix = new ArrayList<>();
            }
            return this.datamatrix;
        }

        public boolean isSetDatamatrix() {
            return ((this.datamatrix!= null)&&(!this.datamatrix.isEmpty()));
        }

        public void unsetDatamatrix() {
            this.datamatrix = null;
        }

        /**
         * Gets the value of the ean13 property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the ean13 property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getEan13().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link Ean13BarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the ean13 property.
         */
        public List<Ean13BarcodeType> getEan13() {
            if (ean13 == null) {
                ean13 = new ArrayList<>();
            }
            return this.ean13;
        }

        public boolean isSetEan13() {
            return ((this.ean13 != null)&&(!this.ean13 .isEmpty()));
        }

        public void unsetEan13() {
            this.ean13 = null;
        }

        /**
         * Gets the value of the ean8 property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the ean8 property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getEan8().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link Ean8BarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the ean8 property.
         */
        public List<Ean8BarcodeType> getEan8() {
            if (ean8 == null) {
                ean8 = new ArrayList<>();
            }
            return this.ean8;
        }

        public boolean isSetEan8() {
            return ((this.ean8 != null)&&(!this.ean8 .isEmpty()));
        }

        public void unsetEan8() {
            this.ean8 = null;
        }

        /**
         * Gets the value of the itf property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the itf property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getItf().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link ItfBarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the itf property.
         */
        public List<ItfBarcodeType> getItf() {
            if (itf == null) {
                itf = new ArrayList<>();
            }
            return this.itf;
        }

        public boolean isSetItf() {
            return ((this.itf!= null)&&(!this.itf.isEmpty()));
        }

        public void unsetItf() {
            this.itf = null;
        }

        /**
         * Gets the value of the pdf417 property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the pdf417 property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getPdf417().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link Pdf417BarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the pdf417 property.
         */
        public List<Pdf417BarcodeType> getPdf417() {
            if (pdf417 == null) {
                pdf417 = new ArrayList<>();
            }
            return this.pdf417;
        }

        public boolean isSetPdf417() {
            return ((this.pdf417 != null)&&(!this.pdf417 .isEmpty()));
        }

        public void unsetPdf417() {
            this.pdf417 = null;
        }

        /**
         * Gets the value of the qrcode property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the qrcode property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getQrcode().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link QrBarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the qrcode property.
         */
        public List<QrBarcodeType> getQrcode() {
            if (qrcode == null) {
                qrcode = new ArrayList<>();
            }
            return this.qrcode;
        }

        public boolean isSetQrcode() {
            return ((this.qrcode!= null)&&(!this.qrcode.isEmpty()));
        }

        public void unsetQrcode() {
            this.qrcode = null;
        }

        /**
         * Gets the value of the upca property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the upca property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getUpca().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link UpcaBarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the upca property.
         */
        public List<UpcaBarcodeType> getUpca() {
            if (upca == null) {
                upca = new ArrayList<>();
            }
            return this.upca;
        }

        public boolean isSetUpca() {
            return ((this.upca!= null)&&(!this.upca.isEmpty()));
        }

        public void unsetUpca() {
            this.upca = null;
        }

        /**
         * Gets the value of the qrswiss property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the qrswiss property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getQrswiss().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link QrSwissPaymentBarcodeType }
         * </p>
         * 
         * 
         * @return
         *     The value of the qrswiss property.
         */
        public List<QrSwissPaymentBarcodeType> getQrswiss() {
            if (qrswiss == null) {
                qrswiss = new ArrayList<>();
            }
            return this.qrswiss;
        }

        public boolean isSetQrswiss() {
            return ((this.qrswiss!= null)&&(!this.qrswiss.isEmpty()));
        }

        public void unsetQrswiss() {
            this.qrswiss = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the output format for the barcode generation. The resulting document will be created by this webservice, where selected image formats will completly ignore a possibly given PDF source document and will only contain the barcode image.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
         *                                     This parameter is for internal use only. Please only set this value to anything other than "pdf", if you are really sure that you need to do so.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link BarcodeCreateOutputFormatType }
         *     
         */
        public BarcodeCreateOutputFormatType getOutputFormat() {
            if (outputFormat == null) {
                return BarcodeCreateOutputFormatType.PDF;
            } else {
                return outputFormat;
            }
        }

        /**
         * Sets the value of the outputFormat property.
         * 
         * @param value
         *     allowed object is
         *     {@link BarcodeCreateOutputFormatType }
         *     
         * @see #getOutputFormat()
         */
        public void setOutputFormat(BarcodeCreateOutputFormatType value) {
            this.outputFormat = value;
        }

        public boolean isSetOutputFormat() {
            return (this.outputFormat!= null);
        }

    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded">
     *         <element name="selection" type="{http://schema.webpdf.de/1.0/operation}BarcodeSelectionType"/>
     *       </choice>
     *       <attribute name="outputFormat" type="{http://schema.webpdf.de/1.0/operation}BarcodeDetectOutputFormatType" default="json" />
     *       <attribute name="inputFormat" type="{http://schema.webpdf.de/1.0/operation}BarcodeDetectInputFormatType" default="pdf" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "selection"
    })
    public static class Detect {

        protected List<BarcodeSelectionType> selection;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the format in which the recognition results should be returned.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;json = JSON&lt;/li&gt;&lt;li&gt;xml = XML&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "outputFormat")
        protected BarcodeDetectOutputFormatType outputFormat;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the format of the file with the contents that will be scanned for barcodes.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;pdf = PDF document&lt;/li&gt;&lt;li&gt;img = Image document (JPG, PNG, TIF)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "inputFormat")
        protected BarcodeDetectInputFormatType inputFormat;

        /**
         * Gets the value of the selection property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the selection property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getSelection().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link BarcodeSelectionType }
         * </p>
         * 
         * 
         * @return
         *     The value of the selection property.
         */
        public List<BarcodeSelectionType> getSelection() {
            if (selection == null) {
                selection = new ArrayList<>();
            }
            return this.selection;
        }

        public boolean isSetSelection() {
            return ((this.selection!= null)&&(!this.selection.isEmpty()));
        }

        public void unsetSelection() {
            this.selection = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the format in which the recognition results should be returned.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;json = JSON&lt;/li&gt;&lt;li&gt;xml = XML&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link BarcodeDetectOutputFormatType }
         *     
         */
        public BarcodeDetectOutputFormatType getOutputFormat() {
            if (outputFormat == null) {
                return BarcodeDetectOutputFormatType.JSON;
            } else {
                return outputFormat;
            }
        }

        /**
         * Sets the value of the outputFormat property.
         * 
         * @param value
         *     allowed object is
         *     {@link BarcodeDetectOutputFormatType }
         *     
         * @see #getOutputFormat()
         */
        public void setOutputFormat(BarcodeDetectOutputFormatType value) {
            this.outputFormat = value;
        }

        public boolean isSetOutputFormat() {
            return (this.outputFormat!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the format of the file with the contents that will be scanned for barcodes.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;pdf = PDF document&lt;/li&gt;&lt;li&gt;img = Image document (JPG, PNG, TIF)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link BarcodeDetectInputFormatType }
         *     
         */
        public BarcodeDetectInputFormatType getInputFormat() {
            if (inputFormat == null) {
                return BarcodeDetectInputFormatType.PDF;
            } else {
                return inputFormat;
            }
        }

        /**
         * Sets the value of the inputFormat property.
         * 
         * @param value
         *     allowed object is
         *     {@link BarcodeDetectInputFormatType }
         *     
         * @see #getInputFormat()
         */
        public void setInputFormat(BarcodeDetectInputFormatType value) {
            this.inputFormat = value;
        }

        public boolean isSetInputFormat() {
            return (this.inputFormat!= null);
        }

    }

}
