
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This section is used to control the recognition process and configure settings that apply only to specific barcode types.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BarcodeSelectionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BarcodeSelectionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="scanArea" type="{http://schema.webpdf.de/1.0/operation}RectangleType" minOccurs="0"/>
 *       </all>
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="resolution" default="200">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="pureBarcode" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="gs1" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="tryHarder" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="allowedLengths" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="barcode39CheckDigit" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="codabarStartEndDigits" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="upcEanExtensions" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="charset" type="{http://www.w3.org/2001/XMLSchema}string" default="utf-8" />
 *       <attribute name="formats" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BarcodeSelectionType", propOrder = {

})
public class BarcodeSelectionType {

    protected RectangleType scanArea;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page range within which barcodes should be scanned. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: "1-10" or "1,2,5-10")&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the resolution for the recognition operation. Depending on the barcode's format and quality, higher or lower values may yield better results (in any case, higher values will slow down processing).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "resolution")
    protected Integer resolution;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", the system will assume that the source document being scanned (limited by &lt;code&gt;&amp;lt;scanArea&amp;gt;&lt;/code&gt;) does not contain any elements other than the barcode. This option can speed up the recognition process significantly. If, however, this option is enabled and there are elements other than a barcode, recognition may fail completely.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pureBarcode")
    protected Boolean pureBarcode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", the system will assume that all recognized barcodes are GS1-compliant barcodes, and the way all processes behave and work will be adjusted accordingly (for instance, the way in which the FNC1 character is handled for Code 128)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "gs1")
    protected Boolean gs1;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", more computing time will be invested in order to guarantee successful recognition. For example, the system will also scan for barcodes along the vertical axis.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "tryHarder")
    protected Boolean tryHarder;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set, it will limit the allowed lengths for encoded values. In other words, barcodes with a length that is not listed will be ignored. (Example: "13,8,25")&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "allowedLengths")
    protected String allowedLengths;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", the system will assume that all recognized Code 39 barcodes contain a correct check digit.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "barcode39CheckDigit")
    protected Boolean barcode39CheckDigit;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", the start and stop symbols of recognized Codabar barcodes will be read instead of removed during recognition.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "codabarStartEndDigits")
    protected Boolean codabarStartEndDigits;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set, it will limit the allowed lengths for encoded EAN and UPC Extensions. In other words, barcodes with an Extension length that is not listed will be ignored. (Example: "2,5")&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "upcEanExtensions")
    protected String upcEanExtensions;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the character set in which the barcode contents are stored.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "charset")
    protected String charset;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the list of barcodes (comma-separated) that should be searched for. There must be at least one barcode format here; otherwise, no search will be run. The names are the same as those used in &lt;code&gt;&amp;lt;add&amp;gt;&lt;/code&gt;, i.e., the following are the barcode names available:&#13;
     *                         &lt;ul&gt;&lt;li&gt;qrcode&lt;/li&gt;&lt;li&gt;aztec&lt;/li&gt;&lt;li&gt;codabar&lt;/li&gt;&lt;li&gt;code128&lt;/li&gt;&lt;li&gt;code39&lt;/li&gt;&lt;li&gt;datamatrix&lt;/li&gt;&lt;li&gt;ean13&lt;/li&gt;&lt;li&gt;ean8&lt;/li&gt;&lt;li&gt;itf&lt;/li&gt;&lt;li&gt;pdf417&lt;/li&gt;&lt;li&gt;upca&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "formats", required = true)
    protected String formats;

    /**
     * Gets the value of the scanArea property.
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getScanArea() {
        return scanArea;
    }

    /**
     * Sets the value of the scanArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     */
    public void setScanArea(RectangleType value) {
        this.scanArea = value;
    }

    public boolean isSetScanArea() {
        return (this.scanArea!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page range within which barcodes should be scanned. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: "1-10" or "1,2,5-10")&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the resolution for the recognition operation. Depending on the barcode's format and quality, higher or lower values may yield better results (in any case, higher values will slow down processing).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getResolution() {
        if (resolution == null) {
            return  200;
        } else {
            return resolution;
        }
    }

    /**
     * Sets the value of the resolution property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getResolution()
     */
    public void setResolution(int value) {
        this.resolution = value;
    }

    public boolean isSetResolution() {
        return (this.resolution!= null);
    }

    public void unsetResolution() {
        this.resolution = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", the system will assume that the source document being scanned (limited by &lt;code&gt;&amp;lt;scanArea&amp;gt;&lt;/code&gt;) does not contain any elements other than the barcode. This option can speed up the recognition process significantly. If, however, this option is enabled and there are elements other than a barcode, recognition may fail completely.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isPureBarcode() {
        if (pureBarcode == null) {
            return false;
        } else {
            return pureBarcode;
        }
    }

    /**
     * Sets the value of the pureBarcode property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isPureBarcode()
     */
    public void setPureBarcode(boolean value) {
        this.pureBarcode = value;
    }

    public boolean isSetPureBarcode() {
        return (this.pureBarcode!= null);
    }

    public void unsetPureBarcode() {
        this.pureBarcode = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", the system will assume that all recognized barcodes are GS1-compliant barcodes, and the way all processes behave and work will be adjusted accordingly (for instance, the way in which the FNC1 character is handled for Code 128)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isGs1() {
        if (gs1 == null) {
            return false;
        } else {
            return gs1;
        }
    }

    /**
     * Sets the value of the gs1 property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isGs1()
     */
    public void setGs1(boolean value) {
        this.gs1 = value;
    }

    public boolean isSetGs1() {
        return (this.gs1 != null);
    }

    public void unsetGs1() {
        this.gs1 = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", more computing time will be invested in order to guarantee successful recognition. For example, the system will also scan for barcodes along the vertical axis.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isTryHarder() {
        if (tryHarder == null) {
            return true;
        } else {
            return tryHarder;
        }
    }

    /**
     * Sets the value of the tryHarder property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isTryHarder()
     */
    public void setTryHarder(boolean value) {
        this.tryHarder = value;
    }

    public boolean isSetTryHarder() {
        return (this.tryHarder!= null);
    }

    public void unsetTryHarder() {
        this.tryHarder = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set, it will limit the allowed lengths for encoded values. In other words, barcodes with a length that is not listed will be ignored. (Example: "13,8,25")&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAllowedLengths() {
        if (allowedLengths == null) {
            return "";
        } else {
            return allowedLengths;
        }
    }

    /**
     * Sets the value of the allowedLengths property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getAllowedLengths()
     */
    public void setAllowedLengths(String value) {
        this.allowedLengths = value;
    }

    public boolean isSetAllowedLengths() {
        return (this.allowedLengths!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", the system will assume that all recognized Code 39 barcodes contain a correct check digit.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isBarcode39CheckDigit() {
        if (barcode39CheckDigit == null) {
            return false;
        } else {
            return barcode39CheckDigit;
        }
    }

    /**
     * Sets the value of the barcode39CheckDigit property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isBarcode39CheckDigit()
     */
    public void setBarcode39CheckDigit(boolean value) {
        this.barcode39CheckDigit = value;
    }

    public boolean isSetBarcode39CheckDigit() {
        return (this.barcode39CheckDigit!= null);
    }

    public void unsetBarcode39CheckDigit() {
        this.barcode39CheckDigit = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", the start and stop symbols of recognized Codabar barcodes will be read instead of removed during recognition.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCodabarStartEndDigits() {
        if (codabarStartEndDigits == null) {
            return false;
        } else {
            return codabarStartEndDigits;
        }
    }

    /**
     * Sets the value of the codabarStartEndDigits property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCodabarStartEndDigits()
     */
    public void setCodabarStartEndDigits(boolean value) {
        this.codabarStartEndDigits = value;
    }

    public boolean isSetCodabarStartEndDigits() {
        return (this.codabarStartEndDigits!= null);
    }

    public void unsetCodabarStartEndDigits() {
        this.codabarStartEndDigits = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set, it will limit the allowed lengths for encoded EAN and UPC Extensions. In other words, barcodes with an Extension length that is not listed will be ignored. (Example: "2,5")&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUpcEanExtensions() {
        if (upcEanExtensions == null) {
            return "";
        } else {
            return upcEanExtensions;
        }
    }

    /**
     * Sets the value of the upcEanExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUpcEanExtensions()
     */
    public void setUpcEanExtensions(String value) {
        this.upcEanExtensions = value;
    }

    public boolean isSetUpcEanExtensions() {
        return (this.upcEanExtensions!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the character set in which the barcode contents are stored.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCharset() {
        if (charset == null) {
            return "utf-8";
        } else {
            return charset;
        }
    }

    /**
     * Sets the value of the charset property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCharset()
     */
    public void setCharset(String value) {
        this.charset = value;
    }

    public boolean isSetCharset() {
        return (this.charset!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the list of barcodes (comma-separated) that should be searched for. There must be at least one barcode format here; otherwise, no search will be run. The names are the same as those used in &lt;code&gt;&amp;lt;add&amp;gt;&lt;/code&gt;, i.e., the following are the barcode names available:&#13;
     *                         &lt;ul&gt;&lt;li&gt;qrcode&lt;/li&gt;&lt;li&gt;aztec&lt;/li&gt;&lt;li&gt;codabar&lt;/li&gt;&lt;li&gt;code128&lt;/li&gt;&lt;li&gt;code39&lt;/li&gt;&lt;li&gt;datamatrix&lt;/li&gt;&lt;li&gt;ean13&lt;/li&gt;&lt;li&gt;ean8&lt;/li&gt;&lt;li&gt;itf&lt;/li&gt;&lt;li&gt;pdf417&lt;/li&gt;&lt;li&gt;upca&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFormats() {
        return formats;
    }

    /**
     * Sets the value of the formats property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFormats()
     */
    public void setFormats(String value) {
        this.formats = value;
    }

    public boolean isSetFormats() {
        return (this.formats!= null);
    }

}
