
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the position where the entry should be created. The path passed in "path" will be interpreted based on this value.&#13;
 *                     &lt;ul&gt;&lt;li&gt;before = An entry will be generated on the same level before the entry that was selected with "path.&lt;/li&gt;&lt;li&gt;inplace = The entry selected with "path" will be treated as a parent element and will contain the new generated entry.&lt;/li&gt;&lt;li&gt;after = An entry will be generated on the same level after the entry that was selected with "path.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for AddPositionType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="AddPositionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="before"/>
 *     <enumeration value="inplace"/>
 *     <enumeration value="after"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "AddPositionType")
@XmlEnum
public enum AddPositionType {

    @XmlEnumValue("before")
    BEFORE("before"),
    @XmlEnumValue("inplace")
    INPLACE("inplace"),
    @XmlEnumValue("after")
    AFTER("after");
    private final String value;

    AddPositionType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static AddPositionType fromValue(String v) {
        for (AddPositionType c: AddPositionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
