/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * WebserviceResultStackTraceCauseStackTraceInner
 */
@JsonPropertyOrder({
  WebserviceResultStackTraceCauseStackTraceInner.JSON_PROPERTY_CLASS_LOADER_NAME,
  WebserviceResultStackTraceCauseStackTraceInner.JSON_PROPERTY_CLASS_NAME,
  WebserviceResultStackTraceCauseStackTraceInner.JSON_PROPERTY_FILE_NAME,
  WebserviceResultStackTraceCauseStackTraceInner.JSON_PROPERTY_LINE_NUMBER,
  WebserviceResultStackTraceCauseStackTraceInner.JSON_PROPERTY_METHOD_NAME,
  WebserviceResultStackTraceCauseStackTraceInner.JSON_PROPERTY_MODULE_NAME,
  WebserviceResultStackTraceCauseStackTraceInner.JSON_PROPERTY_MODULE_VERSION,
  WebserviceResultStackTraceCauseStackTraceInner.JSON_PROPERTY_NATIVE_METHOD
})
@JsonTypeName("Webservice_Result_stackTrace_cause_stackTrace_inner")

public class WebserviceResultStackTraceCauseStackTraceInner {
  public static final String JSON_PROPERTY_CLASS_LOADER_NAME = "classLoaderName";
  private String classLoaderName;

  public static final String JSON_PROPERTY_CLASS_NAME = "className";
  private String className;

  public static final String JSON_PROPERTY_FILE_NAME = "fileName";
  private String fileName;

  public static final String JSON_PROPERTY_LINE_NUMBER = "lineNumber";
  private Integer lineNumber;

  public static final String JSON_PROPERTY_METHOD_NAME = "methodName";
  private String methodName;

  public static final String JSON_PROPERTY_MODULE_NAME = "moduleName";
  private String moduleName;

  public static final String JSON_PROPERTY_MODULE_VERSION = "moduleVersion";
  private String moduleVersion;

  public static final String JSON_PROPERTY_NATIVE_METHOD = "nativeMethod";
  private Boolean nativeMethod;

  public WebserviceResultStackTraceCauseStackTraceInner() {
  }

  public WebserviceResultStackTraceCauseStackTraceInner classLoaderName(String classLoaderName) {
    
    this.classLoaderName = classLoaderName;
    return this;
  }

  /**
   * Get classLoaderName
   * @return classLoaderName
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CLASS_LOADER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClassLoaderName() {
    return classLoaderName;
  }


  @JsonProperty(JSON_PROPERTY_CLASS_LOADER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClassLoaderName(String classLoaderName) {
    this.classLoaderName = classLoaderName;
  }


  public WebserviceResultStackTraceCauseStackTraceInner className(String className) {
    
    this.className = className;
    return this;
  }

  /**
   * Get className
   * @return className
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CLASS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClassName() {
    return className;
  }


  @JsonProperty(JSON_PROPERTY_CLASS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClassName(String className) {
    this.className = className;
  }


  public WebserviceResultStackTraceCauseStackTraceInner fileName(String fileName) {
    
    this.fileName = fileName;
    return this;
  }

  /**
   * Get fileName
   * @return fileName
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileName() {
    return fileName;
  }


  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }


  public WebserviceResultStackTraceCauseStackTraceInner lineNumber(Integer lineNumber) {
    
    this.lineNumber = lineNumber;
    return this;
  }

  /**
   * Get lineNumber
   * @return lineNumber
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_LINE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLineNumber() {
    return lineNumber;
  }


  @JsonProperty(JSON_PROPERTY_LINE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineNumber(Integer lineNumber) {
    this.lineNumber = lineNumber;
  }


  public WebserviceResultStackTraceCauseStackTraceInner methodName(String methodName) {
    
    this.methodName = methodName;
    return this;
  }

  /**
   * Get methodName
   * @return methodName
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_METHOD_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMethodName() {
    return methodName;
  }


  @JsonProperty(JSON_PROPERTY_METHOD_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMethodName(String methodName) {
    this.methodName = methodName;
  }


  public WebserviceResultStackTraceCauseStackTraceInner moduleName(String moduleName) {
    
    this.moduleName = moduleName;
    return this;
  }

  /**
   * Get moduleName
   * @return moduleName
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_MODULE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getModuleName() {
    return moduleName;
  }


  @JsonProperty(JSON_PROPERTY_MODULE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModuleName(String moduleName) {
    this.moduleName = moduleName;
  }


  public WebserviceResultStackTraceCauseStackTraceInner moduleVersion(String moduleVersion) {
    
    this.moduleVersion = moduleVersion;
    return this;
  }

  /**
   * Get moduleVersion
   * @return moduleVersion
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_MODULE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getModuleVersion() {
    return moduleVersion;
  }


  @JsonProperty(JSON_PROPERTY_MODULE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModuleVersion(String moduleVersion) {
    this.moduleVersion = moduleVersion;
  }


  public WebserviceResultStackTraceCauseStackTraceInner nativeMethod(Boolean nativeMethod) {
    
    this.nativeMethod = nativeMethod;
    return this;
  }

  /**
   * Get nativeMethod
   * @return nativeMethod
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_NATIVE_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getNativeMethod() {
    return nativeMethod;
  }


  @JsonProperty(JSON_PROPERTY_NATIVE_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNativeMethod(Boolean nativeMethod) {
    this.nativeMethod = nativeMethod;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebserviceResultStackTraceCauseStackTraceInner webserviceResultStackTraceCauseStackTraceInner = (WebserviceResultStackTraceCauseStackTraceInner) o;
    return Objects.equals(this.classLoaderName, webserviceResultStackTraceCauseStackTraceInner.classLoaderName) &&
        Objects.equals(this.className, webserviceResultStackTraceCauseStackTraceInner.className) &&
        Objects.equals(this.fileName, webserviceResultStackTraceCauseStackTraceInner.fileName) &&
        Objects.equals(this.lineNumber, webserviceResultStackTraceCauseStackTraceInner.lineNumber) &&
        Objects.equals(this.methodName, webserviceResultStackTraceCauseStackTraceInner.methodName) &&
        Objects.equals(this.moduleName, webserviceResultStackTraceCauseStackTraceInner.moduleName) &&
        Objects.equals(this.moduleVersion, webserviceResultStackTraceCauseStackTraceInner.moduleVersion) &&
        Objects.equals(this.nativeMethod, webserviceResultStackTraceCauseStackTraceInner.nativeMethod);
  }

  @Override
  public int hashCode() {
    return Objects.hash(classLoaderName, className, fileName, lineNumber, methodName, moduleName, moduleVersion, nativeMethod);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebserviceResultStackTraceCauseStackTraceInner {\n");
    sb.append("    classLoaderName: ").append(toIndentedString(classLoaderName)).append("\n");
    sb.append("    className: ").append(toIndentedString(className)).append("\n");
    sb.append("    fileName: ").append(toIndentedString(fileName)).append("\n");
    sb.append("    lineNumber: ").append(toIndentedString(lineNumber)).append("\n");
    sb.append("    methodName: ").append(toIndentedString(methodName)).append("\n");
    sb.append("    moduleName: ").append(toIndentedString(moduleName)).append("\n");
    sb.append("    moduleVersion: ").append(toIndentedString(moduleVersion)).append("\n");
    sb.append("    nativeMethod: ").append(toIndentedString(nativeMethod)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
