/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * General information about the sessions and detailed information about each session.
 */
@Schema(description = "General information about the sessions and detailed information about each session.")
@JsonPropertyOrder({
  SessionTable.JSON_PROPERTY_ACTIVE_SESSIONS,
  SessionTable.JSON_PROPERTY_EXPIRED_SESSIONS,
  SessionTable.JSON_PROPERTY_SESSION_COUNT,
  SessionTable.JSON_PROPERTY_SESSION_DISK_USAGE,
  SessionTable.JSON_PROPERTY_SESSION_ID,
  SessionTable.JSON_PROPERTY_SESSION_LIST,
  SessionTable.JSON_PROPERTY_TIMESTAMP,
  SessionTable.JSON_PROPERTY_UNSTABLE_SESSIONS
})
@JsonTypeName("Session_Table")

public class SessionTable {
  public static final String JSON_PROPERTY_ACTIVE_SESSIONS = "activeSessions";
  private Long activeSessions = 0l;

  public static final String JSON_PROPERTY_EXPIRED_SESSIONS = "expiredSessions";
  private Long expiredSessions = 0l;

  public static final String JSON_PROPERTY_SESSION_COUNT = "sessionCount";
  private Long sessionCount = 0l;

  public static final String JSON_PROPERTY_SESSION_DISK_USAGE = "sessionDiskUsage";
  private Long sessionDiskUsage = 0l;

  public static final String JSON_PROPERTY_SESSION_ID = "sessionId";
  private String sessionId = "";

  public static final String JSON_PROPERTY_SESSION_LIST = "sessionList";
  private List<SessionTableEntry> sessionList = null;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private Long timestamp = 0l;

  public static final String JSON_PROPERTY_UNSTABLE_SESSIONS = "unstableSessions";
  private Long unstableSessions = 0l;

  public SessionTable() {
  }

  public SessionTable activeSessions(Long activeSessions) {
    
    this.activeSessions = activeSessions;
    return this;
  }

  /**
   * Total number of active sessions.
   * @return activeSessions
   **/
  @Nullable
  @Schema(name = "Total number of active sessions.")
  @JsonProperty(JSON_PROPERTY_ACTIVE_SESSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getActiveSessions() {
    return activeSessions;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_SESSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActiveSessions(Long activeSessions) {
    this.activeSessions = activeSessions;
  }


  public SessionTable expiredSessions(Long expiredSessions) {
    
    this.expiredSessions = expiredSessions;
    return this;
  }

  /**
   * Total number of expired sessions.
   * @return expiredSessions
   **/
  @Nullable
  @Schema(name = "Total number of expired sessions.")
  @JsonProperty(JSON_PROPERTY_EXPIRED_SESSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getExpiredSessions() {
    return expiredSessions;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRED_SESSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiredSessions(Long expiredSessions) {
    this.expiredSessions = expiredSessions;
  }


  public SessionTable sessionCount(Long sessionCount) {
    
    this.sessionCount = sessionCount;
    return this;
  }

  /**
   * Total number of sessions.
   * @return sessionCount
   **/
  @Nullable
  @Schema(name = "Total number of sessions.")
  @JsonProperty(JSON_PROPERTY_SESSION_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSessionCount() {
    return sessionCount;
  }


  @JsonProperty(JSON_PROPERTY_SESSION_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionCount(Long sessionCount) {
    this.sessionCount = sessionCount;
  }


  public SessionTable sessionDiskUsage(Long sessionDiskUsage) {
    
    this.sessionDiskUsage = sessionDiskUsage;
    return this;
  }

  /**
   * Total size in bytes required by all sessions together on the hard disk in the base folder.
   * @return sessionDiskUsage
   **/
  @Nullable
  @Schema(name = "Total size in bytes required by all sessions together on the hard disk in the base folder.")
  @JsonProperty(JSON_PROPERTY_SESSION_DISK_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSessionDiskUsage() {
    return sessionDiskUsage;
  }


  @JsonProperty(JSON_PROPERTY_SESSION_DISK_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionDiskUsage(Long sessionDiskUsage) {
    this.sessionDiskUsage = sessionDiskUsage;
  }


  public SessionTable sessionId(String sessionId) {
    
    this.sessionId = sessionId;
    return this;
  }

  /**
   * Session ID of the session that requested the session table.
   * @return sessionId
   **/
  @Nullable
  @Schema(name = "Session ID of the session that requested the session table.")
  @JsonProperty(JSON_PROPERTY_SESSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSessionId() {
    return sessionId;
  }


  @JsonProperty(JSON_PROPERTY_SESSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }


  public SessionTable sessionList(List<SessionTableEntry> sessionList) {
    
    this.sessionList = sessionList;
    return this;
  }

  public SessionTable addSessionListItem(SessionTableEntry sessionListItem) {
    if (this.sessionList == null) {
        this.sessionList = new ArrayList<>();
    }
    this.sessionList.add(sessionListItem);
    return this;
  }

  /**
   * List of all sessions and detailed information about each session.
   * @return sessionList
   **/
  @Nullable
  @Schema(name = "List of all sessions and detailed information about each session.")
  @JsonProperty(JSON_PROPERTY_SESSION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SessionTableEntry> getSessionList() {
    return sessionList;
  }


  @JsonProperty(JSON_PROPERTY_SESSION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionList(List<SessionTableEntry> sessionList) {
    this.sessionList = sessionList;
  }


  public SessionTable timestamp(Long timestamp) {
    
    this.timestamp = timestamp;
    return this;
  }

  /**
   * UTC time when the query was executed.
   * @return timestamp
   **/
  @Nullable
  @Schema(name = "UTC time when the query was executed.")
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimestamp() {
    return timestamp;
  }


  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }


  public SessionTable unstableSessions(Long unstableSessions) {
    
    this.unstableSessions = unstableSessions;
    return this;
  }

  /**
   * Total number of sessions that have not yet been initialized or are currently expiring.
   * @return unstableSessions
   **/
  @Nullable
  @Schema(name = "Total number of sessions that have not yet been initialized or are currently expiring.")
  @JsonProperty(JSON_PROPERTY_UNSTABLE_SESSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUnstableSessions() {
    return unstableSessions;
  }


  @JsonProperty(JSON_PROPERTY_UNSTABLE_SESSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnstableSessions(Long unstableSessions) {
    this.unstableSessions = unstableSessions;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SessionTable sessionTable = (SessionTable) o;
    return Objects.equals(this.activeSessions, sessionTable.activeSessions) &&
        Objects.equals(this.expiredSessions, sessionTable.expiredSessions) &&
        Objects.equals(this.sessionCount, sessionTable.sessionCount) &&
        Objects.equals(this.sessionDiskUsage, sessionTable.sessionDiskUsage) &&
        Objects.equals(this.sessionId, sessionTable.sessionId) &&
        Objects.equals(this.sessionList, sessionTable.sessionList) &&
        Objects.equals(this.timestamp, sessionTable.timestamp) &&
        Objects.equals(this.unstableSessions, sessionTable.unstableSessions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activeSessions, expiredSessions, sessionCount, sessionDiskUsage, sessionId, sessionList, timestamp, unstableSessions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SessionTable {\n");
    sb.append("    activeSessions: ").append(toIndentedString(activeSessions)).append("\n");
    sb.append("    expiredSessions: ").append(toIndentedString(expiredSessions)).append("\n");
    sb.append("    sessionCount: ").append(toIndentedString(sessionCount)).append("\n");
    sb.append("    sessionDiskUsage: ").append(toIndentedString(sessionDiskUsage)).append("\n");
    sb.append("    sessionId: ").append(toIndentedString(sessionId)).append("\n");
    sb.append("    sessionList: ").append(toIndentedString(sessionList)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    unstableSessions: ").append(toIndentedString(unstableSessions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
