/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Allows to change PDF reader specific settings and dialog defaults.  **Important:** Whether these parameters actually have an effect, depends directly on their support in the application used to display the PDF.  **Important:** Only few of those settings are actually \&quot;enforced\&quot; and most PDF readers will provide the viewer with the means to circumvent or even alter those settings.
 */
@Schema(description = "Allows to change PDF reader specific settings and dialog defaults.  **Important:** Whether these parameters actually have an effect, depends directly on their support in the application used to display the PDF.  **Important:** Only few of those settings are actually \"enforced\" and most PDF readers will provide the viewer with the means to circumvent or even alter those settings.")
@JsonPropertyOrder({
  OperationViewerPreferences.JSON_PROPERTY_CENTER_WINDOW,
  OperationViewerPreferences.JSON_PROPERTY_DISPLAY_DOC_TITLE,
  OperationViewerPreferences.JSON_PROPERTY_DUPLEX,
  OperationViewerPreferences.JSON_PROPERTY_FIT_WINDOW,
  OperationViewerPreferences.JSON_PROPERTY_HIDE_MENU_BAR,
  OperationViewerPreferences.JSON_PROPERTY_HIDE_TOOLBAR,
  OperationViewerPreferences.JSON_PROPERTY_HIDE_WINDOW_U_I,
  OperationViewerPreferences.JSON_PROPERTY_NON_FULL_SCREEN_PAGE_MODE,
  OperationViewerPreferences.JSON_PROPERTY_NUM_COPIES,
  OperationViewerPreferences.JSON_PROPERTY_PRINT_AREA,
  OperationViewerPreferences.JSON_PROPERTY_PRINT_CLIP,
  OperationViewerPreferences.JSON_PROPERTY_PRINT_PAGE_RANGE,
  OperationViewerPreferences.JSON_PROPERTY_PRINT_SCALING,
  OperationViewerPreferences.JSON_PROPERTY_PRINT_TRAY_SELECTION,
  OperationViewerPreferences.JSON_PROPERTY_TEXT_DIRECTION,
  OperationViewerPreferences.JSON_PROPERTY_VIEW_AREA,
  OperationViewerPreferences.JSON_PROPERTY_VIEW_CLIP
})
@JsonTypeName("Operation_ViewerPreferences")

public class OperationViewerPreferences {
  public static final String JSON_PROPERTY_CENTER_WINDOW = "centerWindow";
  private Boolean centerWindow = false;

  public static final String JSON_PROPERTY_DISPLAY_DOC_TITLE = "displayDocTitle";
  private Boolean displayDocTitle = false;

  /**
   * Sets whether and how pages are to be printed on both sides. (This setting is only a dialog default and can be changed by the user at any time).  *   simplex &#x3D; Print on one side. *   duplexFlipLongEdge &#x3D; Print on both sides and flip over the longer edge of the page. *   duplexFlipShortEdge &#x3D; Print on both sides and flip over the shorter side edge. *   none &#x3D; Use the default settings of the display program.
   */
  public enum DuplexEnum {
    NONE(String.valueOf("none")),
    
    SIMPLEX(String.valueOf("simplex")),
    
    DUPLEX_FLIP_SHORT_EDGE(String.valueOf("duplexFlipShortEdge")),
    
    DUPLEX_FLIP_LONG_EDGE(String.valueOf("duplexFlipLongEdge"));

    private String value;

    DuplexEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DuplexEnum fromValue(String value) {
      for (DuplexEnum b : DuplexEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DUPLEX = "duplex";
  private DuplexEnum duplex = DuplexEnum.NONE;

  public static final String JSON_PROPERTY_FIT_WINDOW = "fitWindow";
  private Boolean fitWindow = false;

  public static final String JSON_PROPERTY_HIDE_MENU_BAR = "hideMenuBar";
  private Boolean hideMenuBar = false;

  public static final String JSON_PROPERTY_HIDE_TOOLBAR = "hideToolbar";
  private Boolean hideToolbar = false;

  public static final String JSON_PROPERTY_HIDE_WINDOW_U_I = "hideWindowUI";
  private Boolean hideWindowUI = false;

  /**
   * Konfiguriert die Anzeige des Dokuments, wenn das Dokument nicht im Vollbildmodus betrachtet wird. Dies konfiguriert in erste Linie welche Navigationsansicht für den Betrachter geöffnet werden soll.  *   none &#x3D; Weder die Inhaltsübersicht, noch die Miniaturansicht der Seiten sollen angezeigt werden. *   outlines &#x3D; Die Inhaltsübersicht des Dokuments soll angezeigt werden. *   thumbnails &#x3D; Die Miniaturansicht der Seiten des Dokuments soll angezeigt werden. *   optionalContents &#x3D; Die Layer (Optional Content Groups) des Dokuments sollen angezeigt werden.
   */
  public enum NonFullScreenPageModeEnum {
    NONE(String.valueOf("none")),
    
    OUTLINES(String.valueOf("outlines")),
    
    THUMBNAILS(String.valueOf("thumbnails")),
    
    OPTIONAL_CONTENTS(String.valueOf("optionalContents"));

    private String value;

    NonFullScreenPageModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonFullScreenPageModeEnum fromValue(String value) {
      for (NonFullScreenPageModeEnum b : NonFullScreenPageModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_FULL_SCREEN_PAGE_MODE = "nonFullScreenPageMode";
  private NonFullScreenPageModeEnum nonFullScreenPageMode = NonFullScreenPageModeEnum.NONE;

  public static final String JSON_PROPERTY_NUM_COPIES = "numCopies";
  private Integer numCopies = 1;

  /**
   * Used to select the box that should be scaled.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   */
  public enum PrintAreaEnum {
    MEDIA_BOX(String.valueOf("media_box")),
    
    CROP_BOX(String.valueOf("crop_box")),
    
    BLEED_BOX(String.valueOf("bleed_box")),
    
    TRIM_BOX(String.valueOf("trim_box")),
    
    ART_BOX(String.valueOf("art_box"));

    private String value;

    PrintAreaEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PrintAreaEnum fromValue(String value) {
      for (PrintAreaEnum b : PrintAreaEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRINT_AREA = "printArea";
  private PrintAreaEnum printArea = PrintAreaEnum.CROP_BOX;

  /**
   * Used to select the box that should be scaled.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   */
  public enum PrintClipEnum {
    MEDIA_BOX(String.valueOf("media_box")),
    
    CROP_BOX(String.valueOf("crop_box")),
    
    BLEED_BOX(String.valueOf("bleed_box")),
    
    TRIM_BOX(String.valueOf("trim_box")),
    
    ART_BOX(String.valueOf("art_box"));

    private String value;

    PrintClipEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PrintClipEnum fromValue(String value) {
      for (PrintClipEnum b : PrintClipEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRINT_CLIP = "printClip";
  private PrintClipEnum printClip = PrintClipEnum.CROP_BOX;

  public static final String JSON_PROPERTY_PRINT_PAGE_RANGE = "printPageRange";
  private String printPageRange = "";

  /**
   * Selects the page  *   scaling mode for printouts of the document. (This setting is only a dialog default and can be changed by the user at any time). *   readerDefault &#x3D; Use the scaling functions provided by the display program. *   noPrintScaling &#x3D; Do no page scaling and print the pages in original size.
   */
  public enum PrintScalingEnum {
    READER_DEFAULT(String.valueOf("readerDefault")),
    
    NO_PRINT_SCALING(String.valueOf("noPrintScaling"));

    private String value;

    PrintScalingEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PrintScalingEnum fromValue(String value) {
      for (PrintScalingEnum b : PrintScalingEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRINT_SCALING = "printScaling";
  private PrintScalingEnum printScaling = PrintScalingEnum.READER_DEFAULT;

  /**
   * Selects the default setting for how print trays should be selected for printing the pages of the document. (This setting is only a dialog default and can be changed by the user at any time).  *   readerDefault &#x3D; Use the default settings of the display program. *   byPDFSize &#x3D; Try to determine the necessary paper size and the used print tray automatically based on the size of the pages of the document.
   */
  public enum PrintTraySelectionEnum {
    READER_DEFAULT(String.valueOf("readerDefault")),
    
    BY_PDF_SIZE(String.valueOf("byPDFSize"));

    private String value;

    PrintTraySelectionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PrintTraySelectionEnum fromValue(String value) {
      for (PrintTraySelectionEnum b : PrintTraySelectionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRINT_TRAY_SELECTION = "printTraySelection";
  private PrintTraySelectionEnum printTraySelection = PrintTraySelectionEnum.READER_DEFAULT;

  /**
   * Specifies the text reading direction for the display program&#39;s read aloud.  *   leftToRight &#x3D; From left to right. *   rightToLeft &#x3D; From right to left. (Including vertical fonts, such as: Chinese, Japanese, Korean, etc.).
   */
  public enum TextDirectionEnum {
    LEFT_TO_RIGHT(String.valueOf("leftToRight")),
    
    RIGHT_TO_LEFT(String.valueOf("rightToLeft"));

    private String value;

    TextDirectionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TextDirectionEnum fromValue(String value) {
      for (TextDirectionEnum b : TextDirectionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TEXT_DIRECTION = "textDirection";
  private TextDirectionEnum textDirection = TextDirectionEnum.LEFT_TO_RIGHT;

  /**
   * Used to select the box that should be scaled.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   */
  public enum ViewAreaEnum {
    MEDIA_BOX(String.valueOf("media_box")),
    
    CROP_BOX(String.valueOf("crop_box")),
    
    BLEED_BOX(String.valueOf("bleed_box")),
    
    TRIM_BOX(String.valueOf("trim_box")),
    
    ART_BOX(String.valueOf("art_box"));

    private String value;

    ViewAreaEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ViewAreaEnum fromValue(String value) {
      for (ViewAreaEnum b : ViewAreaEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VIEW_AREA = "viewArea";
  private ViewAreaEnum viewArea = ViewAreaEnum.CROP_BOX;

  /**
   * Used to select the box that should be scaled.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   */
  public enum ViewClipEnum {
    MEDIA_BOX(String.valueOf("media_box")),
    
    CROP_BOX(String.valueOf("crop_box")),
    
    BLEED_BOX(String.valueOf("bleed_box")),
    
    TRIM_BOX(String.valueOf("trim_box")),
    
    ART_BOX(String.valueOf("art_box"));

    private String value;

    ViewClipEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ViewClipEnum fromValue(String value) {
      for (ViewClipEnum b : ViewClipEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VIEW_CLIP = "viewClip";
  private ViewClipEnum viewClip = ViewClipEnum.CROP_BOX;

  public OperationViewerPreferences() {
  }

  public OperationViewerPreferences centerWindow(Boolean centerWindow) {
    
    this.centerWindow = centerWindow;
    return this;
  }

  /**
   * If true, the PDF reader window is moved to the center of the screen.
   * @return centerWindow
   **/
  @Nullable
  @Schema(name = "If true, the PDF reader window is moved to the center of the screen.")
  @JsonProperty(JSON_PROPERTY_CENTER_WINDOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCenterWindow() {
    return centerWindow;
  }


  @JsonProperty(JSON_PROPERTY_CENTER_WINDOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCenterWindow(Boolean centerWindow) {
    this.centerWindow = centerWindow;
  }


  public OperationViewerPreferences displayDocTitle(Boolean displayDocTitle) {
    
    this.displayDocTitle = displayDocTitle;
    return this;
  }

  /**
   * If true, the document title of the document is displayed in the title bar of the PDF reader instead of the file name.
   * @return displayDocTitle
   **/
  @Nullable
  @Schema(name = "If true, the document title of the document is displayed in the title bar of the PDF reader instead of the file name.")
  @JsonProperty(JSON_PROPERTY_DISPLAY_DOC_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDisplayDocTitle() {
    return displayDocTitle;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_DOC_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayDocTitle(Boolean displayDocTitle) {
    this.displayDocTitle = displayDocTitle;
  }


  public OperationViewerPreferences duplex(DuplexEnum duplex) {
    
    this.duplex = duplex;
    return this;
  }

  /**
   * Sets whether and how pages are to be printed on both sides. (This setting is only a dialog default and can be changed by the user at any time).  *   simplex &#x3D; Print on one side. *   duplexFlipLongEdge &#x3D; Print on both sides and flip over the longer edge of the page. *   duplexFlipShortEdge &#x3D; Print on both sides and flip over the shorter side edge. *   none &#x3D; Use the default settings of the display program.
   * @return duplex
   **/
  @Nullable
  @Schema(name = "Sets whether and how pages are to be printed on both sides. (This setting is only a dialog default and can be changed by the user at any time).  *   simplex = Print on one side. *   duplexFlipLongEdge = Print on both sides and flip over the longer edge of the page. *   duplexFlipShortEdge = Print on both sides and flip over the shorter side edge. *   none = Use the default settings of the display program.")
  @JsonProperty(JSON_PROPERTY_DUPLEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DuplexEnum getDuplex() {
    return duplex;
  }


  @JsonProperty(JSON_PROPERTY_DUPLEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDuplex(DuplexEnum duplex) {
    this.duplex = duplex;
  }


  public OperationViewerPreferences fitWindow(Boolean fitWindow) {
    
    this.fitWindow = fitWindow;
    return this;
  }

  /**
   * If true, the window size of the PDF reader will be tried to fit the first page of the document.
   * @return fitWindow
   **/
  @Nullable
  @Schema(name = "If true, the window size of the PDF reader will be tried to fit the first page of the document.")
  @JsonProperty(JSON_PROPERTY_FIT_WINDOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFitWindow() {
    return fitWindow;
  }


  @JsonProperty(JSON_PROPERTY_FIT_WINDOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFitWindow(Boolean fitWindow) {
    this.fitWindow = fitWindow;
  }


  public OperationViewerPreferences hideMenuBar(Boolean hideMenuBar) {
    
    this.hideMenuBar = hideMenuBar;
    return this;
  }

  /**
   * If true, the menu bars of the PDF reader are hidden for the display of this document.
   * @return hideMenuBar
   **/
  @Nullable
  @Schema(name = "If true, the menu bars of the PDF reader are hidden for the display of this document.")
  @JsonProperty(JSON_PROPERTY_HIDE_MENU_BAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHideMenuBar() {
    return hideMenuBar;
  }


  @JsonProperty(JSON_PROPERTY_HIDE_MENU_BAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideMenuBar(Boolean hideMenuBar) {
    this.hideMenuBar = hideMenuBar;
  }


  public OperationViewerPreferences hideToolbar(Boolean hideToolbar) {
    
    this.hideToolbar = hideToolbar;
    return this;
  }

  /**
   * If true, the toolbars of the PDF reader are hidden for the display of this document.
   * @return hideToolbar
   **/
  @Nullable
  @Schema(name = "If true, the toolbars of the PDF reader are hidden for the display of this document.")
  @JsonProperty(JSON_PROPERTY_HIDE_TOOLBAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHideToolbar() {
    return hideToolbar;
  }


  @JsonProperty(JSON_PROPERTY_HIDE_TOOLBAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideToolbar(Boolean hideToolbar) {
    this.hideToolbar = hideToolbar;
  }


  public OperationViewerPreferences hideWindowUI(Boolean hideWindowUI) {
    
    this.hideWindowUI = hideWindowUI;
    return this;
  }

  /**
   * If true, the scrollbars and other navigation features of the PDF reader are hidden for the display of this document.
   * @return hideWindowUI
   **/
  @Nullable
  @Schema(name = "If true, the scrollbars and other navigation features of the PDF reader are hidden for the display of this document.")
  @JsonProperty(JSON_PROPERTY_HIDE_WINDOW_U_I)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHideWindowUI() {
    return hideWindowUI;
  }


  @JsonProperty(JSON_PROPERTY_HIDE_WINDOW_U_I)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideWindowUI(Boolean hideWindowUI) {
    this.hideWindowUI = hideWindowUI;
  }


  public OperationViewerPreferences nonFullScreenPageMode(NonFullScreenPageModeEnum nonFullScreenPageMode) {
    
    this.nonFullScreenPageMode = nonFullScreenPageMode;
    return this;
  }

  /**
   * Konfiguriert die Anzeige des Dokuments, wenn das Dokument nicht im Vollbildmodus betrachtet wird. Dies konfiguriert in erste Linie welche Navigationsansicht für den Betrachter geöffnet werden soll.  *   none &#x3D; Weder die Inhaltsübersicht, noch die Miniaturansicht der Seiten sollen angezeigt werden. *   outlines &#x3D; Die Inhaltsübersicht des Dokuments soll angezeigt werden. *   thumbnails &#x3D; Die Miniaturansicht der Seiten des Dokuments soll angezeigt werden. *   optionalContents &#x3D; Die Layer (Optional Content Groups) des Dokuments sollen angezeigt werden.
   * @return nonFullScreenPageMode
   **/
  @Nullable
  @Schema(name = "Konfiguriert die Anzeige des Dokuments, wenn das Dokument nicht im Vollbildmodus betrachtet wird. Dies konfiguriert in erste Linie welche Navigationsansicht für den Betrachter geöffnet werden soll.  *   none = Weder die Inhaltsübersicht, noch die Miniaturansicht der Seiten sollen angezeigt werden. *   outlines = Die Inhaltsübersicht des Dokuments soll angezeigt werden. *   thumbnails = Die Miniaturansicht der Seiten des Dokuments soll angezeigt werden. *   optionalContents = Die Layer (Optional Content Groups) des Dokuments sollen angezeigt werden.")
  @JsonProperty(JSON_PROPERTY_NON_FULL_SCREEN_PAGE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonFullScreenPageModeEnum getNonFullScreenPageMode() {
    return nonFullScreenPageMode;
  }


  @JsonProperty(JSON_PROPERTY_NON_FULL_SCREEN_PAGE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonFullScreenPageMode(NonFullScreenPageModeEnum nonFullScreenPageMode) {
    this.nonFullScreenPageMode = nonFullScreenPageMode;
  }


  public OperationViewerPreferences numCopies(Integer numCopies) {
    
    this.numCopies = numCopies;
    return this;
  }

  /**
   * Specifies how many copies of the document are to be printed. (This setting is only a dialog default and can be changed by the user at any time).
   * minimum: 1
   * @return numCopies
   **/
  @Nullable
  @Schema(name = "Specifies how many copies of the document are to be printed. (This setting is only a dialog default and can be changed by the user at any time).")
  @JsonProperty(JSON_PROPERTY_NUM_COPIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumCopies() {
    return numCopies;
  }


  @JsonProperty(JSON_PROPERTY_NUM_COPIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumCopies(Integer numCopies) {
    this.numCopies = numCopies;
  }


  public OperationViewerPreferences printArea(PrintAreaEnum printArea) {
    
    this.printArea = printArea;
    return this;
  }

  /**
   * Used to select the box that should be scaled.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   * @return printArea
   **/
  @Nullable
  @Schema(name = "Used to select the box that should be scaled.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
  @JsonProperty(JSON_PROPERTY_PRINT_AREA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrintAreaEnum getPrintArea() {
    return printArea;
  }


  @JsonProperty(JSON_PROPERTY_PRINT_AREA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintArea(PrintAreaEnum printArea) {
    this.printArea = printArea;
  }


  public OperationViewerPreferences printClip(PrintClipEnum printClip) {
    
    this.printClip = printClip;
    return this;
  }

  /**
   * Used to select the box that should be scaled.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   * @return printClip
   **/
  @Nullable
  @Schema(name = "Used to select the box that should be scaled.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
  @JsonProperty(JSON_PROPERTY_PRINT_CLIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrintClipEnum getPrintClip() {
    return printClip;
  }


  @JsonProperty(JSON_PROPERTY_PRINT_CLIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintClip(PrintClipEnum printClip) {
    this.printClip = printClip;
  }


  public OperationViewerPreferences printPageRange(String printPageRange) {
    
    this.printPageRange = printPageRange;
    return this;
  }

  /**
   * Specifies which page(s) to print. For the page number, either a single page, a range of pages or a list (separated by commas) can be specified (e.g. \&quot;1,5-6,9\&quot;). The specification of all pages is done with \&quot;\\*\&quot;. (This setting is only a dialog default and can be changed by the user at any time).
   * @return printPageRange
   **/
  @Nullable
  @Schema(name = "Specifies which page(s) to print. For the page number, either a single page, a range of pages or a list (separated by commas) can be specified (e.g. \"1,5-6,9\"). The specification of all pages is done with \"\\*\". (This setting is only a dialog default and can be changed by the user at any time).")
  @JsonProperty(JSON_PROPERTY_PRINT_PAGE_RANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrintPageRange() {
    return printPageRange;
  }


  @JsonProperty(JSON_PROPERTY_PRINT_PAGE_RANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintPageRange(String printPageRange) {
    this.printPageRange = printPageRange;
  }


  public OperationViewerPreferences printScaling(PrintScalingEnum printScaling) {
    
    this.printScaling = printScaling;
    return this;
  }

  /**
   * Selects the page  *   scaling mode for printouts of the document. (This setting is only a dialog default and can be changed by the user at any time). *   readerDefault &#x3D; Use the scaling functions provided by the display program. *   noPrintScaling &#x3D; Do no page scaling and print the pages in original size.
   * @return printScaling
   **/
  @Nullable
  @Schema(name = "Selects the page  *   scaling mode for printouts of the document. (This setting is only a dialog default and can be changed by the user at any time). *   readerDefault = Use the scaling functions provided by the display program. *   noPrintScaling = Do no page scaling and print the pages in original size.")
  @JsonProperty(JSON_PROPERTY_PRINT_SCALING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrintScalingEnum getPrintScaling() {
    return printScaling;
  }


  @JsonProperty(JSON_PROPERTY_PRINT_SCALING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintScaling(PrintScalingEnum printScaling) {
    this.printScaling = printScaling;
  }


  public OperationViewerPreferences printTraySelection(PrintTraySelectionEnum printTraySelection) {
    
    this.printTraySelection = printTraySelection;
    return this;
  }

  /**
   * Selects the default setting for how print trays should be selected for printing the pages of the document. (This setting is only a dialog default and can be changed by the user at any time).  *   readerDefault &#x3D; Use the default settings of the display program. *   byPDFSize &#x3D; Try to determine the necessary paper size and the used print tray automatically based on the size of the pages of the document.
   * @return printTraySelection
   **/
  @Nullable
  @Schema(name = "Selects the default setting for how print trays should be selected for printing the pages of the document. (This setting is only a dialog default and can be changed by the user at any time).  *   readerDefault = Use the default settings of the display program. *   byPDFSize = Try to determine the necessary paper size and the used print tray automatically based on the size of the pages of the document.")
  @JsonProperty(JSON_PROPERTY_PRINT_TRAY_SELECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrintTraySelectionEnum getPrintTraySelection() {
    return printTraySelection;
  }


  @JsonProperty(JSON_PROPERTY_PRINT_TRAY_SELECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintTraySelection(PrintTraySelectionEnum printTraySelection) {
    this.printTraySelection = printTraySelection;
  }


  public OperationViewerPreferences textDirection(TextDirectionEnum textDirection) {
    
    this.textDirection = textDirection;
    return this;
  }

  /**
   * Specifies the text reading direction for the display program&#39;s read aloud.  *   leftToRight &#x3D; From left to right. *   rightToLeft &#x3D; From right to left. (Including vertical fonts, such as: Chinese, Japanese, Korean, etc.).
   * @return textDirection
   **/
  @Nullable
  @Schema(name = "Specifies the text reading direction for the display program's read aloud.  *   leftToRight = From left to right. *   rightToLeft = From right to left. (Including vertical fonts, such as: Chinese, Japanese, Korean, etc.).")
  @JsonProperty(JSON_PROPERTY_TEXT_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TextDirectionEnum getTextDirection() {
    return textDirection;
  }


  @JsonProperty(JSON_PROPERTY_TEXT_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTextDirection(TextDirectionEnum textDirection) {
    this.textDirection = textDirection;
  }


  public OperationViewerPreferences viewArea(ViewAreaEnum viewArea) {
    
    this.viewArea = viewArea;
    return this;
  }

  /**
   * Used to select the box that should be scaled.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   * @return viewArea
   **/
  @Nullable
  @Schema(name = "Used to select the box that should be scaled.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
  @JsonProperty(JSON_PROPERTY_VIEW_AREA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ViewAreaEnum getViewArea() {
    return viewArea;
  }


  @JsonProperty(JSON_PROPERTY_VIEW_AREA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViewArea(ViewAreaEnum viewArea) {
    this.viewArea = viewArea;
  }


  public OperationViewerPreferences viewClip(ViewClipEnum viewClip) {
    
    this.viewClip = viewClip;
    return this;
  }

  /**
   * Used to select the box that should be scaled.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   * @return viewClip
   **/
  @Nullable
  @Schema(name = "Used to select the box that should be scaled.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
  @JsonProperty(JSON_PROPERTY_VIEW_CLIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ViewClipEnum getViewClip() {
    return viewClip;
  }


  @JsonProperty(JSON_PROPERTY_VIEW_CLIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViewClip(ViewClipEnum viewClip) {
    this.viewClip = viewClip;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationViewerPreferences operationViewerPreferences = (OperationViewerPreferences) o;
    return Objects.equals(this.centerWindow, operationViewerPreferences.centerWindow) &&
        Objects.equals(this.displayDocTitle, operationViewerPreferences.displayDocTitle) &&
        Objects.equals(this.duplex, operationViewerPreferences.duplex) &&
        Objects.equals(this.fitWindow, operationViewerPreferences.fitWindow) &&
        Objects.equals(this.hideMenuBar, operationViewerPreferences.hideMenuBar) &&
        Objects.equals(this.hideToolbar, operationViewerPreferences.hideToolbar) &&
        Objects.equals(this.hideWindowUI, operationViewerPreferences.hideWindowUI) &&
        Objects.equals(this.nonFullScreenPageMode, operationViewerPreferences.nonFullScreenPageMode) &&
        Objects.equals(this.numCopies, operationViewerPreferences.numCopies) &&
        Objects.equals(this.printArea, operationViewerPreferences.printArea) &&
        Objects.equals(this.printClip, operationViewerPreferences.printClip) &&
        Objects.equals(this.printPageRange, operationViewerPreferences.printPageRange) &&
        Objects.equals(this.printScaling, operationViewerPreferences.printScaling) &&
        Objects.equals(this.printTraySelection, operationViewerPreferences.printTraySelection) &&
        Objects.equals(this.textDirection, operationViewerPreferences.textDirection) &&
        Objects.equals(this.viewArea, operationViewerPreferences.viewArea) &&
        Objects.equals(this.viewClip, operationViewerPreferences.viewClip);
  }

  @Override
  public int hashCode() {
    return Objects.hash(centerWindow, displayDocTitle, duplex, fitWindow, hideMenuBar, hideToolbar, hideWindowUI, nonFullScreenPageMode, numCopies, printArea, printClip, printPageRange, printScaling, printTraySelection, textDirection, viewArea, viewClip);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationViewerPreferences {\n");
    sb.append("    centerWindow: ").append(toIndentedString(centerWindow)).append("\n");
    sb.append("    displayDocTitle: ").append(toIndentedString(displayDocTitle)).append("\n");
    sb.append("    duplex: ").append(toIndentedString(duplex)).append("\n");
    sb.append("    fitWindow: ").append(toIndentedString(fitWindow)).append("\n");
    sb.append("    hideMenuBar: ").append(toIndentedString(hideMenuBar)).append("\n");
    sb.append("    hideToolbar: ").append(toIndentedString(hideToolbar)).append("\n");
    sb.append("    hideWindowUI: ").append(toIndentedString(hideWindowUI)).append("\n");
    sb.append("    nonFullScreenPageMode: ").append(toIndentedString(nonFullScreenPageMode)).append("\n");
    sb.append("    numCopies: ").append(toIndentedString(numCopies)).append("\n");
    sb.append("    printArea: ").append(toIndentedString(printArea)).append("\n");
    sb.append("    printClip: ").append(toIndentedString(printClip)).append("\n");
    sb.append("    printPageRange: ").append(toIndentedString(printPageRange)).append("\n");
    sb.append("    printScaling: ").append(toIndentedString(printScaling)).append("\n");
    sb.append("    printTraySelection: ").append(toIndentedString(printTraySelection)).append("\n");
    sb.append("    textDirection: ").append(toIndentedString(textDirection)).append("\n");
    sb.append("    viewArea: ").append(toIndentedString(viewArea)).append("\n");
    sb.append("    viewClip: ").append(toIndentedString(viewClip)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
