/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The options operation element can be used to change the way documents are displayed.  **Tip:** For all hereby contained options, please consult the chapter \&quot;Display Options\&quot;. This is especially important concerning the content format of headers and footers.
 */
@Schema(description = "The options operation element can be used to change the way documents are displayed.  **Tip:** For all hereby contained options, please consult the chapter \"Display Options\". This is especially important concerning the content format of headers and footers.")
@JsonPropertyOrder({
  OperationToolboxOptionsOptions.JSON_PROPERTY_BACKGROUND,
  OperationToolboxOptionsOptions.JSON_PROPERTY_BOXES,
  OperationToolboxOptionsOptions.JSON_PROPERTY_HEADER_FOOTER,
  OperationToolboxOptionsOptions.JSON_PROPERTY_INITIAL_PAGE,
  OperationToolboxOptionsOptions.JSON_PROPERTY_INITIAL_VIEW,
  OperationToolboxOptionsOptions.JSON_PROPERTY_LANGUAGE,
  OperationToolboxOptionsOptions.JSON_PROPERTY_MAGNIFICATION,
  OperationToolboxOptionsOptions.JSON_PROPERTY_MAGNIFICATION_ZOOM,
  OperationToolboxOptionsOptions.JSON_PROPERTY_PAGE_LAYOUT,
  OperationToolboxOptionsOptions.JSON_PROPERTY_PAGE_TRANSITIONS,
  OperationToolboxOptionsOptions.JSON_PROPERTY_VIEWER_PREFERENCES
})
@JsonTypeName("Operation_ToolboxOptions_options")

public class OperationToolboxOptionsOptions {
  public static final String JSON_PROPERTY_BACKGROUND = "background";
  private OperationBackgroundToolboxOptions background;

  public static final String JSON_PROPERTY_BOXES = "boxes";
  private OperationBoxesToolboxOptions boxes;

  public static final String JSON_PROPERTY_HEADER_FOOTER = "headerFooter";
  private OperationHeaderFooterToolboxOptions headerFooter;

  public static final String JSON_PROPERTY_INITIAL_PAGE = "initialPage";
  private Integer initialPage = 1;

  /**
   * Defines which sub-windows will be opened when the PDF document is opened.  *   none &#x3D; No special view *   outlines &#x3D; Opens the \&quot;Bookmarks\&quot; tab *   thumbnails &#x3D; Opens the \&quot;Thumbnails\&quot; tab *   fullscreen &#x3D; Opens the document in full screen mode
   */
  public enum InitialViewEnum {
    NONE(String.valueOf("none")),
    
    OUTLINES(String.valueOf("outlines")),
    
    THUMBNAILS(String.valueOf("thumbnails")),
    
    FULLSCREEN(String.valueOf("fullscreen")),
    
    LAYERS(String.valueOf("layers")),
    
    ATTACHMENTS(String.valueOf("attachments"));

    private String value;

    InitialViewEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InitialViewEnum fromValue(String value) {
      for (InitialViewEnum b : InitialViewEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INITIAL_VIEW = "initialView";
  private InitialViewEnum initialView = InitialViewEnum.NONE;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language = "";

  /**
   * Sets the zoom settings according to a defined mode.  *   none &#x3D; Uses the application&#39;s default view *   fitWidth &#x3D; Page width *   fitPage &#x3D; Page dimensions *   fitHeight &#x3D; Page height *   fitVisible &#x3D; Page content width *   fitActual &#x3D; Uses the original page dimensions (100% zoom factor) *   zoom &#x3D; Sets an explicit magnification value
   */
  public enum MagnificationEnum {
    NONE(String.valueOf("none")),
    
    FIT_WIDTH(String.valueOf("fitWidth")),
    
    FIT_VISIBLE(String.valueOf("fitVisible")),
    
    FIT_HEIGHT(String.valueOf("fitHeight")),
    
    FIT_PAGE(String.valueOf("fitPage")),
    
    FIT_ACTUAL(String.valueOf("fitActual")),
    
    ZOOM(String.valueOf("zoom"));

    private String value;

    MagnificationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MagnificationEnum fromValue(String value) {
      for (MagnificationEnum b : MagnificationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MAGNIFICATION = "magnification";
  private MagnificationEnum magnification = MagnificationEnum.FIT_WIDTH;

  public static final String JSON_PROPERTY_MAGNIFICATION_ZOOM = "magnificationZoom";
  private Integer magnificationZoom = 100;

  /**
   * Sets the page layout when the PDF document is opened.  *   singlePage &#x3D; Individual pages *   singlePageContinous &#x3D; Continuous individual pages *   twoPages &#x3D; double pages starting with odd pages *   twoPagesRight &#x3D; double pages starting with even pages *   twoPagesContinous &#x3D; continuous double pages starting with odd pages *   twoPagesContinousRight &#x3D; continuous double pages starting with even pages
   */
  public enum PageLayoutEnum {
    SINGLE_PAGE(String.valueOf("singlePage")),
    
    SINGLE_PAGE_CONTINOUS(String.valueOf("singlePageContinous")),
    
    TWO_PAGES(String.valueOf("twoPages")),
    
    TWO_PAGES_RIGHT(String.valueOf("twoPagesRight")),
    
    TWO_PAGES_CONTINOUS(String.valueOf("twoPagesContinous")),
    
    TWO_PAGES_CONTINOUS_RIGHT(String.valueOf("twoPagesContinousRight"));

    private String value;

    PageLayoutEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PageLayoutEnum fromValue(String value) {
      for (PageLayoutEnum b : PageLayoutEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAGE_LAYOUT = "pageLayout";
  private PageLayoutEnum pageLayout = PageLayoutEnum.SINGLE_PAGE;

  public static final String JSON_PROPERTY_PAGE_TRANSITIONS = "pageTransitions";
  private OperationPageTransitionsToolboxOptions pageTransitions;

  public static final String JSON_PROPERTY_VIEWER_PREFERENCES = "viewerPreferences";
  private OperationViewerPreferences viewerPreferences;

  public OperationToolboxOptionsOptions() {
  }

  public OperationToolboxOptionsOptions background(OperationBackgroundToolboxOptions background) {
    
    this.background = background;
    return this;
  }

  /**
   * Get background
   * @return background
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationBackgroundToolboxOptions getBackground() {
    return background;
  }


  @JsonProperty(JSON_PROPERTY_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBackground(OperationBackgroundToolboxOptions background) {
    this.background = background;
  }


  public OperationToolboxOptionsOptions boxes(OperationBoxesToolboxOptions boxes) {
    
    this.boxes = boxes;
    return this;
  }

  /**
   * Get boxes
   * @return boxes
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_BOXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationBoxesToolboxOptions getBoxes() {
    return boxes;
  }


  @JsonProperty(JSON_PROPERTY_BOXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBoxes(OperationBoxesToolboxOptions boxes) {
    this.boxes = boxes;
  }


  public OperationToolboxOptionsOptions headerFooter(OperationHeaderFooterToolboxOptions headerFooter) {
    
    this.headerFooter = headerFooter;
    return this;
  }

  /**
   * Get headerFooter
   * @return headerFooter
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_HEADER_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationHeaderFooterToolboxOptions getHeaderFooter() {
    return headerFooter;
  }


  @JsonProperty(JSON_PROPERTY_HEADER_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeaderFooter(OperationHeaderFooterToolboxOptions headerFooter) {
    this.headerFooter = headerFooter;
  }


  public OperationToolboxOptionsOptions initialPage(Integer initialPage) {
    
    this.initialPage = initialPage;
    return this;
  }

  /**
   * Defines the page that will be shown when the document is opened.
   * minimum: 1
   * @return initialPage
   **/
  @Nullable
  @Schema(name = "Defines the page that will be shown when the document is opened.")
  @JsonProperty(JSON_PROPERTY_INITIAL_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getInitialPage() {
    return initialPage;
  }


  @JsonProperty(JSON_PROPERTY_INITIAL_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInitialPage(Integer initialPage) {
    this.initialPage = initialPage;
  }


  public OperationToolboxOptionsOptions initialView(InitialViewEnum initialView) {
    
    this.initialView = initialView;
    return this;
  }

  /**
   * Defines which sub-windows will be opened when the PDF document is opened.  *   none &#x3D; No special view *   outlines &#x3D; Opens the \&quot;Bookmarks\&quot; tab *   thumbnails &#x3D; Opens the \&quot;Thumbnails\&quot; tab *   fullscreen &#x3D; Opens the document in full screen mode
   * @return initialView
   **/
  @Nullable
  @Schema(name = "Defines which sub-windows will be opened when the PDF document is opened.  *   none = No special view *   outlines = Opens the \"Bookmarks\" tab *   thumbnails = Opens the \"Thumbnails\" tab *   fullscreen = Opens the document in full screen mode")
  @JsonProperty(JSON_PROPERTY_INITIAL_VIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InitialViewEnum getInitialView() {
    return initialView;
  }


  @JsonProperty(JSON_PROPERTY_INITIAL_VIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInitialView(InitialViewEnum initialView) {
    this.initialView = initialView;
  }


  public OperationToolboxOptionsOptions language(String language) {
    
    this.language = language;
    return this;
  }

  /**
   * Specifies the language (and optionally the country) for the content of the document. The value is encoded as RFC 3066 (Tags for the Identification of Languages) and includes either the language only (e.g. \&quot;de\&quot;) or the language and a country identifier (e.g. \&quot;de-DE\&quot;).
   * @return language
   **/
  @Nullable
  @Schema(name = "Specifies the language (and optionally the country) for the content of the document. The value is encoded as RFC 3066 (Tags for the Identification of Languages) and includes either the language only (e.g. \"de\") or the language and a country identifier (e.g. \"de-DE\").")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public OperationToolboxOptionsOptions magnification(MagnificationEnum magnification) {
    
    this.magnification = magnification;
    return this;
  }

  /**
   * Sets the zoom settings according to a defined mode.  *   none &#x3D; Uses the application&#39;s default view *   fitWidth &#x3D; Page width *   fitPage &#x3D; Page dimensions *   fitHeight &#x3D; Page height *   fitVisible &#x3D; Page content width *   fitActual &#x3D; Uses the original page dimensions (100% zoom factor) *   zoom &#x3D; Sets an explicit magnification value
   * @return magnification
   **/
  @Nullable
  @Schema(name = "Sets the zoom settings according to a defined mode.  *   none = Uses the application's default view *   fitWidth = Page width *   fitPage = Page dimensions *   fitHeight = Page height *   fitVisible = Page content width *   fitActual = Uses the original page dimensions (100% zoom factor) *   zoom = Sets an explicit magnification value")
  @JsonProperty(JSON_PROPERTY_MAGNIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MagnificationEnum getMagnification() {
    return magnification;
  }


  @JsonProperty(JSON_PROPERTY_MAGNIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMagnification(MagnificationEnum magnification) {
    this.magnification = magnification;
  }


  public OperationToolboxOptionsOptions magnificationZoom(Integer magnificationZoom) {
    
    this.magnificationZoom = magnificationZoom;
    return this;
  }

  /**
   * Used to set the value for zooming.
   * minimum: 0
   * maximum: 6400
   * @return magnificationZoom
   **/
  @Nullable
  @Schema(name = "Used to set the value for zooming.")
  @JsonProperty(JSON_PROPERTY_MAGNIFICATION_ZOOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMagnificationZoom() {
    return magnificationZoom;
  }


  @JsonProperty(JSON_PROPERTY_MAGNIFICATION_ZOOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMagnificationZoom(Integer magnificationZoom) {
    this.magnificationZoom = magnificationZoom;
  }


  public OperationToolboxOptionsOptions pageLayout(PageLayoutEnum pageLayout) {
    
    this.pageLayout = pageLayout;
    return this;
  }

  /**
   * Sets the page layout when the PDF document is opened.  *   singlePage &#x3D; Individual pages *   singlePageContinous &#x3D; Continuous individual pages *   twoPages &#x3D; double pages starting with odd pages *   twoPagesRight &#x3D; double pages starting with even pages *   twoPagesContinous &#x3D; continuous double pages starting with odd pages *   twoPagesContinousRight &#x3D; continuous double pages starting with even pages
   * @return pageLayout
   **/
  @Nullable
  @Schema(name = "Sets the page layout when the PDF document is opened.  *   singlePage = Individual pages *   singlePageContinous = Continuous individual pages *   twoPages = double pages starting with odd pages *   twoPagesRight = double pages starting with even pages *   twoPagesContinous = continuous double pages starting with odd pages *   twoPagesContinousRight = continuous double pages starting with even pages")
  @JsonProperty(JSON_PROPERTY_PAGE_LAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PageLayoutEnum getPageLayout() {
    return pageLayout;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_LAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageLayout(PageLayoutEnum pageLayout) {
    this.pageLayout = pageLayout;
  }


  public OperationToolboxOptionsOptions pageTransitions(OperationPageTransitionsToolboxOptions pageTransitions) {
    
    this.pageTransitions = pageTransitions;
    return this;
  }

  /**
   * Get pageTransitions
   * @return pageTransitions
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PAGE_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationPageTransitionsToolboxOptions getPageTransitions() {
    return pageTransitions;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageTransitions(OperationPageTransitionsToolboxOptions pageTransitions) {
    this.pageTransitions = pageTransitions;
  }


  public OperationToolboxOptionsOptions viewerPreferences(OperationViewerPreferences viewerPreferences) {
    
    this.viewerPreferences = viewerPreferences;
    return this;
  }

  /**
   * Get viewerPreferences
   * @return viewerPreferences
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_VIEWER_PREFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationViewerPreferences getViewerPreferences() {
    return viewerPreferences;
  }


  @JsonProperty(JSON_PROPERTY_VIEWER_PREFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViewerPreferences(OperationViewerPreferences viewerPreferences) {
    this.viewerPreferences = viewerPreferences;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationToolboxOptionsOptions operationToolboxOptionsOptions = (OperationToolboxOptionsOptions) o;
    return Objects.equals(this.background, operationToolboxOptionsOptions.background) &&
        Objects.equals(this.boxes, operationToolboxOptionsOptions.boxes) &&
        Objects.equals(this.headerFooter, operationToolboxOptionsOptions.headerFooter) &&
        Objects.equals(this.initialPage, operationToolboxOptionsOptions.initialPage) &&
        Objects.equals(this.initialView, operationToolboxOptionsOptions.initialView) &&
        Objects.equals(this.language, operationToolboxOptionsOptions.language) &&
        Objects.equals(this.magnification, operationToolboxOptionsOptions.magnification) &&
        Objects.equals(this.magnificationZoom, operationToolboxOptionsOptions.magnificationZoom) &&
        Objects.equals(this.pageLayout, operationToolboxOptionsOptions.pageLayout) &&
        Objects.equals(this.pageTransitions, operationToolboxOptionsOptions.pageTransitions) &&
        Objects.equals(this.viewerPreferences, operationToolboxOptionsOptions.viewerPreferences);
  }

  @Override
  public int hashCode() {
    return Objects.hash(background, boxes, headerFooter, initialPage, initialView, language, magnification, magnificationZoom, pageLayout, pageTransitions, viewerPreferences);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationToolboxOptionsOptions {\n");
    sb.append("    background: ").append(toIndentedString(background)).append("\n");
    sb.append("    boxes: ").append(toIndentedString(boxes)).append("\n");
    sb.append("    headerFooter: ").append(toIndentedString(headerFooter)).append("\n");
    sb.append("    initialPage: ").append(toIndentedString(initialPage)).append("\n");
    sb.append("    initialView: ").append(toIndentedString(initialView)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    magnification: ").append(toIndentedString(magnification)).append("\n");
    sb.append("    magnificationZoom: ").append(toIndentedString(magnificationZoom)).append("\n");
    sb.append("    pageLayout: ").append(toIndentedString(pageLayout)).append("\n");
    sb.append("    pageTransitions: ").append(toIndentedString(pageTransitions)).append("\n");
    sb.append("    viewerPreferences: ").append(toIndentedString(viewerPreferences)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
