/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * When activated, the submitForm action will send the names and values of all selected form fields to the specified URL (Uniform Resource Locator). You can use the \&quot;field\&quot; element as many times as necessary.
 */
@Schema(description = "When activated, the submitForm action will send the names and values of all selected form fields to the specified URL (Uniform Resource Locator). You can use the \"field\" element as many times as necessary.")
@JsonPropertyOrder({
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_CANONICAL_FORMAT,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_EMBED_FORM,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_EXCLUDE,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_EXCLUDE_F_D_F_SOURCE_OR_TARGET_FILE,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_EXCLUDE_NON_USER_ANNOTATIONS,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_EXPORT_FORMAT,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_FIELD,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_GET_METHOD,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_INCLUDE_ANNOTATIONS,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_INCLUDE_APPEND_SAVES,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_INCLUDE_NO_VALUE_FIELDS,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_SUBMIT_COORDINATES,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_SUBMIT_P_D_F,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_URL,
  OperationSubmitFormActionSubmitForm.JSON_PROPERTY_XFDF
})
@JsonTypeName("Operation_SubmitFormAction_submitForm")

public class OperationSubmitFormActionSubmitForm {
  public static final String JSON_PROPERTY_CANONICAL_FORMAT = "canonicalFormat";
  private Boolean canonicalFormat = false;

  public static final String JSON_PROPERTY_EMBED_FORM = "embedForm";
  private Boolean embedForm = false;

  public static final String JSON_PROPERTY_EXCLUDE = "exclude";
  private Boolean exclude = false;

  public static final String JSON_PROPERTY_EXCLUDE_F_D_F_SOURCE_OR_TARGET_FILE = "excludeFDFSourceOrTargetFile";
  private Boolean excludeFDFSourceOrTargetFile = false;

  public static final String JSON_PROPERTY_EXCLUDE_NON_USER_ANNOTATIONS = "excludeNonUserAnnotations";
  private Boolean excludeNonUserAnnotations = false;

  public static final String JSON_PROPERTY_EXPORT_FORMAT = "exportFormat";
  private Boolean exportFormat = false;

  public static final String JSON_PROPERTY_FIELD = "field";
  private List<OperationFormFieldSelection> field = null;

  public static final String JSON_PROPERTY_GET_METHOD = "getMethod";
  private Boolean getMethod = false;

  public static final String JSON_PROPERTY_INCLUDE_ANNOTATIONS = "includeAnnotations";
  private Boolean includeAnnotations = false;

  public static final String JSON_PROPERTY_INCLUDE_APPEND_SAVES = "includeAppendSaves";
  private Boolean includeAppendSaves = false;

  public static final String JSON_PROPERTY_INCLUDE_NO_VALUE_FIELDS = "includeNoValueFields";
  private Boolean includeNoValueFields = false;

  public static final String JSON_PROPERTY_SUBMIT_COORDINATES = "submitCoordinates";
  private Boolean submitCoordinates = false;

  public static final String JSON_PROPERTY_SUBMIT_P_D_F = "submitPDF";
  private Boolean submitPDF = false;

  public static final String JSON_PROPERTY_URL = "url";
  private String url = "";

  public static final String JSON_PROPERTY_XFDF = "xfdf";
  private Boolean xfdf = false;

  public OperationSubmitFormActionSubmitForm() {
  }

  public OperationSubmitFormActionSubmitForm canonicalFormat(Boolean canonicalFormat) {
    
    this.canonicalFormat = canonicalFormat;
    return this;
  }

  /**
   * If this value is set to true, all dates and times will be transmitted in a canonical standard format whenever possible.
   * @return canonicalFormat
   **/
  @Nullable
  @Schema(name = "If this value is set to true, all dates and times will be transmitted in a canonical standard format whenever possible.")
  @JsonProperty(JSON_PROPERTY_CANONICAL_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCanonicalFormat() {
    return canonicalFormat;
  }


  @JsonProperty(JSON_PROPERTY_CANONICAL_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanonicalFormat(Boolean canonicalFormat) {
    this.canonicalFormat = canonicalFormat;
  }


  public OperationSubmitFormActionSubmitForm embedForm(Boolean embedForm) {
    
    this.embedForm = embedForm;
    return this;
  }

  /**
   * This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the PDF file that contains the form should be integrated into the transmitted data.
   * @return embedForm
   **/
  @Nullable
  @Schema(name = "This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the PDF file that contains the form should be integrated into the transmitted data.")
  @JsonProperty(JSON_PROPERTY_EMBED_FORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEmbedForm() {
    return embedForm;
  }


  @JsonProperty(JSON_PROPERTY_EMBED_FORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmbedForm(Boolean embedForm) {
    this.embedForm = embedForm;
  }


  public OperationSubmitFormActionSubmitForm exclude(Boolean exclude) {
    
    this.exclude = exclude;
    return this;
  }

  /**
   * If true, then all form fields except the selected ones should be exported. If false, only the selected ones will be.
   * @return exclude
   **/
  @Nullable
  @Schema(name = "If true, then all form fields except the selected ones should be exported. If false, only the selected ones will be.")
  @JsonProperty(JSON_PROPERTY_EXCLUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getExclude() {
    return exclude;
  }


  @JsonProperty(JSON_PROPERTY_EXCLUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExclude(Boolean exclude) {
    this.exclude = exclude;
  }


  public OperationSubmitFormActionSubmitForm excludeFDFSourceOrTargetFile(Boolean excludeFDFSourceOrTargetFile) {
    
    this.excludeFDFSourceOrTargetFile = excludeFDFSourceOrTargetFile;
    return this;
  }

  /**
   * This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the URL to which the data is being transmitted should be included in the export.
   * @return excludeFDFSourceOrTargetFile
   **/
  @Nullable
  @Schema(name = "This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the URL to which the data is being transmitted should be included in the export.")
  @JsonProperty(JSON_PROPERTY_EXCLUDE_F_D_F_SOURCE_OR_TARGET_FILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getExcludeFDFSourceOrTargetFile() {
    return excludeFDFSourceOrTargetFile;
  }


  @JsonProperty(JSON_PROPERTY_EXCLUDE_F_D_F_SOURCE_OR_TARGET_FILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExcludeFDFSourceOrTargetFile(Boolean excludeFDFSourceOrTargetFile) {
    this.excludeFDFSourceOrTargetFile = excludeFDFSourceOrTargetFile;
  }


  public OperationSubmitFormActionSubmitForm excludeNonUserAnnotations(Boolean excludeNonUserAnnotations) {
    
    this.excludeNonUserAnnotations = excludeNonUserAnnotations;
    return this;
  }

  /**
   * This value is only relevant if the data should be transmitted in FDF format and \&quot;includeAnnotations\&quot; is set. In this case, this value determines whether the transmitted data should exclusively contain the annotations set by the user filling out the information (true) or whether it should contain all annotations instead (false).
   * @return excludeNonUserAnnotations
   **/
  @Nullable
  @Schema(name = "This value is only relevant if the data should be transmitted in FDF format and \"includeAnnotations\" is set. In this case, this value determines whether the transmitted data should exclusively contain the annotations set by the user filling out the information (true) or whether it should contain all annotations instead (false).")
  @JsonProperty(JSON_PROPERTY_EXCLUDE_NON_USER_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getExcludeNonUserAnnotations() {
    return excludeNonUserAnnotations;
  }


  @JsonProperty(JSON_PROPERTY_EXCLUDE_NON_USER_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExcludeNonUserAnnotations(Boolean excludeNonUserAnnotations) {
    this.excludeNonUserAnnotations = excludeNonUserAnnotations;
  }


  public OperationSubmitFormActionSubmitForm exportFormat(Boolean exportFormat) {
    
    this.exportFormat = exportFormat;
    return this;
  }

  /**
   * This value is only relevant if \&quot;submitPDF\&quot; and \&quot;xfdf\&quot; are not set. If this value is set to true, the data will be exported as an HTML form; otherwise, it will be exported in fdf (Forms Data Format) format.
   * @return exportFormat
   **/
  @Nullable
  @Schema(name = "This value is only relevant if \"submitPDF\" and \"xfdf\" are not set. If this value is set to true, the data will be exported as an HTML form; otherwise, it will be exported in fdf (Forms Data Format) format.")
  @JsonProperty(JSON_PROPERTY_EXPORT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getExportFormat() {
    return exportFormat;
  }


  @JsonProperty(JSON_PROPERTY_EXPORT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExportFormat(Boolean exportFormat) {
    this.exportFormat = exportFormat;
  }


  public OperationSubmitFormActionSubmitForm field(List<OperationFormFieldSelection> field) {
    
    this.field = field;
    return this;
  }

  public OperationSubmitFormActionSubmitForm addFieldItem(OperationFormFieldSelection fieldItem) {
    if (this.field == null) {
        this.field = new ArrayList<>();
    }
    this.field.add(fieldItem);
    return this;
  }

  /**
   * Get field
   * @return field
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationFormFieldSelection> getField() {
    return field;
  }


  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setField(List<OperationFormFieldSelection> field) {
    this.field = field;
  }


  public OperationSubmitFormActionSubmitForm getMethod(Boolean getMethod) {
    
    this.getMethod = getMethod;
    return this;
  }

  /**
   * This value is only relevant if \&quot;exportFormat\&quot; is set and used. In this case, this value determines whether the names and values will be transmitted with GET (true) or HTTP POST (false) requests.
   * @return getMethod
   **/
  @Nullable
  @Schema(name = "This value is only relevant if \"exportFormat\" is set and used. In this case, this value determines whether the names and values will be transmitted with GET (true) or HTTP POST (false) requests.")
  @JsonProperty(JSON_PROPERTY_GET_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGetMethod() {
    return getMethod;
  }


  @JsonProperty(JSON_PROPERTY_GET_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGetMethod(Boolean getMethod) {
    this.getMethod = getMethod;
  }


  public OperationSubmitFormActionSubmitForm includeAnnotations(Boolean includeAnnotations) {
    
    this.includeAnnotations = includeAnnotations;
    return this;
  }

  /**
   * This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the set mark-up annotations should be included in the transmitted data.
   * @return includeAnnotations
   **/
  @Nullable
  @Schema(name = "This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the set mark-up annotations should be included in the transmitted data.")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAnnotations() {
    return includeAnnotations;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAnnotations(Boolean includeAnnotations) {
    this.includeAnnotations = includeAnnotations;
  }


  public OperationSubmitFormActionSubmitForm includeAppendSaves(Boolean includeAppendSaves) {
    
    this.includeAppendSaves = includeAppendSaves;
    return this;
  }

  /**
   * This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the transmitted data will reproduce all incremental changes in the form data.
   * @return includeAppendSaves
   **/
  @Nullable
  @Schema(name = "This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the transmitted data will reproduce all incremental changes in the form data.")
  @JsonProperty(JSON_PROPERTY_INCLUDE_APPEND_SAVES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAppendSaves() {
    return includeAppendSaves;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_APPEND_SAVES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAppendSaves(Boolean includeAppendSaves) {
    this.includeAppendSaves = includeAppendSaves;
  }


  public OperationSubmitFormActionSubmitForm includeNoValueFields(Boolean includeNoValueFields) {
    
    this.includeNoValueFields = includeNoValueFields;
    return this;
  }

  /**
   * If true, form fields that have not yet been filled out / that do not contain a value will be exported as well.
   * @return includeNoValueFields
   **/
  @Nullable
  @Schema(name = "If true, form fields that have not yet been filled out / that do not contain a value will be exported as well.")
  @JsonProperty(JSON_PROPERTY_INCLUDE_NO_VALUE_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeNoValueFields() {
    return includeNoValueFields;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_NO_VALUE_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeNoValueFields(Boolean includeNoValueFields) {
    this.includeNoValueFields = includeNoValueFields;
  }


  public OperationSubmitFormActionSubmitForm submitCoordinates(Boolean submitCoordinates) {
    
    this.submitCoordinates = submitCoordinates;
    return this;
  }

  /**
   * This value is only relevant if \&quot;exportFormat\&quot; is set and used. In this case, this value determines whether the position of the mouse click that triggered the export should also be part of the export.
   * @return submitCoordinates
   **/
  @Nullable
  @Schema(name = "This value is only relevant if \"exportFormat\" is set and used. In this case, this value determines whether the position of the mouse click that triggered the export should also be part of the export.")
  @JsonProperty(JSON_PROPERTY_SUBMIT_COORDINATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSubmitCoordinates() {
    return submitCoordinates;
  }


  @JsonProperty(JSON_PROPERTY_SUBMIT_COORDINATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubmitCoordinates(Boolean submitCoordinates) {
    this.submitCoordinates = submitCoordinates;
  }


  public OperationSubmitFormActionSubmitForm submitPDF(Boolean submitPDF) {
    
    this.submitPDF = submitPDF;
    return this;
  }

  /**
   * If this value is set to true, the data will be transmitted as a PDF file.
   * @return submitPDF
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the data will be transmitted as a PDF file.")
  @JsonProperty(JSON_PROPERTY_SUBMIT_P_D_F)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSubmitPDF() {
    return submitPDF;
  }


  @JsonProperty(JSON_PROPERTY_SUBMIT_P_D_F)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubmitPDF(Boolean submitPDF) {
    this.submitPDF = submitPDF;
  }


  public OperationSubmitFormActionSubmitForm url(String url) {
    
    this.url = url;
    return this;
  }

  /**
   * The URL to which the data should be transmitted.
   * @return url
   **/
  @Nullable
  @Schema(name = "The URL to which the data should be transmitted.")
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrl(String url) {
    this.url = url;
  }


  public OperationSubmitFormActionSubmitForm xfdf(Boolean xfdf) {
    
    this.xfdf = xfdf;
    return this;
  }

  /**
   * This value is only relevant if \&quot;submitPDF\&quot; is not set. In this case, this value determines whether the data should be transmitted in XFDF format.
   * @return xfdf
   **/
  @Nullable
  @Schema(name = "This value is only relevant if \"submitPDF\" is not set. In this case, this value determines whether the data should be transmitted in XFDF format.")
  @JsonProperty(JSON_PROPERTY_XFDF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getXfdf() {
    return xfdf;
  }


  @JsonProperty(JSON_PROPERTY_XFDF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setXfdf(Boolean xfdf) {
    this.xfdf = xfdf;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationSubmitFormActionSubmitForm operationSubmitFormActionSubmitForm = (OperationSubmitFormActionSubmitForm) o;
    return Objects.equals(this.canonicalFormat, operationSubmitFormActionSubmitForm.canonicalFormat) &&
        Objects.equals(this.embedForm, operationSubmitFormActionSubmitForm.embedForm) &&
        Objects.equals(this.exclude, operationSubmitFormActionSubmitForm.exclude) &&
        Objects.equals(this.excludeFDFSourceOrTargetFile, operationSubmitFormActionSubmitForm.excludeFDFSourceOrTargetFile) &&
        Objects.equals(this.excludeNonUserAnnotations, operationSubmitFormActionSubmitForm.excludeNonUserAnnotations) &&
        Objects.equals(this.exportFormat, operationSubmitFormActionSubmitForm.exportFormat) &&
        Objects.equals(this.field, operationSubmitFormActionSubmitForm.field) &&
        Objects.equals(this.getMethod, operationSubmitFormActionSubmitForm.getMethod) &&
        Objects.equals(this.includeAnnotations, operationSubmitFormActionSubmitForm.includeAnnotations) &&
        Objects.equals(this.includeAppendSaves, operationSubmitFormActionSubmitForm.includeAppendSaves) &&
        Objects.equals(this.includeNoValueFields, operationSubmitFormActionSubmitForm.includeNoValueFields) &&
        Objects.equals(this.submitCoordinates, operationSubmitFormActionSubmitForm.submitCoordinates) &&
        Objects.equals(this.submitPDF, operationSubmitFormActionSubmitForm.submitPDF) &&
        Objects.equals(this.url, operationSubmitFormActionSubmitForm.url) &&
        Objects.equals(this.xfdf, operationSubmitFormActionSubmitForm.xfdf);
  }

  @Override
  public int hashCode() {
    return Objects.hash(canonicalFormat, embedForm, exclude, excludeFDFSourceOrTargetFile, excludeNonUserAnnotations, exportFormat, field, getMethod, includeAnnotations, includeAppendSaves, includeNoValueFields, submitCoordinates, submitPDF, url, xfdf);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationSubmitFormActionSubmitForm {\n");
    sb.append("    canonicalFormat: ").append(toIndentedString(canonicalFormat)).append("\n");
    sb.append("    embedForm: ").append(toIndentedString(embedForm)).append("\n");
    sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
    sb.append("    excludeFDFSourceOrTargetFile: ").append(toIndentedString(excludeFDFSourceOrTargetFile)).append("\n");
    sb.append("    excludeNonUserAnnotations: ").append(toIndentedString(excludeNonUserAnnotations)).append("\n");
    sb.append("    exportFormat: ").append(toIndentedString(exportFormat)).append("\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    getMethod: ").append(toIndentedString(getMethod)).append("\n");
    sb.append("    includeAnnotations: ").append(toIndentedString(includeAnnotations)).append("\n");
    sb.append("    includeAppendSaves: ").append(toIndentedString(includeAppendSaves)).append("\n");
    sb.append("    includeNoValueFields: ").append(toIndentedString(includeNoValueFields)).append("\n");
    sb.append("    submitCoordinates: ").append(toIndentedString(submitCoordinates)).append("\n");
    sb.append("    submitPDF: ").append(toIndentedString(submitPDF)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    xfdf: ").append(toIndentedString(xfdf)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
