/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Used to define the elements that are part of the visual signature.
 */
@Schema(description = "Used to define the elements that are part of the visual signature.")
@JsonPropertyOrder({
  OperationSignatureIdentifier.JSON_PROPERTY_SHOW_COMMON_NAME,
  OperationSignatureIdentifier.JSON_PROPERTY_SHOW_COUNTRY,
  OperationSignatureIdentifier.JSON_PROPERTY_SHOW_DATE,
  OperationSignatureIdentifier.JSON_PROPERTY_SHOW_LOCAL,
  OperationSignatureIdentifier.JSON_PROPERTY_SHOW_MAIL,
  OperationSignatureIdentifier.JSON_PROPERTY_SHOW_NAME,
  OperationSignatureIdentifier.JSON_PROPERTY_SHOW_ORGANISATION_NAME,
  OperationSignatureIdentifier.JSON_PROPERTY_SHOW_ORGANISATION_UNIT,
  OperationSignatureIdentifier.JSON_PROPERTY_SHOW_SIGNED_BY,
  OperationSignatureIdentifier.JSON_PROPERTY_SHOW_STATE,
  OperationSignatureIdentifier.JSON_PROPERTY_TEXT_SIGNED_BY
})
@JsonTypeName("Operation_SignatureIdentifier")

public class OperationSignatureIdentifier {
  public static final String JSON_PROPERTY_SHOW_COMMON_NAME = "showCommonName";
  private Boolean showCommonName = true;

  public static final String JSON_PROPERTY_SHOW_COUNTRY = "showCountry";
  private Boolean showCountry = true;

  public static final String JSON_PROPERTY_SHOW_DATE = "showDate";
  private Boolean showDate = true;

  public static final String JSON_PROPERTY_SHOW_LOCAL = "showLocal";
  private Boolean showLocal = true;

  public static final String JSON_PROPERTY_SHOW_MAIL = "showMail";
  private Boolean showMail = true;

  public static final String JSON_PROPERTY_SHOW_NAME = "showName";
  private Boolean showName = true;

  public static final String JSON_PROPERTY_SHOW_ORGANISATION_NAME = "showOrganisationName";
  private Boolean showOrganisationName = true;

  public static final String JSON_PROPERTY_SHOW_ORGANISATION_UNIT = "showOrganisationUnit";
  private Boolean showOrganisationUnit = true;

  public static final String JSON_PROPERTY_SHOW_SIGNED_BY = "showSignedBy";
  private Boolean showSignedBy = true;

  public static final String JSON_PROPERTY_SHOW_STATE = "showState";
  private Boolean showState = true;

  public static final String JSON_PROPERTY_TEXT_SIGNED_BY = "textSignedBy";
  private String textSignedBy = "";

  public OperationSignatureIdentifier() {
  }

  public OperationSignatureIdentifier showCommonName(Boolean showCommonName) {
    
    this.showCommonName = showCommonName;
    return this;
  }

  /**
   * Displays or hides the common name (CN) part of the certificate.
   * @return showCommonName
   **/
  @Nullable
  @Schema(name = "Displays or hides the common name (CN) part of the certificate.")
  @JsonProperty(JSON_PROPERTY_SHOW_COMMON_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowCommonName() {
    return showCommonName;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_COMMON_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowCommonName(Boolean showCommonName) {
    this.showCommonName = showCommonName;
  }


  public OperationSignatureIdentifier showCountry(Boolean showCountry) {
    
    this.showCountry = showCountry;
    return this;
  }

  /**
   * Displays or hides the (ISO valid) country code (C) of the country in which the certificate holder is located.
   * @return showCountry
   **/
  @Nullable
  @Schema(name = "Displays or hides the (ISO valid) country code (C) of the country in which the certificate holder is located.")
  @JsonProperty(JSON_PROPERTY_SHOW_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowCountry() {
    return showCountry;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowCountry(Boolean showCountry) {
    this.showCountry = showCountry;
  }


  public OperationSignatureIdentifier showDate(Boolean showDate) {
    
    this.showDate = showDate;
    return this;
  }

  /**
   * Displays or hides the signature time.
   * @return showDate
   **/
  @Nullable
  @Schema(name = "Displays or hides the signature time.")
  @JsonProperty(JSON_PROPERTY_SHOW_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowDate() {
    return showDate;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowDate(Boolean showDate) {
    this.showDate = showDate;
  }


  public OperationSignatureIdentifier showLocal(Boolean showLocal) {
    
    this.showLocal = showLocal;
    return this;
  }

  /**
   * Displays or hides the location/city (L) where the certificate holder is located.
   * @return showLocal
   **/
  @Nullable
  @Schema(name = "Displays or hides the location/city (L) where the certificate holder is located.")
  @JsonProperty(JSON_PROPERTY_SHOW_LOCAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowLocal() {
    return showLocal;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_LOCAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowLocal(Boolean showLocal) {
    this.showLocal = showLocal;
  }


  public OperationSignatureIdentifier showMail(Boolean showMail) {
    
    this.showMail = showMail;
    return this;
  }

  /**
   * Displays or hides the email address (E) at which the certificate holder can be contacted.
   * @return showMail
   **/
  @Nullable
  @Schema(name = "Displays or hides the email address (E) at which the certificate holder can be contacted.")
  @JsonProperty(JSON_PROPERTY_SHOW_MAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowMail() {
    return showMail;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_MAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowMail(Boolean showMail) {
    this.showMail = showMail;
  }


  public OperationSignatureIdentifier showName(Boolean showName) {
    
    this.showName = showName;
    return this;
  }

  /**
   * Displays or hides the signature &#x60;name&#x60;. (If &#x60;name&#x60; has not been set, the common name (CN) part of the certificate is displayed instead.)
   * @return showName
   **/
  @Nullable
  @Schema(name = "Displays or hides the signature `name`. (If `name` has not been set, the common name (CN) part of the certificate is displayed instead.)")
  @JsonProperty(JSON_PROPERTY_SHOW_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowName() {
    return showName;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowName(Boolean showName) {
    this.showName = showName;
  }


  public OperationSignatureIdentifier showOrganisationName(Boolean showOrganisationName) {
    
    this.showOrganisationName = showOrganisationName;
    return this;
  }

  /**
   * Displays or hides the certificate holder&#39;s organization/company (O).
   * @return showOrganisationName
   **/
  @Nullable
  @Schema(name = "Displays or hides the certificate holder's organization/company (O).")
  @JsonProperty(JSON_PROPERTY_SHOW_ORGANISATION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowOrganisationName() {
    return showOrganisationName;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ORGANISATION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowOrganisationName(Boolean showOrganisationName) {
    this.showOrganisationName = showOrganisationName;
  }


  public OperationSignatureIdentifier showOrganisationUnit(Boolean showOrganisationUnit) {
    
    this.showOrganisationUnit = showOrganisationUnit;
    return this;
  }

  /**
   * Displays or hides the certificate owner&#39;s suborganization/department (OU).
   * @return showOrganisationUnit
   **/
  @Nullable
  @Schema(name = "Displays or hides the certificate owner's suborganization/department (OU).")
  @JsonProperty(JSON_PROPERTY_SHOW_ORGANISATION_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowOrganisationUnit() {
    return showOrganisationUnit;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ORGANISATION_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowOrganisationUnit(Boolean showOrganisationUnit) {
    this.showOrganisationUnit = showOrganisationUnit;
  }


  public OperationSignatureIdentifier showSignedBy(Boolean showSignedBy) {
    
    this.showSignedBy = showSignedBy;
    return this;
  }

  /**
   * Displays or hides the text &#x60;Digitally signed by&#x60;. Can be overridden by the value of &#x60;textSignedBy&#x60;.
   * @return showSignedBy
   **/
  @Nullable
  @Schema(name = "Displays or hides the text `Digitally signed by`. Can be overridden by the value of `textSignedBy`.")
  @JsonProperty(JSON_PROPERTY_SHOW_SIGNED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowSignedBy() {
    return showSignedBy;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_SIGNED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowSignedBy(Boolean showSignedBy) {
    this.showSignedBy = showSignedBy;
  }


  public OperationSignatureIdentifier showState(Boolean showState) {
    
    this.showState = showState;
    return this;
  }

  /**
   * Displays or hides the state (S) in which the certificate holder is located.
   * @return showState
   **/
  @Nullable
  @Schema(name = "Displays or hides the state (S) in which the certificate holder is located.")
  @JsonProperty(JSON_PROPERTY_SHOW_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowState() {
    return showState;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowState(Boolean showState) {
    this.showState = showState;
  }


  public OperationSignatureIdentifier textSignedBy(String textSignedBy) {
    
    this.textSignedBy = textSignedBy;
    return this;
  }

  /**
   * Text that is displayed when the &#x60;showSignedBy&#x60; option is enabled. If not set, then the text &#x60;Digitally signed by&#x60; is used as default.
   * @return textSignedBy
   **/
  @Nullable
  @Schema(name = "Text that is displayed when the `showSignedBy` option is enabled. If not set, then the text `Digitally signed by` is used as default.")
  @JsonProperty(JSON_PROPERTY_TEXT_SIGNED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTextSignedBy() {
    return textSignedBy;
  }


  @JsonProperty(JSON_PROPERTY_TEXT_SIGNED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTextSignedBy(String textSignedBy) {
    this.textSignedBy = textSignedBy;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationSignatureIdentifier operationSignatureIdentifier = (OperationSignatureIdentifier) o;
    return Objects.equals(this.showCommonName, operationSignatureIdentifier.showCommonName) &&
        Objects.equals(this.showCountry, operationSignatureIdentifier.showCountry) &&
        Objects.equals(this.showDate, operationSignatureIdentifier.showDate) &&
        Objects.equals(this.showLocal, operationSignatureIdentifier.showLocal) &&
        Objects.equals(this.showMail, operationSignatureIdentifier.showMail) &&
        Objects.equals(this.showName, operationSignatureIdentifier.showName) &&
        Objects.equals(this.showOrganisationName, operationSignatureIdentifier.showOrganisationName) &&
        Objects.equals(this.showOrganisationUnit, operationSignatureIdentifier.showOrganisationUnit) &&
        Objects.equals(this.showSignedBy, operationSignatureIdentifier.showSignedBy) &&
        Objects.equals(this.showState, operationSignatureIdentifier.showState) &&
        Objects.equals(this.textSignedBy, operationSignatureIdentifier.textSignedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(showCommonName, showCountry, showDate, showLocal, showMail, showName, showOrganisationName, showOrganisationUnit, showSignedBy, showState, textSignedBy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationSignatureIdentifier {\n");
    sb.append("    showCommonName: ").append(toIndentedString(showCommonName)).append("\n");
    sb.append("    showCountry: ").append(toIndentedString(showCountry)).append("\n");
    sb.append("    showDate: ").append(toIndentedString(showDate)).append("\n");
    sb.append("    showLocal: ").append(toIndentedString(showLocal)).append("\n");
    sb.append("    showMail: ").append(toIndentedString(showMail)).append("\n");
    sb.append("    showName: ").append(toIndentedString(showName)).append("\n");
    sb.append("    showOrganisationName: ").append(toIndentedString(showOrganisationName)).append("\n");
    sb.append("    showOrganisationUnit: ").append(toIndentedString(showOrganisationUnit)).append("\n");
    sb.append("    showSignedBy: ").append(toIndentedString(showSignedBy)).append("\n");
    sb.append("    showState: ").append(toIndentedString(showState)).append("\n");
    sb.append("    textSignedBy: ").append(toIndentedString(textSignedBy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
