/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Used to define page scaling operations.
 */
@Schema(description = "Used to define page scaling operations.")
@JsonPropertyOrder({
  OperationScalePagesToolboxScale.JSON_PROPERTY_DIMENSIONS,
  OperationScalePagesToolboxScale.JSON_PROPERTY_HORIZONTAL_ALIGNMENT,
  OperationScalePagesToolboxScale.JSON_PROPERTY_PAGES,
  OperationScalePagesToolboxScale.JSON_PROPERTY_PRESERVE_ASPECT_RATIO,
  OperationScalePagesToolboxScale.JSON_PROPERTY_SCALE_BOXES,
  OperationScalePagesToolboxScale.JSON_PROPERTY_VERTICAL_ALIGNMENT
})
@JsonTypeName("Operation_ScalePagesToolboxScale")

public class OperationScalePagesToolboxScale {
  public static final String JSON_PROPERTY_DIMENSIONS = "dimensions";
  private OperationPaddedRectangle dimensions;

  public static final String JSON_PROPERTY_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
  private String horizontalAlignment = "left";

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "";

  public static final String JSON_PROPERTY_PRESERVE_ASPECT_RATIO = "preserveAspectRatio";
  private Boolean preserveAspectRatio = true;

  public static final String JSON_PROPERTY_SCALE_BOXES = "scaleBoxes";
  private Boolean scaleBoxes = true;

  public static final String JSON_PROPERTY_VERTICAL_ALIGNMENT = "verticalAlignment";
  private String verticalAlignment = "top";

  public OperationScalePagesToolboxScale() {
  }

  public OperationScalePagesToolboxScale dimensions(OperationPaddedRectangle dimensions) {
    
    this.dimensions = dimensions;
    return this;
  }

  /**
   * Get dimensions
   * @return dimensions
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_DIMENSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationPaddedRectangle getDimensions() {
    return dimensions;
  }


  @JsonProperty(JSON_PROPERTY_DIMENSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDimensions(OperationPaddedRectangle dimensions) {
    this.dimensions = dimensions;
  }


  public OperationScalePagesToolboxScale horizontalAlignment(String horizontalAlignment) {
    
    this.horizontalAlignment = horizontalAlignment;
    return this;
  }

  /**
   * If margins are created when the page is scaled or if the page content must be positioned relative to a context (for example, the crop box), this value specifies how margins are to be split and how overall page content is to be positioned on the page.  *   left &#x3D; Contents are to be arranged left-justified. *   center &#x3D; Content should be centered. *   right &#x3D; Contents should be arranged right-justified.
   * @return horizontalAlignment
   **/
  @Nullable
  @Schema(name = "If margins are created when the page is scaled or if the page content must be positioned relative to a context (for example, the crop box), this value specifies how margins are to be split and how overall page content is to be positioned on the page.  *   left = Contents are to be arranged left-justified. *   center = Content should be centered. *   right = Contents should be arranged right-justified.")
  @JsonProperty(JSON_PROPERTY_HORIZONTAL_ALIGNMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHorizontalAlignment() {
    return horizontalAlignment;
  }


  @JsonProperty(JSON_PROPERTY_HORIZONTAL_ALIGNMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHorizontalAlignment(String horizontalAlignment) {
    this.horizontalAlignment = horizontalAlignment;
  }


  public OperationScalePagesToolboxScale pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * Specifies which page(s) should be scaled. The page number can be either a single page, a range of pages or a list (separated by commas) (e.g. \&quot;1.5-6.9\&quot;). The specification of all pages is done with \&quot;\\*\&quot;.
   * @return pages
   **/
  @Nullable
  @Schema(name = "Specifies which page(s) should be scaled. The page number can be either a single page, a range of pages or a list (separated by commas) (e.g. \"1.5-6.9\"). The specification of all pages is done with \"\\*\".")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  public OperationScalePagesToolboxScale preserveAspectRatio(Boolean preserveAspectRatio) {
    
    this.preserveAspectRatio = preserveAspectRatio;
    return this;
  }

  /**
   * Specifies whether the ratio of the page dimensions to each other should be maintained when scaling the page. This may result in deviations from the given target height or width (depending on requirements).
   * @return preserveAspectRatio
   **/
  @Nullable
  @Schema(name = "Specifies whether the ratio of the page dimensions to each other should be maintained when scaling the page. This may result in deviations from the given target height or width (depending on requirements).")
  @JsonProperty(JSON_PROPERTY_PRESERVE_ASPECT_RATIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPreserveAspectRatio() {
    return preserveAspectRatio;
  }


  @JsonProperty(JSON_PROPERTY_PRESERVE_ASPECT_RATIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreserveAspectRatio(Boolean preserveAspectRatio) {
    this.preserveAspectRatio = preserveAspectRatio;
  }


  public OperationScalePagesToolboxScale scaleBoxes(Boolean scaleBoxes) {
    
    this.scaleBoxes = scaleBoxes;
    return this;
  }

  /**
   * Specifies whether the scaling of the page should also affect the boxes (Mediabox, Cropbox, etc.) of a page. If this is not the case (false), the actual page dimensions, crop boxes, etc. remain as they were originally and only page contents are scaled. The content can become much smaller or larger than the containing page in this way, which can lead to either large blank areas or overflow of the page content.
   * @return scaleBoxes
   **/
  @Nullable
  @Schema(name = "Specifies whether the scaling of the page should also affect the boxes (Mediabox, Cropbox, etc.) of a page. If this is not the case (false), the actual page dimensions, crop boxes, etc. remain as they were originally and only page contents are scaled. The content can become much smaller or larger than the containing page in this way, which can lead to either large blank areas or overflow of the page content.")
  @JsonProperty(JSON_PROPERTY_SCALE_BOXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getScaleBoxes() {
    return scaleBoxes;
  }


  @JsonProperty(JSON_PROPERTY_SCALE_BOXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScaleBoxes(Boolean scaleBoxes) {
    this.scaleBoxes = scaleBoxes;
  }


  public OperationScalePagesToolboxScale verticalAlignment(String verticalAlignment) {
    
    this.verticalAlignment = verticalAlignment;
    return this;
  }

  /**
   * If margins are created when the page is scaled or if the page content must be positioned relative to a context (for example, the crop box), this value specifies how margins are to be split and how overall page content is to be positioned on the page.  *   top &#x3D; Content should be positioned at the top of the page. *   center &#x3D; Content should be centered. *   bottom &#x3D; content should be positioned at the bottom.
   * @return verticalAlignment
   **/
  @Nullable
  @Schema(name = "If margins are created when the page is scaled or if the page content must be positioned relative to a context (for example, the crop box), this value specifies how margins are to be split and how overall page content is to be positioned on the page.  *   top = Content should be positioned at the top of the page. *   center = Content should be centered. *   bottom = content should be positioned at the bottom.")
  @JsonProperty(JSON_PROPERTY_VERTICAL_ALIGNMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVerticalAlignment() {
    return verticalAlignment;
  }


  @JsonProperty(JSON_PROPERTY_VERTICAL_ALIGNMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVerticalAlignment(String verticalAlignment) {
    this.verticalAlignment = verticalAlignment;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationScalePagesToolboxScale operationScalePagesToolboxScale = (OperationScalePagesToolboxScale) o;
    return Objects.equals(this.dimensions, operationScalePagesToolboxScale.dimensions) &&
        Objects.equals(this.horizontalAlignment, operationScalePagesToolboxScale.horizontalAlignment) &&
        Objects.equals(this.pages, operationScalePagesToolboxScale.pages) &&
        Objects.equals(this.preserveAspectRatio, operationScalePagesToolboxScale.preserveAspectRatio) &&
        Objects.equals(this.scaleBoxes, operationScalePagesToolboxScale.scaleBoxes) &&
        Objects.equals(this.verticalAlignment, operationScalePagesToolboxScale.verticalAlignment);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dimensions, horizontalAlignment, pages, preserveAspectRatio, scaleBoxes, verticalAlignment);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationScalePagesToolboxScale {\n");
    sb.append("    dimensions: ").append(toIndentedString(dimensions)).append("\n");
    sb.append("    horizontalAlignment: ").append(toIndentedString(horizontalAlignment)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    preserveAspectRatio: ").append(toIndentedString(preserveAspectRatio)).append("\n");
    sb.append("    scaleBoxes: ").append(toIndentedString(scaleBoxes)).append("\n");
    sb.append("    verticalAlignment: ").append(toIndentedString(verticalAlignment)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
