/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The \&quot;OCR\&quot; web service can be used to run character recognition in PDF documents or images. If recognition is run on images, they will be converted to PDF documents. More specifically, a page will be generated for each image in the PDF document, with this page containing the original image and a text layer with the recognized text. Character recognition on PDF documents will only work with documents that do not contain text already. Normally, these will be documents that were generated by scanners and that only have an image per page in the PDF document.
 */
@Schema(description = "The \"OCR\" web service can be used to run character recognition in PDF documents or images. If recognition is run on images, they will be converted to PDF documents. More specifically, a page will be generated for each image in the PDF document, with this page containing the original image and a text layer with the recognized text. Character recognition on PDF documents will only work with documents that do not contain text already. Normally, these will be documents that were generated by scanners and that only have an image per page in the PDF document.")
@JsonPropertyOrder({
  OperationOcr.JSON_PROPERTY_CHECK_RESOLUTION,
  OperationOcr.JSON_PROPERTY_FAIL_ON_WARNING,
  OperationOcr.JSON_PROPERTY_FORCE_EACH_PAGE,
  OperationOcr.JSON_PROPERTY_IMAGE_DPI,
  OperationOcr.JSON_PROPERTY_JPEG_QUALITY,
  OperationOcr.JSON_PROPERTY_LANGUAGE,
  OperationOcr.JSON_PROPERTY_NORMALIZE_PAGE_ROTATION,
  OperationOcr.JSON_PROPERTY_OCR_MODE,
  OperationOcr.JSON_PROPERTY_OPTIMIZATION,
  OperationOcr.JSON_PROPERTY_OUTPUT_FORMAT,
  OperationOcr.JSON_PROPERTY_PAGE,
  OperationOcr.JSON_PROPERTY_PDFA
})
@JsonTypeName("Operation_Ocr")

public class OperationOcr {
  public static final String JSON_PROPERTY_CHECK_RESOLUTION = "checkResolution";
  private Boolean checkResolution = true;

  public static final String JSON_PROPERTY_FAIL_ON_WARNING = "failOnWarning";
  private Boolean failOnWarning = false;

  public static final String JSON_PROPERTY_FORCE_EACH_PAGE = "forceEachPage";
  private Boolean forceEachPage = false;

  public static final String JSON_PROPERTY_IMAGE_DPI = "imageDpi";
  private Integer imageDpi = 200;

  public static final String JSON_PROPERTY_JPEG_QUALITY = "jpegQuality";
  private Integer jpegQuality = 75;

  /**
   * Used to specify the language for the output document (PDF/image). The language must be defined for the character recognition operation (OCR) so that the \&quot;special characters\&quot; of the respective language (e.g. \&quot;üäö\&quot; in German) can be recognized better. At present, the following languages are supported:  *   eng &#x3D; English *   fra &#x3D; French *   spa &#x3D; Spanish *   deu &#x3D; German *   ita &#x3D; Italian
   */
  public enum LanguageEnum {
    ENG(String.valueOf("eng")),
    
    DEU(String.valueOf("deu")),
    
    FRA(String.valueOf("fra")),
    
    ITA(String.valueOf("ita")),
    
    SPA(String.valueOf("spa"));

    private String value;

    LanguageEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LanguageEnum fromValue(String value) {
      for (LanguageEnum b : LanguageEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private LanguageEnum language = LanguageEnum.ENG;

  public static final String JSON_PROPERTY_NORMALIZE_PAGE_ROTATION = "normalizePageRotation";
  private Boolean normalizePageRotation = false;

  /**
   * Specifies the mode used to find structured text on the pages. Depending on which mode is chosen, different requirements are set for the text and different assumptions are made about the text.  *   pageSegments &#x3D; The text on the page is clearly structured and decomposable into clear paragraphs and layout segments. Overlapping of text elements/lines does not occur. Headings and thus texts with deviating text sizes and font set, could be present. *   column &#x3D; The text is arranged on the pages in several, more or less uniform columns, next to each other. Font and text size are mostly uniform. *   unfiltered &#x3D; No assumptions are made about the text, any letters that can be found are recognized as such, regardless of whether they can be assigned to a text column, or line, or even a word. Font size and typeface can vary absolutely and texts are not necessarily arranged in clearly recognizable columns or according to a fixed layout. Texts and lines can overlap. (This mode usually recognizes more text (especially with more complex layouts), but usually also generates the most error detections, since no result is sorted out due to its deviation from the norm.
   */
  public enum OcrModeEnum {
    PAGE_SEGMENTS(String.valueOf("pageSegments")),
    
    COLUMN(String.valueOf("column")),
    
    UNFILTERED(String.valueOf("unfiltered"));

    private String value;

    OcrModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OcrModeEnum fromValue(String value) {
      for (OcrModeEnum b : OcrModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OCR_MODE = "ocrMode";
  private OcrModeEnum ocrMode = OcrModeEnum.PAGE_SEGMENTS;

  public static final String JSON_PROPERTY_OPTIMIZATION = "optimization";
  private OperationImageOptimization optimization;

  /**
   * Different output formats can be created during character recognition. Generally, the document is generated as a PDF document, but the output can also be as an ASCII document or an XML document if desired (HOCR).  *   text &#x3D; Text *   hocr &#x3D; XML (hOCR) *   pdf &#x3D; PDF
   */
  public enum OutputFormatEnum {
    TEXT(String.valueOf("text")),
    
    HOCR(String.valueOf("hocr")),
    
    PDF(String.valueOf("pdf"));

    private String value;

    OutputFormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OutputFormatEnum fromValue(String value) {
      for (OutputFormatEnum b : OutputFormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OUTPUT_FORMAT = "outputFormat";
  private OutputFormatEnum outputFormat = OutputFormatEnum.PDF;

  public static final String JSON_PROPERTY_PAGE = "page";
  private OperationOcrPage page;

  public static final String JSON_PROPERTY_PDFA = "pdfa";
  private OperationPdfa pdfa;

  public OperationOcr() {
  }

  public OperationOcr checkResolution(Boolean checkResolution) {
    
    this.checkResolution = checkResolution;
    return this;
  }

  /**
   * If \&quot;true,\&quot; then the DPI resolution of the output file will be checked. Resolutions of less than 200 DPI are rejected in this check because as a rule, they do not produce good results for character recognition.
   * @return checkResolution
   **/
  @Nullable
  @Schema(name = "If \"true,\" then the DPI resolution of the output file will be checked. Resolutions of less than 200 DPI are rejected in this check because as a rule, they do not produce good results for character recognition.")
  @JsonProperty(JSON_PROPERTY_CHECK_RESOLUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCheckResolution() {
    return checkResolution;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_RESOLUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckResolution(Boolean checkResolution) {
    this.checkResolution = checkResolution;
  }


  public OperationOcr failOnWarning(Boolean failOnWarning) {
    
    this.failOnWarning = failOnWarning;
    return this;
  }

  /**
   * If \&quot;true\&quot;, character recognition will fail even in the event of warnings that do not prevent recognition, but that make it very unlikely for a meaningful result to be generated.
   * @return failOnWarning
   **/
  @Nullable
  @Schema(name = "If \"true\", character recognition will fail even in the event of warnings that do not prevent recognition, but that make it very unlikely for a meaningful result to be generated.")
  @JsonProperty(JSON_PROPERTY_FAIL_ON_WARNING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFailOnWarning() {
    return failOnWarning;
  }


  @JsonProperty(JSON_PROPERTY_FAIL_ON_WARNING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFailOnWarning(Boolean failOnWarning) {
    this.failOnWarning = failOnWarning;
  }


  public OperationOcr forceEachPage(Boolean forceEachPage) {
    
    this.forceEachPage = forceEachPage;
    return this;
  }

  /**
   * If a PDF document contains text content on any page, the web service will refuse to run character recognition again. If, however, a value of \&quot;true\&quot; is passed for this option, all the pages in the document will be considered individually and character recognition will be run on all pages that do not contain text (layers) so that a new layer with text will be generated for them.
   * @return forceEachPage
   **/
  @Nullable
  @Schema(name = "If a PDF document contains text content on any page, the web service will refuse to run character recognition again. If, however, a value of \"true\" is passed for this option, all the pages in the document will be considered individually and character recognition will be run on all pages that do not contain text (layers) so that a new layer with text will be generated for them.")
  @JsonProperty(JSON_PROPERTY_FORCE_EACH_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getForceEachPage() {
    return forceEachPage;
  }


  @JsonProperty(JSON_PROPERTY_FORCE_EACH_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForceEachPage(Boolean forceEachPage) {
    this.forceEachPage = forceEachPage;
  }


  public OperationOcr imageDpi(Integer imageDpi) {
    
    this.imageDpi = imageDpi;
    return this;
  }

  /**
   * Used to set the minimum resolution images will be embedded with in resulting PDF documents. When a value of 0 is set for this parameter, the images shall be embedded using resolutions and dimensions as close as possible to the original source images.
   * minimum: 0
   * maximum: 9600
   * @return imageDpi
   **/
  @Nullable
  @Schema(name = "Used to set the minimum resolution images will be embedded with in resulting PDF documents. When a value of 0 is set for this parameter, the images shall be embedded using resolutions and dimensions as close as possible to the original source images.")
  @JsonProperty(JSON_PROPERTY_IMAGE_DPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getImageDpi() {
    return imageDpi;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_DPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageDpi(Integer imageDpi) {
    this.imageDpi = imageDpi;
  }


  public OperationOcr jpegQuality(Integer jpegQuality) {
    
    this.jpegQuality = jpegQuality;
    return this;
  }

  /**
   * A percentage that sets the compression ratio and influences the quality of JPEG images, that shall be embedded in resulting PDF documents. Higher values will result in less compressed images of higher quality.
   * minimum: 0
   * maximum: 100
   * @return jpegQuality
   **/
  @Nullable
  @Schema(name = "A percentage that sets the compression ratio and influences the quality of JPEG images, that shall be embedded in resulting PDF documents. Higher values will result in less compressed images of higher quality.")
  @JsonProperty(JSON_PROPERTY_JPEG_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getJpegQuality() {
    return jpegQuality;
  }


  @JsonProperty(JSON_PROPERTY_JPEG_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJpegQuality(Integer jpegQuality) {
    this.jpegQuality = jpegQuality;
  }


  public OperationOcr language(LanguageEnum language) {
    
    this.language = language;
    return this;
  }

  /**
   * Used to specify the language for the output document (PDF/image). The language must be defined for the character recognition operation (OCR) so that the \&quot;special characters\&quot; of the respective language (e.g. \&quot;üäö\&quot; in German) can be recognized better. At present, the following languages are supported:  *   eng &#x3D; English *   fra &#x3D; French *   spa &#x3D; Spanish *   deu &#x3D; German *   ita &#x3D; Italian
   * @return language
   **/
  @Nullable
  @Schema(name = "Used to specify the language for the output document (PDF/image). The language must be defined for the character recognition operation (OCR) so that the \"special characters\" of the respective language (e.g. \"üäö\" in German) can be recognized better. At present, the following languages are supported:  *   eng = English *   fra = French *   spa = Spanish *   deu = German *   ita = Italian")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LanguageEnum getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(LanguageEnum language) {
    this.language = language;
  }


  public OperationOcr normalizePageRotation(Boolean normalizePageRotation) {
    
    this.normalizePageRotation = normalizePageRotation;
    return this;
  }

  /**
   * If \&quot;true\&quot;, then, for the recognition of a rotated text, the system will attempt to rotate the page in such a way that the text in the document will not appear to be rotated and will be shown \&quot;upright.\&quot;
   * @return normalizePageRotation
   **/
  @Nullable
  @Schema(name = "If \"true\", then, for the recognition of a rotated text, the system will attempt to rotate the page in such a way that the text in the document will not appear to be rotated and will be shown \"upright.\"")
  @JsonProperty(JSON_PROPERTY_NORMALIZE_PAGE_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getNormalizePageRotation() {
    return normalizePageRotation;
  }


  @JsonProperty(JSON_PROPERTY_NORMALIZE_PAGE_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNormalizePageRotation(Boolean normalizePageRotation) {
    this.normalizePageRotation = normalizePageRotation;
  }


  public OperationOcr ocrMode(OcrModeEnum ocrMode) {
    
    this.ocrMode = ocrMode;
    return this;
  }

  /**
   * Specifies the mode used to find structured text on the pages. Depending on which mode is chosen, different requirements are set for the text and different assumptions are made about the text.  *   pageSegments &#x3D; The text on the page is clearly structured and decomposable into clear paragraphs and layout segments. Overlapping of text elements/lines does not occur. Headings and thus texts with deviating text sizes and font set, could be present. *   column &#x3D; The text is arranged on the pages in several, more or less uniform columns, next to each other. Font and text size are mostly uniform. *   unfiltered &#x3D; No assumptions are made about the text, any letters that can be found are recognized as such, regardless of whether they can be assigned to a text column, or line, or even a word. Font size and typeface can vary absolutely and texts are not necessarily arranged in clearly recognizable columns or according to a fixed layout. Texts and lines can overlap. (This mode usually recognizes more text (especially with more complex layouts), but usually also generates the most error detections, since no result is sorted out due to its deviation from the norm.
   * @return ocrMode
   **/
  @Nullable
  @Schema(name = "Specifies the mode used to find structured text on the pages. Depending on which mode is chosen, different requirements are set for the text and different assumptions are made about the text.  *   pageSegments = The text on the page is clearly structured and decomposable into clear paragraphs and layout segments. Overlapping of text elements/lines does not occur. Headings and thus texts with deviating text sizes and font set, could be present. *   column = The text is arranged on the pages in several, more or less uniform columns, next to each other. Font and text size are mostly uniform. *   unfiltered = No assumptions are made about the text, any letters that can be found are recognized as such, regardless of whether they can be assigned to a text column, or line, or even a word. Font size and typeface can vary absolutely and texts are not necessarily arranged in clearly recognizable columns or according to a fixed layout. Texts and lines can overlap. (This mode usually recognizes more text (especially with more complex layouts), but usually also generates the most error detections, since no result is sorted out due to its deviation from the norm.")
  @JsonProperty(JSON_PROPERTY_OCR_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OcrModeEnum getOcrMode() {
    return ocrMode;
  }


  @JsonProperty(JSON_PROPERTY_OCR_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOcrMode(OcrModeEnum ocrMode) {
    this.ocrMode = ocrMode;
  }


  public OperationOcr optimization(OperationImageOptimization optimization) {
    
    this.optimization = optimization;
    return this;
  }

  /**
   * Get optimization
   * @return optimization
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_OPTIMIZATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationImageOptimization getOptimization() {
    return optimization;
  }


  @JsonProperty(JSON_PROPERTY_OPTIMIZATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOptimization(OperationImageOptimization optimization) {
    this.optimization = optimization;
  }


  public OperationOcr outputFormat(OutputFormatEnum outputFormat) {
    
    this.outputFormat = outputFormat;
    return this;
  }

  /**
   * Different output formats can be created during character recognition. Generally, the document is generated as a PDF document, but the output can also be as an ASCII document or an XML document if desired (HOCR).  *   text &#x3D; Text *   hocr &#x3D; XML (hOCR) *   pdf &#x3D; PDF
   * @return outputFormat
   **/
  @Nullable
  @Schema(name = "Different output formats can be created during character recognition. Generally, the document is generated as a PDF document, but the output can also be as an ASCII document or an XML document if desired (HOCR).  *   text = Text *   hocr = XML (hOCR) *   pdf = PDF")
  @JsonProperty(JSON_PROPERTY_OUTPUT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OutputFormatEnum getOutputFormat() {
    return outputFormat;
  }


  @JsonProperty(JSON_PROPERTY_OUTPUT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOutputFormat(OutputFormatEnum outputFormat) {
    this.outputFormat = outputFormat;
  }


  public OperationOcr page(OperationOcrPage page) {
    
    this.page = page;
    return this;
  }

  /**
   * Get page
   * @return page
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationOcrPage getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(OperationOcrPage page) {
    this.page = page;
  }


  public OperationOcr pdfa(OperationPdfa pdfa) {
    
    this.pdfa = pdfa;
    return this;
  }

  /**
   * Get pdfa
   * @return pdfa
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PDFA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationPdfa getPdfa() {
    return pdfa;
  }


  @JsonProperty(JSON_PROPERTY_PDFA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPdfa(OperationPdfa pdfa) {
    this.pdfa = pdfa;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationOcr operationOcr = (OperationOcr) o;
    return Objects.equals(this.checkResolution, operationOcr.checkResolution) &&
        Objects.equals(this.failOnWarning, operationOcr.failOnWarning) &&
        Objects.equals(this.forceEachPage, operationOcr.forceEachPage) &&
        Objects.equals(this.imageDpi, operationOcr.imageDpi) &&
        Objects.equals(this.jpegQuality, operationOcr.jpegQuality) &&
        Objects.equals(this.language, operationOcr.language) &&
        Objects.equals(this.normalizePageRotation, operationOcr.normalizePageRotation) &&
        Objects.equals(this.ocrMode, operationOcr.ocrMode) &&
        Objects.equals(this.optimization, operationOcr.optimization) &&
        Objects.equals(this.outputFormat, operationOcr.outputFormat) &&
        Objects.equals(this.page, operationOcr.page) &&
        Objects.equals(this.pdfa, operationOcr.pdfa);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkResolution, failOnWarning, forceEachPage, imageDpi, jpegQuality, language, normalizePageRotation, ocrMode, optimization, outputFormat, page, pdfa);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationOcr {\n");
    sb.append("    checkResolution: ").append(toIndentedString(checkResolution)).append("\n");
    sb.append("    failOnWarning: ").append(toIndentedString(failOnWarning)).append("\n");
    sb.append("    forceEachPage: ").append(toIndentedString(forceEachPage)).append("\n");
    sb.append("    imageDpi: ").append(toIndentedString(imageDpi)).append("\n");
    sb.append("    jpegQuality: ").append(toIndentedString(jpegQuality)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    normalizePageRotation: ").append(toIndentedString(normalizePageRotation)).append("\n");
    sb.append("    ocrMode: ").append(toIndentedString(ocrMode)).append("\n");
    sb.append("    optimization: ").append(toIndentedString(optimization)).append("\n");
    sb.append("    outputFormat: ").append(toIndentedString(outputFormat)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    pdfa: ").append(toIndentedString(pdfa)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
