/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines the options for all external HTTP requests made by the server during the execution of the web service operation.
 */
@Schema(description = "Defines the options for all external HTTP requests made by the server during the execution of the web service operation.")
@JsonPropertyOrder({
  OperationHttpSettings.JSON_PROPERTY_FOLLOW_REDIRECT,
  OperationHttpSettings.JSON_PROPERTY_HEADERS,
  OperationHttpSettings.JSON_PROPERTY_SSL,
  OperationHttpSettings.JSON_PROPERTY_TIMEOUT,
  OperationHttpSettings.JSON_PROPERTY_USER_AGENT
})
@JsonTypeName("Operation_HttpSettings")

public class OperationHttpSettings {
  public static final String JSON_PROPERTY_FOLLOW_REDIRECT = "followRedirect";
  private Boolean followRedirect = true;

  public static final String JSON_PROPERTY_HEADERS = "headers";
  private OperationHttpSettingsHeader headers;

  public static final String JSON_PROPERTY_SSL = "ssl";
  private OperationHttpSettingsSSL ssl;

  public static final String JSON_PROPERTY_TIMEOUT = "timeout";
  private OperationHttpSettingsTimeout timeout;

  public static final String JSON_PROPERTY_USER_AGENT = "userAgent";
  private String userAgent = "";

  public OperationHttpSettings() {
  }

  public OperationHttpSettings followRedirect(Boolean followRedirect) {
    
    this.followRedirect = followRedirect;
    return this;
  }

  /**
   * Get followRedirect
   * @return followRedirect
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FOLLOW_REDIRECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFollowRedirect() {
    return followRedirect;
  }


  @JsonProperty(JSON_PROPERTY_FOLLOW_REDIRECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowRedirect(Boolean followRedirect) {
    this.followRedirect = followRedirect;
  }


  public OperationHttpSettings headers(OperationHttpSettingsHeader headers) {
    
    this.headers = headers;
    return this;
  }

  /**
   * Get headers
   * @return headers
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationHttpSettingsHeader getHeaders() {
    return headers;
  }


  @JsonProperty(JSON_PROPERTY_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeaders(OperationHttpSettingsHeader headers) {
    this.headers = headers;
  }


  public OperationHttpSettings ssl(OperationHttpSettingsSSL ssl) {
    
    this.ssl = ssl;
    return this;
  }

  /**
   * Get ssl
   * @return ssl
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SSL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationHttpSettingsSSL getSsl() {
    return ssl;
  }


  @JsonProperty(JSON_PROPERTY_SSL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSsl(OperationHttpSettingsSSL ssl) {
    this.ssl = ssl;
  }


  public OperationHttpSettings timeout(OperationHttpSettingsTimeout timeout) {
    
    this.timeout = timeout;
    return this;
  }

  /**
   * Get timeout
   * @return timeout
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationHttpSettingsTimeout getTimeout() {
    return timeout;
  }


  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeout(OperationHttpSettingsTimeout timeout) {
    this.timeout = timeout;
  }


  public OperationHttpSettings userAgent(String userAgent) {
    
    this.userAgent = userAgent;
    return this;
  }

  /**
   * Get userAgent
   * @return userAgent
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_USER_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserAgent() {
    return userAgent;
  }


  @JsonProperty(JSON_PROPERTY_USER_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserAgent(String userAgent) {
    this.userAgent = userAgent;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationHttpSettings operationHttpSettings = (OperationHttpSettings) o;
    return Objects.equals(this.followRedirect, operationHttpSettings.followRedirect) &&
        Objects.equals(this.headers, operationHttpSettings.headers) &&
        Objects.equals(this.ssl, operationHttpSettings.ssl) &&
        Objects.equals(this.timeout, operationHttpSettings.timeout) &&
        Objects.equals(this.userAgent, operationHttpSettings.userAgent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(followRedirect, headers, ssl, timeout, userAgent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationHttpSettings {\n");
    sb.append("    followRedirect: ").append(toIndentedString(followRedirect)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    ssl: ").append(toIndentedString(ssl)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    userAgent: ").append(toIndentedString(userAgent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
