/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * A font definition for textual annotation types.
 */
@Schema(description = "A font definition for textual annotation types.")
@JsonPropertyOrder({
  OperationFreeTextFont.JSON_PROPERTY_BOLD,
  OperationFreeTextFont.JSON_PROPERTY_COLOR,
  OperationFreeTextFont.JSON_PROPERTY_ITALIC,
  OperationFreeTextFont.JSON_PROPERTY_NAME,
  OperationFreeTextFont.JSON_PROPERTY_SIZE
})
@JsonTypeName("Operation_FreeTextFont")

public class OperationFreeTextFont {
  public static final String JSON_PROPERTY_BOLD = "bold";
  private Boolean bold = false;

  public static final String JSON_PROPERTY_COLOR = "color";
  private String color = "#A0A0A0";

  public static final String JSON_PROPERTY_ITALIC = "italic";
  private Boolean italic = false;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name = "";

  public static final String JSON_PROPERTY_SIZE = "size";
  private Integer size = 24;

  public OperationFreeTextFont() {
  }

  public OperationFreeTextFont bold(Boolean bold) {
    
    this.bold = bold;
    return this;
  }

  /**
   * Used to increase the text output&#39;s weight.
   * @return bold
   **/
  @Nullable
  @Schema(name = "Used to increase the text output's weight.")
  @JsonProperty(JSON_PROPERTY_BOLD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getBold() {
    return bold;
  }


  @JsonProperty(JSON_PROPERTY_BOLD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBold(Boolean bold) {
    this.bold = bold;
  }


  public OperationFreeTextFont color(String color) {
    
    this.color = color;
    return this;
  }

  /**
   * Used to set the font color. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.
   * @return color
   **/
  @Nullable
  @Schema(name = "Used to set the font color. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.")
  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public OperationFreeTextFont italic(Boolean italic) {
    
    this.italic = italic;
    return this;
  }

  /**
   * Used to set the italic font posture for the text output.
   * @return italic
   **/
  @Nullable
  @Schema(name = "Used to set the italic font posture for the text output.")
  @JsonProperty(JSON_PROPERTY_ITALIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getItalic() {
    return italic;
  }


  @JsonProperty(JSON_PROPERTY_ITALIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItalic(Boolean italic) {
    this.italic = italic;
  }


  public OperationFreeTextFont name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Used to specify the name of the font that should be used for the text output.
   * @return name
   **/
  @Nullable
  @Schema(name = "Used to specify the name of the font that should be used for the text output.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public OperationFreeTextFont size(Integer size) {
    
    this.size = size;
    return this;
  }

  /**
   * Used to set the text size for the text output.
   * minimum: 1
   * maximum: 1296
   * @return size
   **/
  @Nullable
  @Schema(name = "Used to set the text size for the text output.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSize(Integer size) {
    this.size = size;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationFreeTextFont operationFreeTextFont = (OperationFreeTextFont) o;
    return Objects.equals(this.bold, operationFreeTextFont.bold) &&
        Objects.equals(this.color, operationFreeTextFont.color) &&
        Objects.equals(this.italic, operationFreeTextFont.italic) &&
        Objects.equals(this.name, operationFreeTextFont.name) &&
        Objects.equals(this.size, operationFreeTextFont.size);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bold, color, italic, name, size);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationFreeTextFont {\n");
    sb.append("    bold: ").append(toIndentedString(bold)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    italic: ").append(toIndentedString(italic)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
