/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Used to define the position and dimensions of a containing element.
 */
@Schema(description = "Used to define the position and dimensions of a containing element.")
@JsonPropertyOrder({
  OperationDimensionsBoxesResize.JSON_PROPERTY_HEIGHT,
  OperationDimensionsBoxesResize.JSON_PROPERTY_METRICS,
  OperationDimensionsBoxesResize.JSON_PROPERTY_WIDTH,
  OperationDimensionsBoxesResize.JSON_PROPERTY_X,
  OperationDimensionsBoxesResize.JSON_PROPERTY_Y
})
@JsonTypeName("Operation_DimensionsBoxesResize")

public class OperationDimensionsBoxesResize {
  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Float height = 0f;

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   */
  public enum MetricsEnum {
    PT(String.valueOf("pt")),
    
    PC(String.valueOf("pc")),
    
    PX(String.valueOf("px")),
    
    MM(String.valueOf("mm")),
    
    IN(String.valueOf("in"));

    private String value;

    MetricsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MetricsEnum fromValue(String value) {
      for (MetricsEnum b : MetricsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_METRICS = "metrics";
  private MetricsEnum metrics = MetricsEnum.MM;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Float width = 0f;

  public static final String JSON_PROPERTY_X = "x";
  private Float x = 0f;

  public static final String JSON_PROPERTY_Y = "y";
  private Float y = 0f;

  public OperationDimensionsBoxesResize() {
  }

  public OperationDimensionsBoxesResize height(Float height) {
    
    this.height = height;
    return this;
  }

  /**
   * The height of the element.
   * minimum: 0
   * @return height
   **/
  @Nullable
  @Schema(name = "The height of the element.")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeight(Float height) {
    this.height = height;
  }


  public OperationDimensionsBoxesResize metrics(MetricsEnum metrics) {
    
    this.metrics = metrics;
    return this;
  }

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   * @return metrics
   **/
  @Nullable
  @Schema(name = "Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetricsEnum getMetrics() {
    return metrics;
  }


  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetrics(MetricsEnum metrics) {
    this.metrics = metrics;
  }


  public OperationDimensionsBoxesResize width(Float width) {
    
    this.width = width;
    return this;
  }

  /**
   * The width of the element.
   * minimum: 0
   * @return width
   **/
  @Nullable
  @Schema(name = "The width of the element.")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(Float width) {
    this.width = width;
  }


  public OperationDimensionsBoxesResize x(Float x) {
    
    this.x = x;
    return this;
  }

  /**
   * The horizontal displacement of the element.
   * minimum: 0
   * @return x
   **/
  @Nullable
  @Schema(name = "The horizontal displacement of the element.")
  @JsonProperty(JSON_PROPERTY_X)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getX() {
    return x;
  }


  @JsonProperty(JSON_PROPERTY_X)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setX(Float x) {
    this.x = x;
  }


  public OperationDimensionsBoxesResize y(Float y) {
    
    this.y = y;
    return this;
  }

  /**
   * The vertical displacement of the element.
   * minimum: 0
   * @return y
   **/
  @Nullable
  @Schema(name = "The vertical displacement of the element.")
  @JsonProperty(JSON_PROPERTY_Y)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getY() {
    return y;
  }


  @JsonProperty(JSON_PROPERTY_Y)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setY(Float y) {
    this.y = y;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationDimensionsBoxesResize operationDimensionsBoxesResize = (OperationDimensionsBoxesResize) o;
    return Objects.equals(this.height, operationDimensionsBoxesResize.height) &&
        Objects.equals(this.metrics, operationDimensionsBoxesResize.metrics) &&
        Objects.equals(this.width, operationDimensionsBoxesResize.width) &&
        Objects.equals(this.x, operationDimensionsBoxesResize.x) &&
        Objects.equals(this.y, operationDimensionsBoxesResize.y);
  }

  @Override
  public int hashCode() {
    return Objects.hash(height, metrics, width, x, y);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationDimensionsBoxesResize {\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    x: ").append(toIndentedString(x)).append("\n");
    sb.append("    y: ").append(toIndentedString(y)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
