/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * This operation is used to define the barcode recognition parameters. The system will attempt to find barcodes inside the area defined with &#x60;&lt;scanArea&gt;&#x60;. The recognition process itself is controlled with &#x60;&lt;selection&gt;&#x60;.
 */
@Schema(description = "This operation is used to define the barcode recognition parameters. The system will attempt to find barcodes inside the area defined with `<scanArea>`. The recognition process itself is controlled with `<selection>`.")
@JsonPropertyOrder({
  OperationDetectBarcode.JSON_PROPERTY_INPUT_FORMAT,
  OperationDetectBarcode.JSON_PROPERTY_OUTPUT_FORMAT,
  OperationDetectBarcode.JSON_PROPERTY_SELECTION
})
@JsonTypeName("Operation_DetectBarcode")

public class OperationDetectBarcode {
  /**
   * Used to select the format of the file with the contents that will be scanned for barcodes.  *   pdf &#x3D; PDF document *   img &#x3D; Image document (JPG, PNG, TIF)
   */
  public enum InputFormatEnum {
    PDF(String.valueOf("pdf")),
    
    IMG(String.valueOf("img"));

    private String value;

    InputFormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InputFormatEnum fromValue(String value) {
      for (InputFormatEnum b : InputFormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INPUT_FORMAT = "inputFormat";
  private InputFormatEnum inputFormat = InputFormatEnum.PDF;

  /**
   * Used to select the format in which the recognition results should be returned.  *   json &#x3D; JSON *   xml &#x3D; XML
   */
  public enum OutputFormatEnum {
    XML(String.valueOf("xml")),
    
    JSON(String.valueOf("json"));

    private String value;

    OutputFormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OutputFormatEnum fromValue(String value) {
      for (OutputFormatEnum b : OutputFormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OUTPUT_FORMAT = "outputFormat";
  private OutputFormatEnum outputFormat = OutputFormatEnum.JSON;

  public static final String JSON_PROPERTY_SELECTION = "selection";
  private List<OperationBarcodeSelection> selection = null;

  public OperationDetectBarcode() {
  }

  public OperationDetectBarcode inputFormat(InputFormatEnum inputFormat) {
    
    this.inputFormat = inputFormat;
    return this;
  }

  /**
   * Used to select the format of the file with the contents that will be scanned for barcodes.  *   pdf &#x3D; PDF document *   img &#x3D; Image document (JPG, PNG, TIF)
   * @return inputFormat
   **/
  @Nullable
  @Schema(name = "Used to select the format of the file with the contents that will be scanned for barcodes.  *   pdf = PDF document *   img = Image document (JPG, PNG, TIF)")
  @JsonProperty(JSON_PROPERTY_INPUT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InputFormatEnum getInputFormat() {
    return inputFormat;
  }


  @JsonProperty(JSON_PROPERTY_INPUT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInputFormat(InputFormatEnum inputFormat) {
    this.inputFormat = inputFormat;
  }


  public OperationDetectBarcode outputFormat(OutputFormatEnum outputFormat) {
    
    this.outputFormat = outputFormat;
    return this;
  }

  /**
   * Used to select the format in which the recognition results should be returned.  *   json &#x3D; JSON *   xml &#x3D; XML
   * @return outputFormat
   **/
  @Nullable
  @Schema(name = "Used to select the format in which the recognition results should be returned.  *   json = JSON *   xml = XML")
  @JsonProperty(JSON_PROPERTY_OUTPUT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OutputFormatEnum getOutputFormat() {
    return outputFormat;
  }


  @JsonProperty(JSON_PROPERTY_OUTPUT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOutputFormat(OutputFormatEnum outputFormat) {
    this.outputFormat = outputFormat;
  }


  public OperationDetectBarcode selection(List<OperationBarcodeSelection> selection) {
    
    this.selection = selection;
    return this;
  }

  public OperationDetectBarcode addSelectionItem(OperationBarcodeSelection selectionItem) {
    if (this.selection == null) {
        this.selection = new ArrayList<>();
    }
    this.selection.add(selectionItem);
    return this;
  }

  /**
   * Get selection
   * @return selection
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SELECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationBarcodeSelection> getSelection() {
    return selection;
  }


  @JsonProperty(JSON_PROPERTY_SELECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelection(List<OperationBarcodeSelection> selection) {
    this.selection = selection;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationDetectBarcode operationDetectBarcode = (OperationDetectBarcode) o;
    return Objects.equals(this.inputFormat, operationDetectBarcode.inputFormat) &&
        Objects.equals(this.outputFormat, operationDetectBarcode.outputFormat) &&
        Objects.equals(this.selection, operationDetectBarcode.selection);
  }

  @Override
  public int hashCode() {
    return Objects.hash(inputFormat, outputFormat, selection);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationDetectBarcode {\n");
    sb.append("    inputFormat: ").append(toIndentedString(inputFormat)).append("\n");
    sb.append("    outputFormat: ").append(toIndentedString(outputFormat)).append("\n");
    sb.append("    selection: ").append(toIndentedString(selection)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
