/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * An element of this type shall contain information concerning the used encryption and the used encryption key.
 */
@Schema(description = "An element of this type shall contain information concerning the used encryption and the used encryption key.")
@JsonPropertyOrder({
  MetadataPassword.JSON_PROPERTY_HAS_ASYMMETRIC_ENCRYPTION,
  MetadataPassword.JSON_PROPERTY_HAS_OPEN_PASSWORD,
  MetadataPassword.JSON_PROPERTY_HAS_PERMISSION_PASSWORD,
  MetadataPassword.JSON_PROPERTY_KEY_ALGORITHM,
  MetadataPassword.JSON_PROPERTY_KEY_LENGTH
})
@JsonTypeName("Metadata_Password")

public class MetadataPassword {
  public static final String JSON_PROPERTY_HAS_ASYMMETRIC_ENCRYPTION = "hasAsymmetricEncryption";
  private Boolean hasAsymmetricEncryption = false;

  public static final String JSON_PROPERTY_HAS_OPEN_PASSWORD = "hasOpenPassword";
  private Boolean hasOpenPassword = false;

  public static final String JSON_PROPERTY_HAS_PERMISSION_PASSWORD = "hasPermissionPassword";
  private Boolean hasPermissionPassword = false;

  /**
   * The algorithm used for encryption.  *   none &#x3D; The document is not encrypted. *   aes &#x3D; The document has been encrypted using the Advanced Encryption Standard. *   rc4 &#x3D; The document has been encrypted using the RC4 cipher.
   */
  public enum KeyAlgorithmEnum {
    NONE(String.valueOf("none")),
    
    AES(String.valueOf("aes")),
    
    RC4(String.valueOf("rc4"));

    private String value;

    KeyAlgorithmEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static KeyAlgorithmEnum fromValue(String value) {
      for (KeyAlgorithmEnum b : KeyAlgorithmEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_KEY_ALGORITHM = "keyAlgorithm";
  private KeyAlgorithmEnum keyAlgorithm = KeyAlgorithmEnum.NONE;

  public static final String JSON_PROPERTY_KEY_LENGTH = "keyLength";
  private Integer keyLength = 0;

  public MetadataPassword() {
  }

  public MetadataPassword hasAsymmetricEncryption(Boolean hasAsymmetricEncryption) {
    
    this.hasAsymmetricEncryption = hasAsymmetricEncryption;
    return this;
  }

  /**
   * If this is set to \&quot;true\&quot;, the document is asymmetrically encrypted and a matching private key is required to decrypt it. Otherwise the document is symetrically encrypted and requires a password.
   * @return hasAsymmetricEncryption
   **/
  @Nullable
  @Schema(name = "If this is set to \"true\", the document is asymmetrically encrypted and a matching private key is required to decrypt it. Otherwise the document is symetrically encrypted and requires a password.")
  @JsonProperty(JSON_PROPERTY_HAS_ASYMMETRIC_ENCRYPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAsymmetricEncryption() {
    return hasAsymmetricEncryption;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ASYMMETRIC_ENCRYPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAsymmetricEncryption(Boolean hasAsymmetricEncryption) {
    this.hasAsymmetricEncryption = hasAsymmetricEncryption;
  }


  public MetadataPassword hasOpenPassword(Boolean hasOpenPassword) {
    
    this.hasOpenPassword = hasOpenPassword;
    return this;
  }

  /**
   * If this is set to \&quot;true\&quot;, the document is encrypted and requires a password to be opened.
   * @return hasOpenPassword
   **/
  @Nullable
  @Schema(name = "If this is set to \"true\", the document is encrypted and requires a password to be opened.")
  @JsonProperty(JSON_PROPERTY_HAS_OPEN_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasOpenPassword() {
    return hasOpenPassword;
  }


  @JsonProperty(JSON_PROPERTY_HAS_OPEN_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasOpenPassword(Boolean hasOpenPassword) {
    this.hasOpenPassword = hasOpenPassword;
  }


  public MetadataPassword hasPermissionPassword(Boolean hasPermissionPassword) {
    
    this.hasPermissionPassword = hasPermissionPassword;
    return this;
  }

  /**
   * If this is set to \&quot;true\&quot;, the document has a change protection and a password is required to claim ownership and modify the document.
   * @return hasPermissionPassword
   **/
  @Nullable
  @Schema(name = "If this is set to \"true\", the document has a change protection and a password is required to claim ownership and modify the document.")
  @JsonProperty(JSON_PROPERTY_HAS_PERMISSION_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPermissionPassword() {
    return hasPermissionPassword;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PERMISSION_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPermissionPassword(Boolean hasPermissionPassword) {
    this.hasPermissionPassword = hasPermissionPassword;
  }


  public MetadataPassword keyAlgorithm(KeyAlgorithmEnum keyAlgorithm) {
    
    this.keyAlgorithm = keyAlgorithm;
    return this;
  }

  /**
   * The algorithm used for encryption.  *   none &#x3D; The document is not encrypted. *   aes &#x3D; The document has been encrypted using the Advanced Encryption Standard. *   rc4 &#x3D; The document has been encrypted using the RC4 cipher.
   * @return keyAlgorithm
   **/
  @Nullable
  @Schema(name = "The algorithm used for encryption.  *   none = The document is not encrypted. *   aes = The document has been encrypted using the Advanced Encryption Standard. *   rc4 = The document has been encrypted using the RC4 cipher.")
  @JsonProperty(JSON_PROPERTY_KEY_ALGORITHM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyAlgorithmEnum getKeyAlgorithm() {
    return keyAlgorithm;
  }


  @JsonProperty(JSON_PROPERTY_KEY_ALGORITHM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeyAlgorithm(KeyAlgorithmEnum keyAlgorithm) {
    this.keyAlgorithm = keyAlgorithm;
  }


  public MetadataPassword keyLength(Integer keyLength) {
    
    this.keyLength = keyLength;
    return this;
  }

  /**
   * The Bit length of the key used for encryption.
   * minimum: 0
   * @return keyLength
   **/
  @Nullable
  @Schema(name = "The Bit length of the key used for encryption.")
  @JsonProperty(JSON_PROPERTY_KEY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getKeyLength() {
    return keyLength;
  }


  @JsonProperty(JSON_PROPERTY_KEY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeyLength(Integer keyLength) {
    this.keyLength = keyLength;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataPassword metadataPassword = (MetadataPassword) o;
    return Objects.equals(this.hasAsymmetricEncryption, metadataPassword.hasAsymmetricEncryption) &&
        Objects.equals(this.hasOpenPassword, metadataPassword.hasOpenPassword) &&
        Objects.equals(this.hasPermissionPassword, metadataPassword.hasPermissionPassword) &&
        Objects.equals(this.keyAlgorithm, metadataPassword.keyAlgorithm) &&
        Objects.equals(this.keyLength, metadataPassword.keyLength);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hasAsymmetricEncryption, hasOpenPassword, hasPermissionPassword, keyAlgorithm, keyLength);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataPassword {\n");
    sb.append("    hasAsymmetricEncryption: ").append(toIndentedString(hasAsymmetricEncryption)).append("\n");
    sb.append("    hasOpenPassword: ").append(toIndentedString(hasOpenPassword)).append("\n");
    sb.append("    hasPermissionPassword: ").append(toIndentedString(hasPermissionPassword)).append("\n");
    sb.append("    keyAlgorithm: ").append(toIndentedString(keyAlgorithm)).append("\n");
    sb.append("    keyLength: ").append(toIndentedString(keyLength)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
