/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * An element of this type defines a background for a page of the document.
 */
@Schema(description = "An element of this type defines a background for a page of the document.")
@JsonPropertyOrder({
  MetadataBackgroundContent.JSON_PROPERTY_BOUNDS,
  MetadataBackgroundContent.JSON_PROPERTY_IS_IMAGE,
  MetadataBackgroundContent.JSON_PROPERTY_OBJECT_KEY,
  MetadataBackgroundContent.JSON_PROPERTY_ONPRINT,
  MetadataBackgroundContent.JSON_PROPERTY_ONSCREEN,
  MetadataBackgroundContent.JSON_PROPERTY_PAGE,
  MetadataBackgroundContent.JSON_PROPERTY_PIECE_INFO
})
@JsonTypeName("Metadata_BackgroundContent")

public class MetadataBackgroundContent {
  public static final String JSON_PROPERTY_BOUNDS = "bounds";
  private MetadataRectangle bounds;

  public static final String JSON_PROPERTY_IS_IMAGE = "isImage";
  private Boolean isImage = false;

  public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
  private String objectKey = "";

  public static final String JSON_PROPERTY_ONPRINT = "onprint";
  private Boolean onprint = true;

  public static final String JSON_PROPERTY_ONSCREEN = "onscreen";
  private Boolean onscreen = true;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page = 0;

  public static final String JSON_PROPERTY_PIECE_INFO = "pieceInfo";
  private MetadataPieceInfoBackgroundContent pieceInfo;

  public MetadataBackgroundContent() {
  }

  public MetadataBackgroundContent bounds(MetadataRectangle bounds) {
    
    this.bounds = bounds;
    return this;
  }

  /**
   * Get bounds
   * @return bounds
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_BOUNDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MetadataRectangle getBounds() {
    return bounds;
  }


  @JsonProperty(JSON_PROPERTY_BOUNDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBounds(MetadataRectangle bounds) {
    this.bounds = bounds;
  }


  public MetadataBackgroundContent isImage(Boolean isImage) {
    
    this.isImage = isImage;
    return this;
  }

  /**
   * When set to true, the background is using an image resource. (Otherwise it is unicolor)
   * @return isImage
   **/
  @Nullable
  @Schema(name = "When set to true, the background is using an image resource. (Otherwise it is unicolor)")
  @JsonProperty(JSON_PROPERTY_IS_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsImage() {
    return isImage;
  }


  @JsonProperty(JSON_PROPERTY_IS_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsImage(Boolean isImage) {
    this.isImage = isImage;
  }


  public MetadataBackgroundContent objectKey(String objectKey) {
    
    this.objectKey = objectKey;
    return this;
  }

  /**
   * The object ID of the background. **Info:** A PDF object ID consists of two numbers, where the first number selects the object&#39;s number and the second the \&quot;generation\&quot; of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.
   * @return objectKey
   **/
  @Nullable
  @Schema(name = "The object ID of the background. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObjectKey() {
    return objectKey;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObjectKey(String objectKey) {
    this.objectKey = objectKey;
  }


  public MetadataBackgroundContent onprint(Boolean onprint) {
    
    this.onprint = onprint;
    return this;
  }

  /**
   * Whether the background shall be visible in printouts of the document.
   * @return onprint
   **/
  @Nullable
  @Schema(name = "Whether the background shall be visible in printouts of the document.")
  @JsonProperty(JSON_PROPERTY_ONPRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getOnprint() {
    return onprint;
  }


  @JsonProperty(JSON_PROPERTY_ONPRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOnprint(Boolean onprint) {
    this.onprint = onprint;
  }


  public MetadataBackgroundContent onscreen(Boolean onscreen) {
    
    this.onscreen = onscreen;
    return this;
  }

  /**
   * Whether the background shall be visible in Readers.
   * @return onscreen
   **/
  @Nullable
  @Schema(name = "Whether the background shall be visible in Readers.")
  @JsonProperty(JSON_PROPERTY_ONSCREEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getOnscreen() {
    return onscreen;
  }


  @JsonProperty(JSON_PROPERTY_ONSCREEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOnscreen(Boolean onscreen) {
    this.onscreen = onscreen;
  }


  public MetadataBackgroundContent page(Integer page) {
    
    this.page = page;
    return this;
  }

  /**
   * The page the background shall be set for.
   * minimum: 0
   * @return page
   **/
  @Nullable
  @Schema(name = "The page the background shall be set for.")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public MetadataBackgroundContent pieceInfo(MetadataPieceInfoBackgroundContent pieceInfo) {
    
    this.pieceInfo = pieceInfo;
    return this;
  }

  /**
   * Get pieceInfo
   * @return pieceInfo
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PIECE_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataPieceInfoBackgroundContent getPieceInfo() {
    return pieceInfo;
  }


  @JsonProperty(JSON_PROPERTY_PIECE_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPieceInfo(MetadataPieceInfoBackgroundContent pieceInfo) {
    this.pieceInfo = pieceInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataBackgroundContent metadataBackgroundContent = (MetadataBackgroundContent) o;
    return Objects.equals(this.bounds, metadataBackgroundContent.bounds) &&
        Objects.equals(this.isImage, metadataBackgroundContent.isImage) &&
        Objects.equals(this.objectKey, metadataBackgroundContent.objectKey) &&
        Objects.equals(this.onprint, metadataBackgroundContent.onprint) &&
        Objects.equals(this.onscreen, metadataBackgroundContent.onscreen) &&
        Objects.equals(this.page, metadataBackgroundContent.page) &&
        Objects.equals(this.pieceInfo, metadataBackgroundContent.pieceInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bounds, isImage, objectKey, onprint, onscreen, page, pieceInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataBackgroundContent {\n");
    sb.append("    bounds: ").append(toIndentedString(bounds)).append("\n");
    sb.append("    isImage: ").append(toIndentedString(isImage)).append("\n");
    sb.append("    objectKey: ").append(toIndentedString(objectKey)).append("\n");
    sb.append("    onprint: ").append(toIndentedString(onprint)).append("\n");
    sb.append("    onscreen: ").append(toIndentedString(onscreen)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    pieceInfo: ").append(toIndentedString(pieceInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
