/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * General information about the cluster status and detailed information about each node.
 */
@Schema(description = "General information about the cluster status and detailed information about each node.")
@JsonPropertyOrder({
  ClusterStatus.JSON_PROPERTY_ERROR,
  ClusterStatus.JSON_PROPERTY_ID,
  ClusterStatus.JSON_PROPERTY_IS_DEMO_MODE,
  ClusterStatus.JSON_PROPERTY_LOCAL_ADDRESS,
  ClusterStatus.JSON_PROPERTY_MAXIMUM_ALLOWED_NODES,
  ClusterStatus.JSON_PROPERTY_NAMESPACE,
  ClusterStatus.JSON_PROPERTY_NODES,
  ClusterStatus.JSON_PROPERTY_SETTINGS
})
@JsonTypeName("Cluster_Status")

public class ClusterStatus {
  public static final String JSON_PROPERTY_ERROR = "error";
  private WebserviceResult error;

  public static final String JSON_PROPERTY_ID = "id";
  private String id = "";

  public static final String JSON_PROPERTY_IS_DEMO_MODE = "isDemoMode";
  private Boolean isDemoMode = false;

  public static final String JSON_PROPERTY_LOCAL_ADDRESS = "localAddress";
  private String localAddress = "";

  public static final String JSON_PROPERTY_MAXIMUM_ALLOWED_NODES = "maximumAllowedNodes";
  private Integer maximumAllowedNodes = 0;

  public static final String JSON_PROPERTY_NAMESPACE = "namespace";
  private String namespace = "";

  public static final String JSON_PROPERTY_NODES = "nodes";
  private List<ClusterNodeStatus> nodes = null;

  public static final String JSON_PROPERTY_SETTINGS = "settings";
  private ClusterSettings settings;

  public ClusterStatus() {
  }

  public ClusterStatus error(WebserviceResult error) {
    
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WebserviceResult getError() {
    return error;
  }


  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setError(WebserviceResult error) {
    this.error = error;
  }


  public ClusterStatus id(String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public ClusterStatus isDemoMode(Boolean isDemoMode) {
    
    this.isDemoMode = isDemoMode;
    return this;
  }

  /**
   * Get isDemoMode
   * @return isDemoMode
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_IS_DEMO_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsDemoMode() {
    return isDemoMode;
  }


  @JsonProperty(JSON_PROPERTY_IS_DEMO_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsDemoMode(Boolean isDemoMode) {
    this.isDemoMode = isDemoMode;
  }


  public ClusterStatus localAddress(String localAddress) {
    
    this.localAddress = localAddress;
    return this;
  }

  /**
   * Get localAddress
   * @return localAddress
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_LOCAL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalAddress() {
    return localAddress;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalAddress(String localAddress) {
    this.localAddress = localAddress;
  }


  public ClusterStatus maximumAllowedNodes(Integer maximumAllowedNodes) {
    
    this.maximumAllowedNodes = maximumAllowedNodes;
    return this;
  }

  /**
   * Get maximumAllowedNodes
   * @return maximumAllowedNodes
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_MAXIMUM_ALLOWED_NODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaximumAllowedNodes() {
    return maximumAllowedNodes;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_ALLOWED_NODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaximumAllowedNodes(Integer maximumAllowedNodes) {
    this.maximumAllowedNodes = maximumAllowedNodes;
  }


  public ClusterStatus namespace(String namespace) {
    
    this.namespace = namespace;
    return this;
  }

  /**
   * Get namespace
   * @return namespace
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_NAMESPACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNamespace() {
    return namespace;
  }


  @JsonProperty(JSON_PROPERTY_NAMESPACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }


  public ClusterStatus nodes(List<ClusterNodeStatus> nodes) {
    
    this.nodes = nodes;
    return this;
  }

  public ClusterStatus addNodesItem(ClusterNodeStatus nodesItem) {
    if (this.nodes == null) {
        this.nodes = new ArrayList<>();
    }
    this.nodes.add(nodesItem);
    return this;
  }

  /**
   * Get nodes
   * @return nodes
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_NODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ClusterNodeStatus> getNodes() {
    return nodes;
  }


  @JsonProperty(JSON_PROPERTY_NODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNodes(List<ClusterNodeStatus> nodes) {
    this.nodes = nodes;
  }


  public ClusterStatus settings(ClusterSettings settings) {
    
    this.settings = settings;
    return this;
  }

  /**
   * Get settings
   * @return settings
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ClusterSettings getSettings() {
    return settings;
  }


  @JsonProperty(JSON_PROPERTY_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSettings(ClusterSettings settings) {
    this.settings = settings;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClusterStatus clusterStatus = (ClusterStatus) o;
    return Objects.equals(this.error, clusterStatus.error) &&
        Objects.equals(this.id, clusterStatus.id) &&
        Objects.equals(this.isDemoMode, clusterStatus.isDemoMode) &&
        Objects.equals(this.localAddress, clusterStatus.localAddress) &&
        Objects.equals(this.maximumAllowedNodes, clusterStatus.maximumAllowedNodes) &&
        Objects.equals(this.namespace, clusterStatus.namespace) &&
        Objects.equals(this.nodes, clusterStatus.nodes) &&
        Objects.equals(this.settings, clusterStatus.settings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(error, id, isDemoMode, localAddress, maximumAllowedNodes, namespace, nodes, settings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClusterStatus {\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    isDemoMode: ").append(toIndentedString(isDemoMode)).append("\n");
    sb.append("    localAddress: ").append(toIndentedString(localAddress)).append("\n");
    sb.append("    maximumAllowedNodes: ").append(toIndentedString(maximumAllowedNodes)).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    nodes: ").append(toIndentedString(nodes)).append("\n");
    sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
