/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines a proxy server that shall be known to and used by the server to access external resources.
 */
@Schema(description = "Defines a proxy server that shall be known to and used by the server to access external resources.")
@JsonPropertyOrder({
  ApplicationConfigProxy.JSON_PROPERTY_HOST,
  ApplicationConfigProxy.JSON_PROPERTY_NON_PROXY_HOST,
  ApplicationConfigProxy.JSON_PROPERTY_PASSWORD,
  ApplicationConfigProxy.JSON_PROPERTY_PORT,
  ApplicationConfigProxy.JSON_PROPERTY_SCHEME,
  ApplicationConfigProxy.JSON_PROPERTY_USER_NAME
})
@JsonTypeName("ApplicationConfig_Proxy")

public class ApplicationConfigProxy {
  public static final String JSON_PROPERTY_HOST = "host";
  private String host = "";

  public static final String JSON_PROPERTY_NON_PROXY_HOST = "nonProxyHost";
  private List<ApplicationConfigProxyNonHost> nonProxyHost = null;

  public static final String JSON_PROPERTY_PASSWORD = "password";
  private String password = "";

  public static final String JSON_PROPERTY_PORT = "port";
  private Integer port = 8080;

  public static final String JSON_PROPERTY_SCHEME = "scheme";
  private String scheme = "http";

  public static final String JSON_PROPERTY_USER_NAME = "userName";
  private String userName = "";

  public ApplicationConfigProxy() {
  }

  public ApplicationConfigProxy host(String host) {
    
    this.host = host;
    return this;
  }

  /**
   * The address of the proxy server.
   * @return host
   **/
  @Nullable
  @Schema(name = "The address of the proxy server.")
  @JsonProperty(JSON_PROPERTY_HOST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHost() {
    return host;
  }


  @JsonProperty(JSON_PROPERTY_HOST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHost(String host) {
    this.host = host;
  }


  public ApplicationConfigProxy nonProxyHost(List<ApplicationConfigProxyNonHost> nonProxyHost) {
    
    this.nonProxyHost = nonProxyHost;
    return this;
  }

  public ApplicationConfigProxy addNonProxyHostItem(ApplicationConfigProxyNonHost nonProxyHostItem) {
    if (this.nonProxyHost == null) {
        this.nonProxyHost = new ArrayList<>();
    }
    this.nonProxyHost.add(nonProxyHostItem);
    return this;
  }

  /**
   * Get nonProxyHost
   * @return nonProxyHost
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_NON_PROXY_HOST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApplicationConfigProxyNonHost> getNonProxyHost() {
    return nonProxyHost;
  }


  @JsonProperty(JSON_PROPERTY_NON_PROXY_HOST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonProxyHost(List<ApplicationConfigProxyNonHost> nonProxyHost) {
    this.nonProxyHost = nonProxyHost;
  }


  public ApplicationConfigProxy password(String password) {
    
    this.password = password;
    return this;
  }

  /**
   * The password of the user required to authenticate with the proxy server.
   * @return password
   **/
  @Nullable
  @Schema(name = "The password of the user required to authenticate with the proxy server.")
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPassword() {
    return password;
  }


  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassword(String password) {
    this.password = password;
  }


  public ApplicationConfigProxy port(Integer port) {
    
    this.port = port;
    return this;
  }

  /**
   * The port on which the proxy listens.
   * minimum: 0
   * @return port
   **/
  @Nullable
  @Schema(name = "The port on which the proxy listens.")
  @JsonProperty(JSON_PROPERTY_PORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPort() {
    return port;
  }


  @JsonProperty(JSON_PROPERTY_PORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPort(Integer port) {
    this.port = port;
  }


  public ApplicationConfigProxy scheme(String scheme) {
    
    this.scheme = scheme;
    return this;
  }

  /**
   * The scheme to access the proxy server (currently only \&quot;http\&quot; or \&quot;https\&quot; are allowed).
   * @return scheme
   **/
  @Nullable
  @Schema(name = "The scheme to access the proxy server (currently only \"http\" or \"https\" are allowed).")
  @JsonProperty(JSON_PROPERTY_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getScheme() {
    return scheme;
  }


  @JsonProperty(JSON_PROPERTY_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScheme(String scheme) {
    this.scheme = scheme;
  }


  public ApplicationConfigProxy userName(String userName) {
    
    this.userName = userName;
    return this;
  }

  /**
   * The name of the user required to authenticate with the proxy server.
   * @return userName
   **/
  @Nullable
  @Schema(name = "The name of the user required to authenticate with the proxy server.")
  @JsonProperty(JSON_PROPERTY_USER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserName() {
    return userName;
  }


  @JsonProperty(JSON_PROPERTY_USER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserName(String userName) {
    this.userName = userName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationConfigProxy applicationConfigProxy = (ApplicationConfigProxy) o;
    return Objects.equals(this.host, applicationConfigProxy.host) &&
        Objects.equals(this.nonProxyHost, applicationConfigProxy.nonProxyHost) &&
        Objects.equals(this.password, applicationConfigProxy.password) &&
        Objects.equals(this.port, applicationConfigProxy.port) &&
        Objects.equals(this.scheme, applicationConfigProxy.scheme) &&
        Objects.equals(this.userName, applicationConfigProxy.userName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(host, nonProxyHost, password, port, scheme, userName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationConfigProxy {\n");
    sb.append("    host: ").append(toIndentedString(host)).append("\n");
    sb.append("    nonProxyHost: ").append(toIndentedString(nonProxyHost)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    port: ").append(toIndentedString(port)).append("\n");
    sb.append("    scheme: ").append(toIndentedString(scheme)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
