/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines which portal functions are enabled or disabled.
 */
@Schema(description = "Defines which portal functions are enabled or disabled.")
@JsonPropertyOrder({
  ApplicationConfigPortalFunctions.JSON_PROPERTY_ADD_WATERMARK,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_CHANGE_DOCUMENT_SETTINGS,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_CHANGE_DOCUMENT_VIEW,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_COMPRESS,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_CONVERT_DOCUMENT,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_CREATE_BARCODE,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_DELETE_PAGES,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_DETECT_BARCODE,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_EDIT_ANNOTATION,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_EDIT_ATTACHMENT,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_EDIT_BACKGROUND,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_EDIT_BOXES,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_EDIT_FORMS,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_EDIT_HEADER_FOOTER,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_EDIT_TRANSITIONS,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_ENCRYPT_DOCUMENT,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_EXPORT_AS_IMAGE,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_EXTRACT_CONTENT,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_EXTRACT_PAGES,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_MERGE_DOCUMENT,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_MOVE_PAGES,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_OCR_CONVERSION,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_OUTLINE,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_PDFA_CONVERSION,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_PORTFOLIO,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_PRINT_DOCUMENT,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_REDACT,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_RENAME_DOCUMENT,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_ROTATE_PAGES,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_SANITIZE,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_SCALE_PAGES,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_SHOW_HELP,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_SIGN_DOCUMENT,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_SPLIT_DOCUMENT,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_TRANSCRIBE_DOCUMENT,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_UPLOAD_FILE,
  ApplicationConfigPortalFunctions.JSON_PROPERTY_UPLOAD_URL
})
@JsonTypeName("ApplicationConfig_PortalFunctions")

public class ApplicationConfigPortalFunctions {
  public static final String JSON_PROPERTY_ADD_WATERMARK = "addWatermark";
  private Boolean addWatermark = true;

  public static final String JSON_PROPERTY_CHANGE_DOCUMENT_SETTINGS = "changeDocumentSettings";
  private Boolean changeDocumentSettings = true;

  public static final String JSON_PROPERTY_CHANGE_DOCUMENT_VIEW = "changeDocumentView";
  private Boolean changeDocumentView = true;

  public static final String JSON_PROPERTY_COMPRESS = "compress";
  private Boolean compress = true;

  public static final String JSON_PROPERTY_CONVERT_DOCUMENT = "convertDocument";
  private Boolean convertDocument = true;

  public static final String JSON_PROPERTY_CREATE_BARCODE = "createBarcode";
  private Boolean createBarcode = true;

  public static final String JSON_PROPERTY_DELETE_PAGES = "deletePages";
  private Boolean deletePages = true;

  public static final String JSON_PROPERTY_DETECT_BARCODE = "detectBarcode";
  private Boolean detectBarcode = true;

  public static final String JSON_PROPERTY_EDIT_ANNOTATION = "editAnnotation";
  private Boolean editAnnotation = true;

  public static final String JSON_PROPERTY_EDIT_ATTACHMENT = "editAttachment";
  private Boolean editAttachment = true;

  public static final String JSON_PROPERTY_EDIT_BACKGROUND = "editBackground";
  private Boolean editBackground = true;

  public static final String JSON_PROPERTY_EDIT_BOXES = "editBoxes";
  private Boolean editBoxes = true;

  public static final String JSON_PROPERTY_EDIT_FORMS = "editForms";
  private Boolean editForms = true;

  public static final String JSON_PROPERTY_EDIT_HEADER_FOOTER = "editHeaderFooter";
  private Boolean editHeaderFooter = true;

  public static final String JSON_PROPERTY_EDIT_TRANSITIONS = "editTransitions";
  private Boolean editTransitions = true;

  public static final String JSON_PROPERTY_ENCRYPT_DOCUMENT = "encryptDocument";
  private Boolean encryptDocument = true;

  public static final String JSON_PROPERTY_EXPORT_AS_IMAGE = "exportAsImage";
  private Boolean exportAsImage = true;

  public static final String JSON_PROPERTY_EXTRACT_CONTENT = "extractContent";
  private Boolean extractContent = true;

  public static final String JSON_PROPERTY_EXTRACT_PAGES = "extractPages";
  private Boolean extractPages = true;

  public static final String JSON_PROPERTY_MERGE_DOCUMENT = "mergeDocument";
  private Boolean mergeDocument = true;

  public static final String JSON_PROPERTY_MOVE_PAGES = "movePages";
  private Boolean movePages = true;

  public static final String JSON_PROPERTY_OCR_CONVERSION = "ocrConversion";
  private Boolean ocrConversion = true;

  public static final String JSON_PROPERTY_OUTLINE = "outline";
  private Boolean outline = true;

  public static final String JSON_PROPERTY_PDFA_CONVERSION = "pdfaConversion";
  private Boolean pdfaConversion = true;

  public static final String JSON_PROPERTY_PORTFOLIO = "portfolio";
  private Boolean portfolio = true;

  public static final String JSON_PROPERTY_PRINT_DOCUMENT = "printDocument";
  private Boolean printDocument = true;

  public static final String JSON_PROPERTY_REDACT = "redact";
  private Boolean redact = true;

  public static final String JSON_PROPERTY_RENAME_DOCUMENT = "renameDocument";
  private Boolean renameDocument = true;

  public static final String JSON_PROPERTY_ROTATE_PAGES = "rotatePages";
  private Boolean rotatePages = true;

  public static final String JSON_PROPERTY_SANITIZE = "sanitize";
  private Boolean sanitize = true;

  public static final String JSON_PROPERTY_SCALE_PAGES = "scalePages";
  private Boolean scalePages = true;

  public static final String JSON_PROPERTY_SHOW_HELP = "showHelp";
  private Boolean showHelp = true;

  public static final String JSON_PROPERTY_SIGN_DOCUMENT = "signDocument";
  private Boolean signDocument = true;

  public static final String JSON_PROPERTY_SPLIT_DOCUMENT = "splitDocument";
  private Boolean splitDocument = true;

  public static final String JSON_PROPERTY_TRANSCRIBE_DOCUMENT = "transcribeDocument";
  private Boolean transcribeDocument = true;

  public static final String JSON_PROPERTY_UPLOAD_FILE = "uploadFile";
  private Boolean uploadFile = true;

  public static final String JSON_PROPERTY_UPLOAD_URL = "uploadUrl";
  private Boolean uploadUrl = true;

  public ApplicationConfigPortalFunctions() {
  }

  public ApplicationConfigPortalFunctions addWatermark(Boolean addWatermark) {
    
    this.addWatermark = addWatermark;
    return this;
  }

  /**
   * If disabled, then the \&quot;add watermark\&quot; dialog is deactivated.
   * @return addWatermark
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"add watermark\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_ADD_WATERMARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAddWatermark() {
    return addWatermark;
  }


  @JsonProperty(JSON_PROPERTY_ADD_WATERMARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddWatermark(Boolean addWatermark) {
    this.addWatermark = addWatermark;
  }


  public ApplicationConfigPortalFunctions changeDocumentSettings(Boolean changeDocumentSettings) {
    
    this.changeDocumentSettings = changeDocumentSettings;
    return this;
  }

  /**
   * If disabled, then the \&quot;change document settings\&quot; dialog is deactivated.
   * @return changeDocumentSettings
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"change document settings\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_CHANGE_DOCUMENT_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getChangeDocumentSettings() {
    return changeDocumentSettings;
  }


  @JsonProperty(JSON_PROPERTY_CHANGE_DOCUMENT_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangeDocumentSettings(Boolean changeDocumentSettings) {
    this.changeDocumentSettings = changeDocumentSettings;
  }


  public ApplicationConfigPortalFunctions changeDocumentView(Boolean changeDocumentView) {
    
    this.changeDocumentView = changeDocumentView;
    return this;
  }

  /**
   * If disabled, the \&quot;change document view\&quot; dialog is deactivated.
   * @return changeDocumentView
   **/
  @Nullable
  @Schema(name = "If disabled, the \"change document view\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_CHANGE_DOCUMENT_VIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getChangeDocumentView() {
    return changeDocumentView;
  }


  @JsonProperty(JSON_PROPERTY_CHANGE_DOCUMENT_VIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangeDocumentView(Boolean changeDocumentView) {
    this.changeDocumentView = changeDocumentView;
  }


  public ApplicationConfigPortalFunctions compress(Boolean compress) {
    
    this.compress = compress;
    return this;
  }

  /**
   * If disabled, then the \&quot;compress\&quot; dialog is deactivated.
   * @return compress
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"compress\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_COMPRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCompress() {
    return compress;
  }


  @JsonProperty(JSON_PROPERTY_COMPRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompress(Boolean compress) {
    this.compress = compress;
  }


  public ApplicationConfigPortalFunctions convertDocument(Boolean convertDocument) {
    
    this.convertDocument = convertDocument;
    return this;
  }

  /**
   * If deactivated, then the \&quot;convert document\&quot; dialog is deactivated.
   * @return convertDocument
   **/
  @Nullable
  @Schema(name = "If deactivated, then the \"convert document\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_CONVERT_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getConvertDocument() {
    return convertDocument;
  }


  @JsonProperty(JSON_PROPERTY_CONVERT_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConvertDocument(Boolean convertDocument) {
    this.convertDocument = convertDocument;
  }


  public ApplicationConfigPortalFunctions createBarcode(Boolean createBarcode) {
    
    this.createBarcode = createBarcode;
    return this;
  }

  /**
   * If disabled, then the \&quot;create Barcode\&quot; dialog is deactivated.
   * @return createBarcode
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"create Barcode\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_CREATE_BARCODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCreateBarcode() {
    return createBarcode;
  }


  @JsonProperty(JSON_PROPERTY_CREATE_BARCODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreateBarcode(Boolean createBarcode) {
    this.createBarcode = createBarcode;
  }


  public ApplicationConfigPortalFunctions deletePages(Boolean deletePages) {
    
    this.deletePages = deletePages;
    return this;
  }

  /**
   * If disabled, then the \&quot;delete pages\&quot; dialog is deactivated.
   * @return deletePages
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"delete pages\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_DELETE_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeletePages() {
    return deletePages;
  }


  @JsonProperty(JSON_PROPERTY_DELETE_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeletePages(Boolean deletePages) {
    this.deletePages = deletePages;
  }


  public ApplicationConfigPortalFunctions detectBarcode(Boolean detectBarcode) {
    
    this.detectBarcode = detectBarcode;
    return this;
  }

  /**
   * If disabled, then the \&quot;detect Barcode\&quot; dialog is deactivated.
   * @return detectBarcode
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"detect Barcode\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_DETECT_BARCODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDetectBarcode() {
    return detectBarcode;
  }


  @JsonProperty(JSON_PROPERTY_DETECT_BARCODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDetectBarcode(Boolean detectBarcode) {
    this.detectBarcode = detectBarcode;
  }


  public ApplicationConfigPortalFunctions editAnnotation(Boolean editAnnotation) {
    
    this.editAnnotation = editAnnotation;
    return this;
  }

  /**
   * If disabled, then the \&quot;edit annotation\&quot; dialog is deactivated.
   * @return editAnnotation
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"edit annotation\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_EDIT_ANNOTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEditAnnotation() {
    return editAnnotation;
  }


  @JsonProperty(JSON_PROPERTY_EDIT_ANNOTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditAnnotation(Boolean editAnnotation) {
    this.editAnnotation = editAnnotation;
  }


  public ApplicationConfigPortalFunctions editAttachment(Boolean editAttachment) {
    
    this.editAttachment = editAttachment;
    return this;
  }

  /**
   * If disabled, then the \&quot;edit attachment\&quot; dialog is deactivated.
   * @return editAttachment
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"edit attachment\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_EDIT_ATTACHMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEditAttachment() {
    return editAttachment;
  }


  @JsonProperty(JSON_PROPERTY_EDIT_ATTACHMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditAttachment(Boolean editAttachment) {
    this.editAttachment = editAttachment;
  }


  public ApplicationConfigPortalFunctions editBackground(Boolean editBackground) {
    
    this.editBackground = editBackground;
    return this;
  }

  /**
   * If disabled, then the \&quot;edit background\&quot; dialog is deactivated.
   * @return editBackground
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"edit background\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_EDIT_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEditBackground() {
    return editBackground;
  }


  @JsonProperty(JSON_PROPERTY_EDIT_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditBackground(Boolean editBackground) {
    this.editBackground = editBackground;
  }


  public ApplicationConfigPortalFunctions editBoxes(Boolean editBoxes) {
    
    this.editBoxes = editBoxes;
    return this;
  }

  /**
   * If disabled, then the \&quot;edit boxes\&quot; dialog is deactivated.
   * @return editBoxes
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"edit boxes\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_EDIT_BOXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEditBoxes() {
    return editBoxes;
  }


  @JsonProperty(JSON_PROPERTY_EDIT_BOXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditBoxes(Boolean editBoxes) {
    this.editBoxes = editBoxes;
  }


  public ApplicationConfigPortalFunctions editForms(Boolean editForms) {
    
    this.editForms = editForms;
    return this;
  }

  /**
   * If disabled, then the \&quot;edit forms\&quot; dialog is deactivated.
   * @return editForms
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"edit forms\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_EDIT_FORMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEditForms() {
    return editForms;
  }


  @JsonProperty(JSON_PROPERTY_EDIT_FORMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditForms(Boolean editForms) {
    this.editForms = editForms;
  }


  public ApplicationConfigPortalFunctions editHeaderFooter(Boolean editHeaderFooter) {
    
    this.editHeaderFooter = editHeaderFooter;
    return this;
  }

  /**
   * If disabled, then the \&quot;edit header/footer\&quot; dialog is deactivated.
   * @return editHeaderFooter
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"edit header/footer\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_EDIT_HEADER_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEditHeaderFooter() {
    return editHeaderFooter;
  }


  @JsonProperty(JSON_PROPERTY_EDIT_HEADER_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditHeaderFooter(Boolean editHeaderFooter) {
    this.editHeaderFooter = editHeaderFooter;
  }


  public ApplicationConfigPortalFunctions editTransitions(Boolean editTransitions) {
    
    this.editTransitions = editTransitions;
    return this;
  }

  /**
   * If disabled, then the \&quot;edit transitions\&quot; dialog is deactivated.
   * @return editTransitions
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"edit transitions\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_EDIT_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEditTransitions() {
    return editTransitions;
  }


  @JsonProperty(JSON_PROPERTY_EDIT_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditTransitions(Boolean editTransitions) {
    this.editTransitions = editTransitions;
  }


  public ApplicationConfigPortalFunctions encryptDocument(Boolean encryptDocument) {
    
    this.encryptDocument = encryptDocument;
    return this;
  }

  /**
   * If disabled, then the \&quot;encrypt document\&quot; dialog is deactivated.
   * @return encryptDocument
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"encrypt document\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_ENCRYPT_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEncryptDocument() {
    return encryptDocument;
  }


  @JsonProperty(JSON_PROPERTY_ENCRYPT_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncryptDocument(Boolean encryptDocument) {
    this.encryptDocument = encryptDocument;
  }


  public ApplicationConfigPortalFunctions exportAsImage(Boolean exportAsImage) {
    
    this.exportAsImage = exportAsImage;
    return this;
  }

  /**
   * If disabled, then the \&quot;export as image\&quot; dialog is deactivated.
   * @return exportAsImage
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"export as image\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_EXPORT_AS_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getExportAsImage() {
    return exportAsImage;
  }


  @JsonProperty(JSON_PROPERTY_EXPORT_AS_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExportAsImage(Boolean exportAsImage) {
    this.exportAsImage = exportAsImage;
  }


  public ApplicationConfigPortalFunctions extractContent(Boolean extractContent) {
    
    this.extractContent = extractContent;
    return this;
  }

  /**
   * If disabled, then the \&quot;extract content\&quot; dialog is deactivated.
   * @return extractContent
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"extract content\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_EXTRACT_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getExtractContent() {
    return extractContent;
  }


  @JsonProperty(JSON_PROPERTY_EXTRACT_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtractContent(Boolean extractContent) {
    this.extractContent = extractContent;
  }


  public ApplicationConfigPortalFunctions extractPages(Boolean extractPages) {
    
    this.extractPages = extractPages;
    return this;
  }

  /**
   * If disabled, then the \&quot;extract pages\&quot; dialog is deactivated.
   * @return extractPages
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"extract pages\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_EXTRACT_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getExtractPages() {
    return extractPages;
  }


  @JsonProperty(JSON_PROPERTY_EXTRACT_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtractPages(Boolean extractPages) {
    this.extractPages = extractPages;
  }


  public ApplicationConfigPortalFunctions mergeDocument(Boolean mergeDocument) {
    
    this.mergeDocument = mergeDocument;
    return this;
  }

  /**
   * If disabled, then the \&quot;merge document\&quot; dialog is deactivated.
   * @return mergeDocument
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"merge document\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_MERGE_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMergeDocument() {
    return mergeDocument;
  }


  @JsonProperty(JSON_PROPERTY_MERGE_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMergeDocument(Boolean mergeDocument) {
    this.mergeDocument = mergeDocument;
  }


  public ApplicationConfigPortalFunctions movePages(Boolean movePages) {
    
    this.movePages = movePages;
    return this;
  }

  /**
   * If disabled, then the \&quot;move pages\&quot; dialog is deactivated.
   * @return movePages
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"move pages\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_MOVE_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMovePages() {
    return movePages;
  }


  @JsonProperty(JSON_PROPERTY_MOVE_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMovePages(Boolean movePages) {
    this.movePages = movePages;
  }


  public ApplicationConfigPortalFunctions ocrConversion(Boolean ocrConversion) {
    
    this.ocrConversion = ocrConversion;
    return this;
  }

  /**
   * If disabled, then the \&quot;OCR conversion\&quot; dialog is deactivated.
   * @return ocrConversion
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"OCR conversion\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_OCR_CONVERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getOcrConversion() {
    return ocrConversion;
  }


  @JsonProperty(JSON_PROPERTY_OCR_CONVERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOcrConversion(Boolean ocrConversion) {
    this.ocrConversion = ocrConversion;
  }


  public ApplicationConfigPortalFunctions outline(Boolean outline) {
    
    this.outline = outline;
    return this;
  }

  /**
   * If disabled, then the \&quot;edit outline\&quot; dialog is deactivated.
   * @return outline
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"edit outline\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_OUTLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getOutline() {
    return outline;
  }


  @JsonProperty(JSON_PROPERTY_OUTLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOutline(Boolean outline) {
    this.outline = outline;
  }


  public ApplicationConfigPortalFunctions pdfaConversion(Boolean pdfaConversion) {
    
    this.pdfaConversion = pdfaConversion;
    return this;
  }

  /**
   * If disabled, then the \&quot;PDF/A conversion\&quot; dialog is deactivated.
   * @return pdfaConversion
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"PDF/A conversion\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_PDFA_CONVERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPdfaConversion() {
    return pdfaConversion;
  }


  @JsonProperty(JSON_PROPERTY_PDFA_CONVERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPdfaConversion(Boolean pdfaConversion) {
    this.pdfaConversion = pdfaConversion;
  }


  public ApplicationConfigPortalFunctions portfolio(Boolean portfolio) {
    
    this.portfolio = portfolio;
    return this;
  }

  /**
   * If disabled, then the \&quot;portfolio\&quot; dialog is deactivated.
   * @return portfolio
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"portfolio\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_PORTFOLIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPortfolio() {
    return portfolio;
  }


  @JsonProperty(JSON_PROPERTY_PORTFOLIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPortfolio(Boolean portfolio) {
    this.portfolio = portfolio;
  }


  public ApplicationConfigPortalFunctions printDocument(Boolean printDocument) {
    
    this.printDocument = printDocument;
    return this;
  }

  /**
   * If disabled, then the \&quot;print document\&quot; dialog is deactivated.
   * @return printDocument
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"print document\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_PRINT_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPrintDocument() {
    return printDocument;
  }


  @JsonProperty(JSON_PROPERTY_PRINT_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintDocument(Boolean printDocument) {
    this.printDocument = printDocument;
  }


  public ApplicationConfigPortalFunctions redact(Boolean redact) {
    
    this.redact = redact;
    return this;
  }

  /**
   * If disabled, then the \&quot;redact\&quot; dialog is deactivated.
   * @return redact
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"redact\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_REDACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRedact() {
    return redact;
  }


  @JsonProperty(JSON_PROPERTY_REDACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedact(Boolean redact) {
    this.redact = redact;
  }


  public ApplicationConfigPortalFunctions renameDocument(Boolean renameDocument) {
    
    this.renameDocument = renameDocument;
    return this;
  }

  /**
   * If disabled, then the \&quot;rename document\&quot; dialog is deactivated.
   * @return renameDocument
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"rename document\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_RENAME_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRenameDocument() {
    return renameDocument;
  }


  @JsonProperty(JSON_PROPERTY_RENAME_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRenameDocument(Boolean renameDocument) {
    this.renameDocument = renameDocument;
  }


  public ApplicationConfigPortalFunctions rotatePages(Boolean rotatePages) {
    
    this.rotatePages = rotatePages;
    return this;
  }

  /**
   * If disabled, then the \&quot;rotate pages\&quot; dialog is deactivated.
   * @return rotatePages
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"rotate pages\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_ROTATE_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRotatePages() {
    return rotatePages;
  }


  @JsonProperty(JSON_PROPERTY_ROTATE_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotatePages(Boolean rotatePages) {
    this.rotatePages = rotatePages;
  }


  public ApplicationConfigPortalFunctions sanitize(Boolean sanitize) {
    
    this.sanitize = sanitize;
    return this;
  }

  /**
   * If disabled, then the \&quot;sanitize\&quot; dialog is deactivated.
   * @return sanitize
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"sanitize\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_SANITIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSanitize() {
    return sanitize;
  }


  @JsonProperty(JSON_PROPERTY_SANITIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSanitize(Boolean sanitize) {
    this.sanitize = sanitize;
  }


  public ApplicationConfigPortalFunctions scalePages(Boolean scalePages) {
    
    this.scalePages = scalePages;
    return this;
  }

  /**
   * If disabled, then the \&quot;scale pages\&quot; dialog is deactivated.
   * @return scalePages
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"scale pages\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_SCALE_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getScalePages() {
    return scalePages;
  }


  @JsonProperty(JSON_PROPERTY_SCALE_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScalePages(Boolean scalePages) {
    this.scalePages = scalePages;
  }


  public ApplicationConfigPortalFunctions showHelp(Boolean showHelp) {
    
    this.showHelp = showHelp;
    return this;
  }

  /**
   * When set to true the portal page shall display help and info messages.
   * @return showHelp
   **/
  @Nullable
  @Schema(name = "When set to true the portal page shall display help and info messages.")
  @JsonProperty(JSON_PROPERTY_SHOW_HELP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowHelp() {
    return showHelp;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_HELP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowHelp(Boolean showHelp) {
    this.showHelp = showHelp;
  }


  public ApplicationConfigPortalFunctions signDocument(Boolean signDocument) {
    
    this.signDocument = signDocument;
    return this;
  }

  /**
   * If disabled, then the \&quot;sign document\&quot; dialog is deactivated.
   * @return signDocument
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"sign document\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_SIGN_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSignDocument() {
    return signDocument;
  }


  @JsonProperty(JSON_PROPERTY_SIGN_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignDocument(Boolean signDocument) {
    this.signDocument = signDocument;
  }


  public ApplicationConfigPortalFunctions splitDocument(Boolean splitDocument) {
    
    this.splitDocument = splitDocument;
    return this;
  }

  /**
   * If disabled, then the \&quot;split document\&quot; dialog is deactivated.
   * @return splitDocument
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"split document\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_SPLIT_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSplitDocument() {
    return splitDocument;
  }


  @JsonProperty(JSON_PROPERTY_SPLIT_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplitDocument(Boolean splitDocument) {
    this.splitDocument = splitDocument;
  }


  public ApplicationConfigPortalFunctions transcribeDocument(Boolean transcribeDocument) {
    
    this.transcribeDocument = transcribeDocument;
    return this;
  }

  /**
   * If disabled, then the \&quot;transcribe document\&quot; dialog is deactivated.
   * @return transcribeDocument
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"transcribe document\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_TRANSCRIBE_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTranscribeDocument() {
    return transcribeDocument;
  }


  @JsonProperty(JSON_PROPERTY_TRANSCRIBE_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTranscribeDocument(Boolean transcribeDocument) {
    this.transcribeDocument = transcribeDocument;
  }


  public ApplicationConfigPortalFunctions uploadFile(Boolean uploadFile) {
    
    this.uploadFile = uploadFile;
    return this;
  }

  /**
   * If disabled, then the \&quot;upload file\&quot; dialog is deactivated.
   * @return uploadFile
   **/
  @Nullable
  @Schema(name = "If disabled, then the \"upload file\" dialog is deactivated.")
  @JsonProperty(JSON_PROPERTY_UPLOAD_FILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUploadFile() {
    return uploadFile;
  }


  @JsonProperty(JSON_PROPERTY_UPLOAD_FILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUploadFile(Boolean uploadFile) {
    this.uploadFile = uploadFile;
  }


  public ApplicationConfigPortalFunctions uploadUrl(Boolean uploadUrl) {
    
    this.uploadUrl = uploadUrl;
    return this;
  }

  /**
   * If disabled, then the URL to PDF conversion is deactivated.
   * @return uploadUrl
   **/
  @Nullable
  @Schema(name = "If disabled, then the URL to PDF conversion is deactivated.")
  @JsonProperty(JSON_PROPERTY_UPLOAD_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUploadUrl() {
    return uploadUrl;
  }


  @JsonProperty(JSON_PROPERTY_UPLOAD_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUploadUrl(Boolean uploadUrl) {
    this.uploadUrl = uploadUrl;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationConfigPortalFunctions applicationConfigPortalFunctions = (ApplicationConfigPortalFunctions) o;
    return Objects.equals(this.addWatermark, applicationConfigPortalFunctions.addWatermark) &&
        Objects.equals(this.changeDocumentSettings, applicationConfigPortalFunctions.changeDocumentSettings) &&
        Objects.equals(this.changeDocumentView, applicationConfigPortalFunctions.changeDocumentView) &&
        Objects.equals(this.compress, applicationConfigPortalFunctions.compress) &&
        Objects.equals(this.convertDocument, applicationConfigPortalFunctions.convertDocument) &&
        Objects.equals(this.createBarcode, applicationConfigPortalFunctions.createBarcode) &&
        Objects.equals(this.deletePages, applicationConfigPortalFunctions.deletePages) &&
        Objects.equals(this.detectBarcode, applicationConfigPortalFunctions.detectBarcode) &&
        Objects.equals(this.editAnnotation, applicationConfigPortalFunctions.editAnnotation) &&
        Objects.equals(this.editAttachment, applicationConfigPortalFunctions.editAttachment) &&
        Objects.equals(this.editBackground, applicationConfigPortalFunctions.editBackground) &&
        Objects.equals(this.editBoxes, applicationConfigPortalFunctions.editBoxes) &&
        Objects.equals(this.editForms, applicationConfigPortalFunctions.editForms) &&
        Objects.equals(this.editHeaderFooter, applicationConfigPortalFunctions.editHeaderFooter) &&
        Objects.equals(this.editTransitions, applicationConfigPortalFunctions.editTransitions) &&
        Objects.equals(this.encryptDocument, applicationConfigPortalFunctions.encryptDocument) &&
        Objects.equals(this.exportAsImage, applicationConfigPortalFunctions.exportAsImage) &&
        Objects.equals(this.extractContent, applicationConfigPortalFunctions.extractContent) &&
        Objects.equals(this.extractPages, applicationConfigPortalFunctions.extractPages) &&
        Objects.equals(this.mergeDocument, applicationConfigPortalFunctions.mergeDocument) &&
        Objects.equals(this.movePages, applicationConfigPortalFunctions.movePages) &&
        Objects.equals(this.ocrConversion, applicationConfigPortalFunctions.ocrConversion) &&
        Objects.equals(this.outline, applicationConfigPortalFunctions.outline) &&
        Objects.equals(this.pdfaConversion, applicationConfigPortalFunctions.pdfaConversion) &&
        Objects.equals(this.portfolio, applicationConfigPortalFunctions.portfolio) &&
        Objects.equals(this.printDocument, applicationConfigPortalFunctions.printDocument) &&
        Objects.equals(this.redact, applicationConfigPortalFunctions.redact) &&
        Objects.equals(this.renameDocument, applicationConfigPortalFunctions.renameDocument) &&
        Objects.equals(this.rotatePages, applicationConfigPortalFunctions.rotatePages) &&
        Objects.equals(this.sanitize, applicationConfigPortalFunctions.sanitize) &&
        Objects.equals(this.scalePages, applicationConfigPortalFunctions.scalePages) &&
        Objects.equals(this.showHelp, applicationConfigPortalFunctions.showHelp) &&
        Objects.equals(this.signDocument, applicationConfigPortalFunctions.signDocument) &&
        Objects.equals(this.splitDocument, applicationConfigPortalFunctions.splitDocument) &&
        Objects.equals(this.transcribeDocument, applicationConfigPortalFunctions.transcribeDocument) &&
        Objects.equals(this.uploadFile, applicationConfigPortalFunctions.uploadFile) &&
        Objects.equals(this.uploadUrl, applicationConfigPortalFunctions.uploadUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addWatermark, changeDocumentSettings, changeDocumentView, compress, convertDocument, createBarcode, deletePages, detectBarcode, editAnnotation, editAttachment, editBackground, editBoxes, editForms, editHeaderFooter, editTransitions, encryptDocument, exportAsImage, extractContent, extractPages, mergeDocument, movePages, ocrConversion, outline, pdfaConversion, portfolio, printDocument, redact, renameDocument, rotatePages, sanitize, scalePages, showHelp, signDocument, splitDocument, transcribeDocument, uploadFile, uploadUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationConfigPortalFunctions {\n");
    sb.append("    addWatermark: ").append(toIndentedString(addWatermark)).append("\n");
    sb.append("    changeDocumentSettings: ").append(toIndentedString(changeDocumentSettings)).append("\n");
    sb.append("    changeDocumentView: ").append(toIndentedString(changeDocumentView)).append("\n");
    sb.append("    compress: ").append(toIndentedString(compress)).append("\n");
    sb.append("    convertDocument: ").append(toIndentedString(convertDocument)).append("\n");
    sb.append("    createBarcode: ").append(toIndentedString(createBarcode)).append("\n");
    sb.append("    deletePages: ").append(toIndentedString(deletePages)).append("\n");
    sb.append("    detectBarcode: ").append(toIndentedString(detectBarcode)).append("\n");
    sb.append("    editAnnotation: ").append(toIndentedString(editAnnotation)).append("\n");
    sb.append("    editAttachment: ").append(toIndentedString(editAttachment)).append("\n");
    sb.append("    editBackground: ").append(toIndentedString(editBackground)).append("\n");
    sb.append("    editBoxes: ").append(toIndentedString(editBoxes)).append("\n");
    sb.append("    editForms: ").append(toIndentedString(editForms)).append("\n");
    sb.append("    editHeaderFooter: ").append(toIndentedString(editHeaderFooter)).append("\n");
    sb.append("    editTransitions: ").append(toIndentedString(editTransitions)).append("\n");
    sb.append("    encryptDocument: ").append(toIndentedString(encryptDocument)).append("\n");
    sb.append("    exportAsImage: ").append(toIndentedString(exportAsImage)).append("\n");
    sb.append("    extractContent: ").append(toIndentedString(extractContent)).append("\n");
    sb.append("    extractPages: ").append(toIndentedString(extractPages)).append("\n");
    sb.append("    mergeDocument: ").append(toIndentedString(mergeDocument)).append("\n");
    sb.append("    movePages: ").append(toIndentedString(movePages)).append("\n");
    sb.append("    ocrConversion: ").append(toIndentedString(ocrConversion)).append("\n");
    sb.append("    outline: ").append(toIndentedString(outline)).append("\n");
    sb.append("    pdfaConversion: ").append(toIndentedString(pdfaConversion)).append("\n");
    sb.append("    portfolio: ").append(toIndentedString(portfolio)).append("\n");
    sb.append("    printDocument: ").append(toIndentedString(printDocument)).append("\n");
    sb.append("    redact: ").append(toIndentedString(redact)).append("\n");
    sb.append("    renameDocument: ").append(toIndentedString(renameDocument)).append("\n");
    sb.append("    rotatePages: ").append(toIndentedString(rotatePages)).append("\n");
    sb.append("    sanitize: ").append(toIndentedString(sanitize)).append("\n");
    sb.append("    scalePages: ").append(toIndentedString(scalePages)).append("\n");
    sb.append("    showHelp: ").append(toIndentedString(showHelp)).append("\n");
    sb.append("    signDocument: ").append(toIndentedString(signDocument)).append("\n");
    sb.append("    splitDocument: ").append(toIndentedString(splitDocument)).append("\n");
    sb.append("    transcribeDocument: ").append(toIndentedString(transcribeDocument)).append("\n");
    sb.append("    uploadFile: ").append(toIndentedString(uploadFile)).append("\n");
    sb.append("    uploadUrl: ").append(toIndentedString(uploadUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
