/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.0.3669 (2025-02-04T14:04:38Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Provides the server´s license and version information
 */
@Schema(description = "Provides the server´s license and version information")
@JsonPropertyOrder({
  AdminServerVersionInfo.JSON_PROPERTY_HAS_CHANGED_CONFIGURATION,
  AdminServerVersionInfo.JSON_PROPERTY_LICENSE_IS_CLUSTER_USAGE,
  AdminServerVersionInfo.JSON_PROPERTY_LICENSE_TEXT,
  AdminServerVersionInfo.JSON_PROPERTY_MAIN_VERSION,
  AdminServerVersionInfo.JSON_PROPERTY_MINOR_VERSION,
  AdminServerVersionInfo.JSON_PROPERTY_PROVIDERS,
  AdminServerVersionInfo.JSON_PROPERTY_SERVER_PLATFORM,
  AdminServerVersionInfo.JSON_PROPERTY_SERVER_START,
  AdminServerVersionInfo.JSON_PROPERTY_SERVER_VERSION
})
@JsonTypeName("Admin_ServerVersionInfo")

public class AdminServerVersionInfo {
  public static final String JSON_PROPERTY_HAS_CHANGED_CONFIGURATION = "hasChangedConfiguration";
  private Boolean hasChangedConfiguration = false;

  public static final String JSON_PROPERTY_LICENSE_IS_CLUSTER_USAGE = "licenseIsClusterUsage";
  private Boolean licenseIsClusterUsage = false;

  public static final String JSON_PROPERTY_LICENSE_TEXT = "licenseText";
  private String licenseText = "";

  public static final String JSON_PROPERTY_MAIN_VERSION = "mainVersion";
  private Integer mainVersion = 0;

  public static final String JSON_PROPERTY_MINOR_VERSION = "minorVersion";
  private Integer minorVersion = 0;

  public static final String JSON_PROPERTY_PROVIDERS = "providers";
  private AdminProviders providers;

  public static final String JSON_PROPERTY_SERVER_PLATFORM = "serverPlatform";
  private AdminServerOS serverPlatform = AdminServerOS.WINDOWS;

  public static final String JSON_PROPERTY_SERVER_START = "serverStart";
  private Long serverStart = 0l;

  public static final String JSON_PROPERTY_SERVER_VERSION = "serverVersion";
  private String serverVersion = "";

  public AdminServerVersionInfo() {
  }

  public AdminServerVersionInfo hasChangedConfiguration(Boolean hasChangedConfiguration) {
    
    this.hasChangedConfiguration = hasChangedConfiguration;
    return this;
  }

  /**
   * Indicates whether the configuration is currently changed and a restart of the server is necessary to apply the changes.
   * @return hasChangedConfiguration
   **/
  @Nullable
  @Schema(name = "Indicates whether the configuration is currently changed and a restart of the server is necessary to apply the changes.")
  @JsonProperty(JSON_PROPERTY_HAS_CHANGED_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasChangedConfiguration() {
    return hasChangedConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_HAS_CHANGED_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasChangedConfiguration(Boolean hasChangedConfiguration) {
    this.hasChangedConfiguration = hasChangedConfiguration;
  }


  public AdminServerVersionInfo licenseIsClusterUsage(Boolean licenseIsClusterUsage) {
    
    this.licenseIsClusterUsage = licenseIsClusterUsage;
    return this;
  }

  /**
   * Indicates whether the license can be used for a cluster coordinator or member.
   * @return licenseIsClusterUsage
   **/
  @Nullable
  @Schema(name = "Indicates whether the license can be used for a cluster coordinator or member.")
  @JsonProperty(JSON_PROPERTY_LICENSE_IS_CLUSTER_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLicenseIsClusterUsage() {
    return licenseIsClusterUsage;
  }


  @JsonProperty(JSON_PROPERTY_LICENSE_IS_CLUSTER_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLicenseIsClusterUsage(Boolean licenseIsClusterUsage) {
    this.licenseIsClusterUsage = licenseIsClusterUsage;
  }


  public AdminServerVersionInfo licenseText(String licenseText) {
    
    this.licenseText = licenseText;
    return this;
  }

  /**
   * A string summarizing the server´s current license.
   * @return licenseText
   **/
  @Nullable
  @Schema(name = "A string summarizing the server´s current license.")
  @JsonProperty(JSON_PROPERTY_LICENSE_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLicenseText() {
    return licenseText;
  }


  @JsonProperty(JSON_PROPERTY_LICENSE_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLicenseText(String licenseText) {
    this.licenseText = licenseText;
  }


  public AdminServerVersionInfo mainVersion(Integer mainVersion) {
    
    this.mainVersion = mainVersion;
    return this;
  }

  /**
   * The numeric major version of the server.
   * @return mainVersion
   **/
  @Nullable
  @Schema(name = "The numeric major version of the server.")
  @JsonProperty(JSON_PROPERTY_MAIN_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMainVersion() {
    return mainVersion;
  }


  @JsonProperty(JSON_PROPERTY_MAIN_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMainVersion(Integer mainVersion) {
    this.mainVersion = mainVersion;
  }


  public AdminServerVersionInfo minorVersion(Integer minorVersion) {
    
    this.minorVersion = minorVersion;
    return this;
  }

  /**
   * The numeric minor version of the server.
   * @return minorVersion
   **/
  @Nullable
  @Schema(name = "The numeric minor version of the server.")
  @JsonProperty(JSON_PROPERTY_MINOR_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinorVersion() {
    return minorVersion;
  }


  @JsonProperty(JSON_PROPERTY_MINOR_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinorVersion(Integer minorVersion) {
    this.minorVersion = minorVersion;
  }


  public AdminServerVersionInfo providers(AdminProviders providers) {
    
    this.providers = providers;
    return this;
  }

  /**
   * Get providers
   * @return providers
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PROVIDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdminProviders getProviders() {
    return providers;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProviders(AdminProviders providers) {
    this.providers = providers;
  }


  public AdminServerVersionInfo serverPlatform(AdminServerOS serverPlatform) {
    
    this.serverPlatform = serverPlatform;
    return this;
  }

  /**
   * Get serverPlatform
   * @return serverPlatform
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SERVER_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdminServerOS getServerPlatform() {
    return serverPlatform;
  }


  @JsonProperty(JSON_PROPERTY_SERVER_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServerPlatform(AdminServerOS serverPlatform) {
    this.serverPlatform = serverPlatform;
  }


  public AdminServerVersionInfo serverStart(Long serverStart) {
    
    this.serverStart = serverStart;
    return this;
  }

  /**
   * The server start data and time (UTC) as Epoch Unix Timestamp.
   * @return serverStart
   **/
  @Nullable
  @Schema(name = "The server start data and time (UTC) as Epoch Unix Timestamp.")
  @JsonProperty(JSON_PROPERTY_SERVER_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getServerStart() {
    return serverStart;
  }


  @JsonProperty(JSON_PROPERTY_SERVER_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServerStart(Long serverStart) {
    this.serverStart = serverStart;
  }


  public AdminServerVersionInfo serverVersion(String serverVersion) {
    
    this.serverVersion = serverVersion;
    return this;
  }

  /**
   * A formatted string containing the server´s name and version.
   * @return serverVersion
   **/
  @Nullable
  @Schema(name = "A formatted string containing the server´s name and version.")
  @JsonProperty(JSON_PROPERTY_SERVER_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getServerVersion() {
    return serverVersion;
  }


  @JsonProperty(JSON_PROPERTY_SERVER_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServerVersion(String serverVersion) {
    this.serverVersion = serverVersion;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdminServerVersionInfo adminServerVersionInfo = (AdminServerVersionInfo) o;
    return Objects.equals(this.hasChangedConfiguration, adminServerVersionInfo.hasChangedConfiguration) &&
        Objects.equals(this.licenseIsClusterUsage, adminServerVersionInfo.licenseIsClusterUsage) &&
        Objects.equals(this.licenseText, adminServerVersionInfo.licenseText) &&
        Objects.equals(this.mainVersion, adminServerVersionInfo.mainVersion) &&
        Objects.equals(this.minorVersion, adminServerVersionInfo.minorVersion) &&
        Objects.equals(this.providers, adminServerVersionInfo.providers) &&
        Objects.equals(this.serverPlatform, adminServerVersionInfo.serverPlatform) &&
        Objects.equals(this.serverStart, adminServerVersionInfo.serverStart) &&
        Objects.equals(this.serverVersion, adminServerVersionInfo.serverVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hasChangedConfiguration, licenseIsClusterUsage, licenseText, mainVersion, minorVersion, providers, serverPlatform, serverStart, serverVersion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdminServerVersionInfo {\n");
    sb.append("    hasChangedConfiguration: ").append(toIndentedString(hasChangedConfiguration)).append("\n");
    sb.append("    licenseIsClusterUsage: ").append(toIndentedString(licenseIsClusterUsage)).append("\n");
    sb.append("    licenseText: ").append(toIndentedString(licenseText)).append("\n");
    sb.append("    mainVersion: ").append(toIndentedString(mainVersion)).append("\n");
    sb.append("    minorVersion: ").append(toIndentedString(minorVersion)).append("\n");
    sb.append("    providers: ").append(toIndentedString(providers)).append("\n");
    sb.append("    serverPlatform: ").append(toIndentedString(serverPlatform)).append("\n");
    sb.append("    serverStart: ").append(toIndentedString(serverStart)).append("\n");
    sb.append("    serverVersion: ").append(toIndentedString(serverVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
