
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Summarizes structural information and settings for the PDF document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for InformationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="InformationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="description" type="{http://schema.webpdf.de/1.0/extraction/info}DescriptionType"/>
 *         <element name="pdfa" type="{http://schema.webpdf.de/1.0/extraction/info}PdfaType"/>
 *         <element name="viewerPreferences" type="{http://schema.webpdf.de/1.0/extraction/info}ViewerPreferencesType"/>
 *       </sequence>
 *       <attribute name="objectKey" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="version" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="fileSize" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}long">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="initialPage" type="{http://www.w3.org/2001/XMLSchema}int" default="1" />
 *       <attribute name="language" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="pageLayout" type="{http://schema.webpdf.de/1.0/extraction/info}PageLayoutType" default="singlePage" />
 *       <attribute name="magnification" type="{http://schema.webpdf.de/1.0/extraction/info}MagnificationType" default="fitVisible" />
 *       <attribute name="magnificationZoom" default="100">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="initialView" type="{http://schema.webpdf.de/1.0/extraction/info}InitialViewType" default="none" />
 *       <attribute name="encrypted" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="portfolio" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="pages" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="attachments" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="formType" type="{http://schema.webpdf.de/1.0/extraction/info}FormsFormatType" default="none" />
 *       <attribute name="signatures" type="{http://www.w3.org/2001/XMLSchema}int" default="0" />
 *       <attribute name="docMDP" type="{http://schema.webpdf.de/1.0/extraction/info}DocMdpType" default="none" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "InformationType", propOrder = {
    "description",
    "pdfa",
    "viewerPreferences"
})
public class InformationType {

    @XmlElement(required = true)
    protected DescriptionType description;
    @XmlElement(required = true)
    protected PdfaType pdfa;
    @XmlElement(required = true)
    protected ViewerPreferencesType viewerPreferences;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the document's catalog. (root)&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "objectKey")
    protected String objectKey;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The version name of the PDF standard the document claims compatibility with.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "version")
    protected String version;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The byte size of the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fileSize")
    protected Long fileSize;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The first page, that shall be displayed when opening the document in a PDF Reader.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "initialPage")
    protected Integer initialPage;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The natural language of the document. This could either contain the language name or a language tag.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "language")
    protected String language;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The set initial page layout of the document. When opening the document in a Reader, this layout shall be selected to display pages.&#13;
     *                         &lt;ul&gt;&lt;li&gt;singlePage = One page at a time.&lt;/li&gt;&lt;li&gt;oneColumn = One continuous column of pages.&lt;/li&gt;&lt;li&gt;twoColumnLeft = The pages in two columns, with odd&#13;
     *                                 &lt;li&gt;numbered pages on the left.&lt;/li&gt;&lt;/li&gt;&lt;li&gt;twoColumnRight = The pages in two columns, with odd&#13;
     *                                 &lt;li&gt;numbered pages on the right.&lt;/li&gt;&lt;/li&gt;&lt;li&gt;twoPageLeft = Display the pages two at a time, with odd&#13;
     *                                 &lt;li&gt;numbered pages on the left.&lt;/li&gt;&lt;/li&gt;&lt;li&gt;twoPageRight = Display the pages two at a time, with odd&#13;
     *                                 &lt;li&gt;numbered pages on the right.&lt;/li&gt;&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pageLayout")
    protected PageLayoutType pageLayout;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The initial page zoom settings of the document. When opening the document in a Reader, this zoom settings shall be used.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = Uses the application's default view.&lt;/li&gt;&lt;li&gt;fitWidth = Page width.&lt;/li&gt;&lt;li&gt;fitPage = Page dimensions.&lt;/li&gt;&lt;li&gt;fitHeight = Page height.&lt;/li&gt;&lt;li&gt;fitVisible = Page content width.&lt;/li&gt;&lt;li&gt;fitActual = Uses the original page dimensions (100% zoom factor).&lt;/li&gt;&lt;li&gt;zoom = Sets an explicit magnification value.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "magnification")
    protected MagnificationType magnification;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If a magnification "zoom" is selected for this document, this is the actual percentage the pages of the document shall be zoomed to, when opening the document in a PDF Reader.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "magnificationZoom")
    protected Integer magnificationZoom;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines which sub&#13;
     *                         &lt;li&gt;windows will be opened when the PDF document is opened.&lt;/li&gt;&lt;ul&gt;&lt;li&gt;none = No special view&lt;/li&gt;&lt;li&gt;outlines = Opens the "Bookmarks" tab&lt;/li&gt;&lt;li&gt;thumbnails = Opens the "Thumbnails" tab&lt;/li&gt;&lt;li&gt;fullscreen = Opens the document in full screen mode&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "initialView")
    protected InitialViewType initialView;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This will be set to "true" for a document, that is either password protected or certificate encrypted.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "encrypted")
    protected Boolean encrypted;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Will be set to "true" for a "PDF collection" (Portfolio), that serves as the container for other documents.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "portfolio")
    protected Boolean portfolio;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of pages contained in the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected Integer pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of attachments contained in the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "attachments")
    protected Integer attachments;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When set to another value than "none", the document does contain a PDF form in the hereby given format.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = The document does not contain a form.&lt;/li&gt;&lt;li&gt;acroForm = The document contains a standard PDF Acroform.&lt;/li&gt;&lt;li&gt;staticXFA = The document contains a "XML Forms Architecture" form with a fixed layout (static).&lt;/li&gt;&lt;li&gt;dynamicXFA = The document contains a "XML Forms Architecture" form with an adaptable/interactive layout (dynamic).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "formType")
    protected FormsFormatType formType;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of signatures contained in the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "signatures")
    protected Integer signatures;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A document "Modification Detection and Prevention" may be set, that defines which modifications of the document are allowed and which modifications would render the signature invalid.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = The document is unprotected&lt;/li&gt;&lt;li&gt;modify it as you please.&lt;/li&gt;&lt;li&gt;noChangesAllowed = Any modifications of the document would render the signatures invalid.&lt;/li&gt;&lt;li&gt;formFillingSignatures = You may fill in forms and further sign the document.&lt;/li&gt;&lt;li&gt;formFillingSignaturesAndAnnotations = Form filling, signing and adding annotations are allowed.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "docMDP")
    protected DocMdpType docMDP;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link DescriptionType }
     *     
     */
    public DescriptionType getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link DescriptionType }
     *     
     */
    public void setDescription(DescriptionType value) {
        this.description = value;
    }

    /**
     * Gets the value of the pdfa property.
     * 
     * @return
     *     possible object is
     *     {@link PdfaType }
     *     
     */
    public PdfaType getPdfa() {
        return pdfa;
    }

    /**
     * Sets the value of the pdfa property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfaType }
     *     
     */
    public void setPdfa(PdfaType value) {
        this.pdfa = value;
    }

    /**
     * Gets the value of the viewerPreferences property.
     * 
     * @return
     *     possible object is
     *     {@link ViewerPreferencesType }
     *     
     */
    public ViewerPreferencesType getViewerPreferences() {
        return viewerPreferences;
    }

    /**
     * Sets the value of the viewerPreferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link ViewerPreferencesType }
     *     
     */
    public void setViewerPreferences(ViewerPreferencesType value) {
        this.viewerPreferences = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the document's catalog. (root)&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getObjectKey() {
        if (objectKey == null) {
            return "";
        } else {
            return objectKey;
        }
    }

    /**
     * Sets the value of the objectKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getObjectKey()
     */
    public void setObjectKey(String value) {
        this.objectKey = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The version name of the PDF standard the document claims compatibility with.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        if (version == null) {
            return "";
        } else {
            return version;
        }
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getVersion()
     */
    public void setVersion(String value) {
        this.version = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The byte size of the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Long }
     *     
     */
    public long getFileSize() {
        if (fileSize == null) {
            return  0L;
        } else {
            return fileSize;
        }
    }

    /**
     * Sets the value of the fileSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link Long }
     *     
     * @see #getFileSize()
     */
    public void setFileSize(Long value) {
        this.fileSize = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The first page, that shall be displayed when opening the document in a PDF Reader.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getInitialPage() {
        if (initialPage == null) {
            return  1;
        } else {
            return initialPage;
        }
    }

    /**
     * Sets the value of the initialPage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getInitialPage()
     */
    public void setInitialPage(Integer value) {
        this.initialPage = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The natural language of the document. This could either contain the language name or a language tag.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLanguage() {
        if (language == null) {
            return "";
        } else {
            return language;
        }
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getLanguage()
     */
    public void setLanguage(String value) {
        this.language = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The set initial page layout of the document. When opening the document in a Reader, this layout shall be selected to display pages.&#13;
     *                         &lt;ul&gt;&lt;li&gt;singlePage = One page at a time.&lt;/li&gt;&lt;li&gt;oneColumn = One continuous column of pages.&lt;/li&gt;&lt;li&gt;twoColumnLeft = The pages in two columns, with odd&#13;
     *                                 &lt;li&gt;numbered pages on the left.&lt;/li&gt;&lt;/li&gt;&lt;li&gt;twoColumnRight = The pages in two columns, with odd&#13;
     *                                 &lt;li&gt;numbered pages on the right.&lt;/li&gt;&lt;/li&gt;&lt;li&gt;twoPageLeft = Display the pages two at a time, with odd&#13;
     *                                 &lt;li&gt;numbered pages on the left.&lt;/li&gt;&lt;/li&gt;&lt;li&gt;twoPageRight = Display the pages two at a time, with odd&#13;
     *                                 &lt;li&gt;numbered pages on the right.&lt;/li&gt;&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PageLayoutType }
     *     
     */
    public PageLayoutType getPageLayout() {
        if (pageLayout == null) {
            return PageLayoutType.SINGLE_PAGE;
        } else {
            return pageLayout;
        }
    }

    /**
     * Sets the value of the pageLayout property.
     * 
     * @param value
     *     allowed object is
     *     {@link PageLayoutType }
     *     
     * @see #getPageLayout()
     */
    public void setPageLayout(PageLayoutType value) {
        this.pageLayout = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The initial page zoom settings of the document. When opening the document in a Reader, this zoom settings shall be used.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = Uses the application's default view.&lt;/li&gt;&lt;li&gt;fitWidth = Page width.&lt;/li&gt;&lt;li&gt;fitPage = Page dimensions.&lt;/li&gt;&lt;li&gt;fitHeight = Page height.&lt;/li&gt;&lt;li&gt;fitVisible = Page content width.&lt;/li&gt;&lt;li&gt;fitActual = Uses the original page dimensions (100% zoom factor).&lt;/li&gt;&lt;li&gt;zoom = Sets an explicit magnification value.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MagnificationType }
     *     
     */
    public MagnificationType getMagnification() {
        if (magnification == null) {
            return MagnificationType.FIT_VISIBLE;
        } else {
            return magnification;
        }
    }

    /**
     * Sets the value of the magnification property.
     * 
     * @param value
     *     allowed object is
     *     {@link MagnificationType }
     *     
     * @see #getMagnification()
     */
    public void setMagnification(MagnificationType value) {
        this.magnification = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If a magnification "zoom" is selected for this document, this is the actual percentage the pages of the document shall be zoomed to, when opening the document in a PDF Reader.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMagnificationZoom() {
        if (magnificationZoom == null) {
            return  100;
        } else {
            return magnificationZoom;
        }
    }

    /**
     * Sets the value of the magnificationZoom property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getMagnificationZoom()
     */
    public void setMagnificationZoom(Integer value) {
        this.magnificationZoom = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines which sub&#13;
     *                         &lt;li&gt;windows will be opened when the PDF document is opened.&lt;/li&gt;&lt;ul&gt;&lt;li&gt;none = No special view&lt;/li&gt;&lt;li&gt;outlines = Opens the "Bookmarks" tab&lt;/li&gt;&lt;li&gt;thumbnails = Opens the "Thumbnails" tab&lt;/li&gt;&lt;li&gt;fullscreen = Opens the document in full screen mode&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link InitialViewType }
     *     
     */
    public InitialViewType getInitialView() {
        if (initialView == null) {
            return InitialViewType.NONE;
        } else {
            return initialView;
        }
    }

    /**
     * Sets the value of the initialView property.
     * 
     * @param value
     *     allowed object is
     *     {@link InitialViewType }
     *     
     * @see #getInitialView()
     */
    public void setInitialView(InitialViewType value) {
        this.initialView = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This will be set to "true" for a document, that is either password protected or certificate encrypted.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isEncrypted() {
        if (encrypted == null) {
            return false;
        } else {
            return encrypted;
        }
    }

    /**
     * Sets the value of the encrypted property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isEncrypted()
     */
    public void setEncrypted(Boolean value) {
        this.encrypted = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Will be set to "true" for a "PDF collection" (Portfolio), that serves as the container for other documents.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isPortfolio() {
        if (portfolio == null) {
            return false;
        } else {
            return portfolio;
        }
    }

    /**
     * Sets the value of the portfolio property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isPortfolio()
     */
    public void setPortfolio(Boolean value) {
        this.portfolio = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of pages contained in the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPages() {
        if (pages == null) {
            return  0;
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPages()
     */
    public void setPages(Integer value) {
        this.pages = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of attachments contained in the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getAttachments() {
        if (attachments == null) {
            return  0;
        } else {
            return attachments;
        }
    }

    /**
     * Sets the value of the attachments property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getAttachments()
     */
    public void setAttachments(Integer value) {
        this.attachments = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When set to another value than "none", the document does contain a PDF form in the hereby given format.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = The document does not contain a form.&lt;/li&gt;&lt;li&gt;acroForm = The document contains a standard PDF Acroform.&lt;/li&gt;&lt;li&gt;staticXFA = The document contains a "XML Forms Architecture" form with a fixed layout (static).&lt;/li&gt;&lt;li&gt;dynamicXFA = The document contains a "XML Forms Architecture" form with an adaptable/interactive layout (dynamic).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FormsFormatType }
     *     
     */
    public FormsFormatType getFormType() {
        if (formType == null) {
            return FormsFormatType.NONE;
        } else {
            return formType;
        }
    }

    /**
     * Sets the value of the formType property.
     * 
     * @param value
     *     allowed object is
     *     {@link FormsFormatType }
     *     
     * @see #getFormType()
     */
    public void setFormType(FormsFormatType value) {
        this.formType = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of signatures contained in the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getSignatures() {
        if (signatures == null) {
            return  0;
        } else {
            return signatures;
        }
    }

    /**
     * Sets the value of the signatures property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getSignatures()
     */
    public void setSignatures(Integer value) {
        this.signatures = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A document "Modification Detection and Prevention" may be set, that defines which modifications of the document are allowed and which modifications would render the signature invalid.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = The document is unprotected&lt;/li&gt;&lt;li&gt;modify it as you please.&lt;/li&gt;&lt;li&gt;noChangesAllowed = Any modifications of the document would render the signatures invalid.&lt;/li&gt;&lt;li&gt;formFillingSignatures = You may fill in forms and further sign the document.&lt;/li&gt;&lt;li&gt;formFillingSignaturesAndAnnotations = Form filling, signing and adding annotations are allowed.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link DocMdpType }
     *     
     */
    public DocMdpType getDocMDP() {
        if (docMDP == null) {
            return DocMdpType.NONE;
        } else {
            return docMDP;
        }
    }

    /**
     * Sets the value of the docMDP property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocMdpType }
     *     
     * @see #getDocMDP()
     */
    public void setDocMDP(DocMdpType value) {
        this.docMDP = value;
    }

}
