
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * Defines a set of attributes for field annotations.
 * 
 * <p>Java class for FieldAnnotationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="FieldAnnotationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="signature" type="{http://schema.webpdf.de/1.0/extraction/info}SignatureType" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="mappingName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="alternateName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="type" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FieldAnnotationType", propOrder = {
    "signature"
})
public class FieldAnnotationType {

    /**
     * Relates this field to a signature. Should this element be present, the annotation is representing a signature.
     * 
     */
    protected SignatureType signature;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The partial name of the annotation´s field.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "name")
    protected String name;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The mapping name of the annotation´s field.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "mappingName")
    protected String mappingName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The alternate name of the annotation´s field.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "alternateName")
    protected String alternateName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Indicates the type of the annotation´s field.&#13;
     *                         &lt;ul&gt;&lt;li&gt;Btn = Button&lt;/li&gt;&lt;li&gt;Tx = Textfield&lt;/li&gt;&lt;li&gt;Ch = Choicefield&lt;/li&gt;&lt;li&gt;Sig = Signaturefield&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "type")
    protected String type;

    /**
     * Relates this field to a signature. Should this element be present, the annotation is representing a signature.
     * 
     * @return
     *     possible object is
     *     {@link SignatureType }
     *     
     */
    public SignatureType getSignature() {
        return signature;
    }

    /**
     * Sets the value of the signature property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureType }
     *     
     * @see #getSignature()
     */
    public void setSignature(SignatureType value) {
        this.signature = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The partial name of the annotation´s field.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        if (name == null) {
            return "";
        } else {
            return name;
        }
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The mapping name of the annotation´s field.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMappingName() {
        if (mappingName == null) {
            return "";
        } else {
            return mappingName;
        }
    }

    /**
     * Sets the value of the mappingName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getMappingName()
     */
    public void setMappingName(String value) {
        this.mappingName = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The alternate name of the annotation´s field.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlternateName() {
        if (alternateName == null) {
            return "";
        } else {
            return alternateName;
        }
    }

    /**
     * Sets the value of the alternateName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getAlternateName()
     */
    public void setAlternateName(String value) {
        this.alternateName = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Indicates the type of the annotation´s field.&#13;
     *                         &lt;ul&gt;&lt;li&gt;Btn = Button&lt;/li&gt;&lt;li&gt;Tx = Textfield&lt;/li&gt;&lt;li&gt;Ch = Choicefield&lt;/li&gt;&lt;li&gt;Sig = Signaturefield&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getType() {
        if (type == null) {
            return "";
        } else {
            return type;
        }
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getType()
     */
    public void setType(String value) {
        this.type = value;
    }

}
