
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The duplex settings initially suggested when opening the Reader's print dialog.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = The Reader shall use it's default suggestion.&lt;/li&gt;&lt;li&gt;simplex = The Reader shall suggest simplex printing.&lt;/li&gt;&lt;li&gt;duplexFlipShortEdge = The Reader shall suggest duplex printing, flipping pages over the shorter edge.&lt;/li&gt;&lt;li&gt;duplexFlipLongEdge = The Reader shall suggest duplex printing, flipping pages over the longer edge.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for DuplexType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="DuplexType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="simplex"/>
 *     <enumeration value="duplexFlipShortEdge"/>
 *     <enumeration value="duplexFlipLongEdge"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "DuplexType")
@XmlEnum
public enum DuplexType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("simplex")
    SIMPLEX("simplex"),
    @XmlEnumValue("duplexFlipShortEdge")
    DUPLEX_FLIP_SHORT_EDGE("duplexFlipShortEdge"),
    @XmlEnumValue("duplexFlipLongEdge")
    DUPLEX_FLIP_LONG_EDGE("duplexFlipLongEdge");
    private final String value;

    DuplexType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static DuplexType fromValue(String v) {
        for (DuplexType c: DuplexType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
