
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the draw style of an drawable shape.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for DrawStyleType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="DrawStyleType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="drawMode" type="{http://schema.webpdf.de/1.0/extraction/info}DrawModeType" default="stroke" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DrawStyleType")
public class DrawStyleType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the draw style of an drawable shape.&#13;
     *                         &lt;ul&gt;&lt;li&gt;fill = fill the shape&lt;/li&gt;&lt;li&gt;stroke = draw the outlines of the shape&lt;/li&gt;&lt;li&gt;fillAndStroke = draw the outlines and fill the shape&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "drawMode")
    protected DrawModeType drawMode;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the draw style of an drawable shape.&#13;
     *                         &lt;ul&gt;&lt;li&gt;fill = fill the shape&lt;/li&gt;&lt;li&gt;stroke = draw the outlines of the shape&lt;/li&gt;&lt;li&gt;fillAndStroke = draw the outlines and fill the shape&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link DrawModeType }
     *     
     */
    public DrawModeType getDrawMode() {
        if (drawMode == null) {
            return DrawModeType.STROKE;
        } else {
            return drawMode;
        }
    }

    /**
     * Sets the value of the drawMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DrawModeType }
     *     
     * @see #getDrawMode()
     */
    public void setDrawMode(DrawModeType value) {
        this.drawMode = value;
    }

}
