
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A document "Modification Detection and Prevention" may be set, that defines which modifications of the document are allowed and which modifications would render the signature invalid.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = The document is unprotected - modify it as you please.&lt;/li&gt;&lt;li&gt;noChangesAllowed = Any modifications of the document would render the signatures invalid.&lt;/li&gt;&lt;li&gt;formFillingSignatures = You may fill in forms and further sign the document.&lt;/li&gt;&lt;li&gt;formFillingSignaturesAndAnnotations = Form filling, signing and adding annotations are allowed.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for DocMdpType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="DocMdpType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="noChangesAllowed"/>
 *     <enumeration value="formFillingSignatures"/>
 *     <enumeration value="formFillingSignaturesAnnotations"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "DocMdpType")
@XmlEnum
public enum DocMdpType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("noChangesAllowed")
    NO_CHANGES_ALLOWED("noChangesAllowed"),
    @XmlEnumValue("formFillingSignatures")
    FORM_FILLING_SIGNATURES("formFillingSignatures"),
    @XmlEnumValue("formFillingSignaturesAnnotations")
    FORM_FILLING_SIGNATURES_ANNOTATIONS("formFillingSignaturesAnnotations");
    private final String value;

    DocMdpType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static DocMdpType fromValue(String v) {
        for (DocMdpType c: DocMdpType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
