
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This type is used to describe the boxes of a page.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BoxesType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BoxesType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="mediaBox" type="{http://schema.webpdf.de/1.0/extraction/info}RectangleType"/>
 *         <element name="cropBox" type="{http://schema.webpdf.de/1.0/extraction/info}RectangleType" minOccurs="0"/>
 *         <element name="bleedBox" type="{http://schema.webpdf.de/1.0/extraction/info}RectangleType" minOccurs="0"/>
 *         <element name="trimBox" type="{http://schema.webpdf.de/1.0/extraction/info}RectangleType" minOccurs="0"/>
 *         <element name="artBox" type="{http://schema.webpdf.de/1.0/extraction/info}RectangleType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BoxesType", propOrder = {
    "mediaBox",
    "cropBox",
    "bleedBox",
    "trimBox",
    "artBox"
})
public class BoxesType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page's physical dimensions.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlElement(required = true)
    protected RectangleType mediaBox;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The visible (printable) page area.&lt;/p&gt;
     * </pre>
     * 
     */
    protected RectangleType cropBox;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Untrimmed content position on the page (content dimensions plus trim box).&lt;/p&gt;
     * </pre>
     * 
     */
    protected RectangleType bleedBox;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Trimmed content position on the page (final content dimensions).&lt;/p&gt;
     * </pre>
     * 
     */
    protected RectangleType trimBox;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Position for special page content (images).&lt;/p&gt;
     * </pre>
     * 
     */
    protected RectangleType artBox;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page's physical dimensions.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getMediaBox() {
        return mediaBox;
    }

    /**
     * Sets the value of the mediaBox property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     * @see #getMediaBox()
     */
    public void setMediaBox(RectangleType value) {
        this.mediaBox = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The visible (printable) page area.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getCropBox() {
        return cropBox;
    }

    /**
     * Sets the value of the cropBox property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     * @see #getCropBox()
     */
    public void setCropBox(RectangleType value) {
        this.cropBox = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Untrimmed content position on the page (content dimensions plus trim box).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getBleedBox() {
        return bleedBox;
    }

    /**
     * Sets the value of the bleedBox property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     * @see #getBleedBox()
     */
    public void setBleedBox(RectangleType value) {
        this.bleedBox = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Trimmed content position on the page (final content dimensions).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getTrimBox() {
        return trimBox;
    }

    /**
     * Sets the value of the trimBox property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     * @see #getTrimBox()
     */
    public void setTrimBox(RectangleType value) {
        this.trimBox = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Position for special page content (images).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getArtBox() {
        return artBox;
    }

    /**
     * Sets the value of the artBox property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     * @see #getArtBox()
     */
    public void setArtBox(RectangleType value) {
        this.artBox = value;
    }

}
