
package net.webpdf.parameter.schema.extraction.info;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An element of this type describes an Annotation placed on a page of the document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for AnnotationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="AnnotationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence minOccurs="0">
 *         <choice maxOccurs="unbounded" minOccurs="0">
 *           <element name="rectangle" type="{http://schema.webpdf.de/1.0/extraction/info}AnnotationRectangleType"/>
 *           <element name="point" type="{http://schema.webpdf.de/1.0/extraction/info}AnnotationPointType"/>
 *         </choice>
 *         <element name="markup" type="{http://schema.webpdf.de/1.0/extraction/info}MarkupType" minOccurs="0"/>
 *         <element name="popup" type="{http://schema.webpdf.de/1.0/extraction/info}PopupType" minOccurs="0"/>
 *         <element name="appearance" type="{http://schema.webpdf.de/1.0/extraction/info}AppearanceType" minOccurs="0"/>
 *         <element name="line" type="{http://schema.webpdf.de/1.0/extraction/info}LineType" minOccurs="0"/>
 *         <element name="border" type="{http://schema.webpdf.de/1.0/extraction/info}BorderStyle" minOccurs="0"/>
 *         <element name="drawStyle" type="{http://schema.webpdf.de/1.0/extraction/info}DrawStyleType" minOccurs="0"/>
 *         <element name="field" type="{http://schema.webpdf.de/1.0/extraction/info}FieldAnnotationType" minOccurs="0"/>
 *       </sequence>
 *       <attGroup ref="{http://schema.webpdf.de/1.0/extraction/info}FlagsAnnotationGroup"/>
 *       <attribute name="objectKey" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="subType" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="contents" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="page" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="color" type="{http://schema.webpdf.de/1.0/extraction/info}RgbColorType" default="#4800FF" />
 *       <attribute name="rotation" type="{http://www.w3.org/2001/XMLSchema}int" default="0" />
 *       <attribute name="iconName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AnnotationType", propOrder = {
    "positions",
    "markup",
    "popup",
    "appearance",
    "line",
    "border",
    "drawStyle",
    "field"
})
public class AnnotationType {

    @XmlElements({
        @XmlElement(name = "rectangle", type = AnnotationRectangleType.class),
        @XmlElement(name = "point", type = AnnotationPointType.class)
    })
    protected List<PositionsType> positions;
    protected MarkupType markup;
    protected PopupType popup;
    protected AppearanceType appearance;
    protected LineType line;
    protected BorderStyle border;
    protected DrawStyleType drawStyle;
    protected FieldAnnotationType field;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the annotation.&#13;
     * &#13;
     *                         &lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "objectKey")
    protected String objectKey;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The type of an annotation is always "Annot", this is the sub type of the annotation determining the actual behavior and function of the annotation. (i.e. Text, Link, Widget etc.)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "subType")
    protected String subType;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation's name.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         This name is optional and in the best case unique in the annotation's page context only. Don't use the name to select an annotation, always prefer selecting objects by object ID, when possible.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "name")
    protected String name;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation's textual contents or (should an annotation of this type not have such contents) it's description.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "contents")
    protected String contents;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of the page the annotation is placed on.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The main color of visible annotations. The color will be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "color")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String color;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation's rotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "rotation")
    protected Integer rotation;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If the annotation selects an icon (Text annotations), this is the name of that icon.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "iconName")
    protected String iconName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be locked so that no changes can be made to it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "locked")
    protected Boolean locked;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be included when the page is printed out.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printable")
    protected Boolean printable;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "rotatable")
    protected Boolean rotatable;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be shown on the document's page.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "viewable")
    protected Boolean viewable;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, it will be possible to change the annotation's contents later on.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "writable")
    protected Boolean writable;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "zoomable")
    protected Boolean zoomable;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "invisible")
    protected Boolean invisible;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will not be shown on the page and will not be printed either.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "hidden")
    protected Boolean hidden;

    /**
     * Gets the value of the positions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the positions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPositions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AnnotationPointType }
     * {@link AnnotationRectangleType }
     * </p>
     * 
     * 
     * @return
     *     The value of the positions property.
     */
    public List<PositionsType> getPositions() {
        if (positions == null) {
            positions = new ArrayList<>();
        }
        return this.positions;
    }

    /**
     * Gets the value of the markup property.
     * 
     * @return
     *     possible object is
     *     {@link MarkupType }
     *     
     */
    public MarkupType getMarkup() {
        return markup;
    }

    /**
     * Sets the value of the markup property.
     * 
     * @param value
     *     allowed object is
     *     {@link MarkupType }
     *     
     */
    public void setMarkup(MarkupType value) {
        this.markup = value;
    }

    /**
     * Gets the value of the popup property.
     * 
     * @return
     *     possible object is
     *     {@link PopupType }
     *     
     */
    public PopupType getPopup() {
        return popup;
    }

    /**
     * Sets the value of the popup property.
     * 
     * @param value
     *     allowed object is
     *     {@link PopupType }
     *     
     */
    public void setPopup(PopupType value) {
        this.popup = value;
    }

    /**
     * Gets the value of the appearance property.
     * 
     * @return
     *     possible object is
     *     {@link AppearanceType }
     *     
     */
    public AppearanceType getAppearance() {
        return appearance;
    }

    /**
     * Sets the value of the appearance property.
     * 
     * @param value
     *     allowed object is
     *     {@link AppearanceType }
     *     
     */
    public void setAppearance(AppearanceType value) {
        this.appearance = value;
    }

    /**
     * Gets the value of the line property.
     * 
     * @return
     *     possible object is
     *     {@link LineType }
     *     
     */
    public LineType getLine() {
        return line;
    }

    /**
     * Sets the value of the line property.
     * 
     * @param value
     *     allowed object is
     *     {@link LineType }
     *     
     */
    public void setLine(LineType value) {
        this.line = value;
    }

    /**
     * Gets the value of the border property.
     * 
     * @return
     *     possible object is
     *     {@link BorderStyle }
     *     
     */
    public BorderStyle getBorder() {
        return border;
    }

    /**
     * Sets the value of the border property.
     * 
     * @param value
     *     allowed object is
     *     {@link BorderStyle }
     *     
     */
    public void setBorder(BorderStyle value) {
        this.border = value;
    }

    /**
     * Gets the value of the drawStyle property.
     * 
     * @return
     *     possible object is
     *     {@link DrawStyleType }
     *     
     */
    public DrawStyleType getDrawStyle() {
        return drawStyle;
    }

    /**
     * Sets the value of the drawStyle property.
     * 
     * @param value
     *     allowed object is
     *     {@link DrawStyleType }
     *     
     */
    public void setDrawStyle(DrawStyleType value) {
        this.drawStyle = value;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link FieldAnnotationType }
     *     
     */
    public FieldAnnotationType getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param value
     *     allowed object is
     *     {@link FieldAnnotationType }
     *     
     */
    public void setField(FieldAnnotationType value) {
        this.field = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the annotation.&#13;
     * &#13;
     *                         &lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getObjectKey() {
        if (objectKey == null) {
            return "";
        } else {
            return objectKey;
        }
    }

    /**
     * Sets the value of the objectKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getObjectKey()
     */
    public void setObjectKey(String value) {
        this.objectKey = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The type of an annotation is always "Annot", this is the sub type of the annotation determining the actual behavior and function of the annotation. (i.e. Text, Link, Widget etc.)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubType() {
        if (subType == null) {
            return "";
        } else {
            return subType;
        }
    }

    /**
     * Sets the value of the subType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSubType()
     */
    public void setSubType(String value) {
        this.subType = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation's name.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         This name is optional and in the best case unique in the annotation's page context only. Don't use the name to select an annotation, always prefer selecting objects by object ID, when possible.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        if (name == null) {
            return "";
        } else {
            return name;
        }
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation's textual contents or (should an annotation of this type not have such contents) it's description.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getContents() {
        if (contents == null) {
            return "";
        } else {
            return contents;
        }
    }

    /**
     * Sets the value of the contents property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getContents()
     */
    public void setContents(String value) {
        this.contents = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of the page the annotation is placed on.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  0;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(Integer value) {
        this.page = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The main color of visible annotations. The color will be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColor() {
        if (color == null) {
            return "#4800FF";
        } else {
            return color;
        }
    }

    /**
     * Sets the value of the color property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getColor()
     */
    public void setColor(String value) {
        this.color = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation's rotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getRotation() {
        if (rotation == null) {
            return  0;
        } else {
            return rotation;
        }
    }

    /**
     * Sets the value of the rotation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getRotation()
     */
    public void setRotation(Integer value) {
        this.rotation = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If the annotation selects an icon (Text annotations), this is the name of that icon.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIconName() {
        if (iconName == null) {
            return "";
        } else {
            return iconName;
        }
    }

    /**
     * Sets the value of the iconName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getIconName()
     */
    public void setIconName(String value) {
        this.iconName = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be locked so that no changes can be made to it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isLocked() {
        if (locked == null) {
            return true;
        } else {
            return locked;
        }
    }

    /**
     * Sets the value of the locked property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isLocked()
     */
    public void setLocked(Boolean value) {
        this.locked = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be included when the page is printed out.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isPrintable() {
        if (printable == null) {
            return false;
        } else {
            return printable;
        }
    }

    /**
     * Sets the value of the printable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isPrintable()
     */
    public void setPrintable(Boolean value) {
        this.printable = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRotatable() {
        if (rotatable == null) {
            return true;
        } else {
            return rotatable;
        }
    }

    /**
     * Sets the value of the rotatable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isRotatable()
     */
    public void setRotatable(Boolean value) {
        this.rotatable = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be shown on the document's page.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isViewable() {
        if (viewable == null) {
            return true;
        } else {
            return viewable;
        }
    }

    /**
     * Sets the value of the viewable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isViewable()
     */
    public void setViewable(Boolean value) {
        this.viewable = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, it will be possible to change the annotation's contents later on.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isWritable() {
        if (writable == null) {
            return true;
        } else {
            return writable;
        }
    }

    /**
     * Sets the value of the writable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isWritable()
     */
    public void setWritable(Boolean value) {
        this.writable = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isZoomable() {
        if (zoomable == null) {
            return true;
        } else {
            return zoomable;
        }
    }

    /**
     * Sets the value of the zoomable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isZoomable()
     */
    public void setZoomable(Boolean value) {
        this.zoomable = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isInvisible() {
        if (invisible == null) {
            return false;
        } else {
            return invisible;
        }
    }

    /**
     * Sets the value of the invisible property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isInvisible()
     */
    public void setInvisible(Boolean value) {
        this.invisible = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will not be shown on the page and will not be printed either.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHidden() {
        if (hidden == null) {
            return false;
        } else {
            return hidden;
        }
    }

    /**
     * Sets the value of the hidden property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isHidden()
     */
    public void setHidden(Boolean value) {
        this.hidden = value;
    }

}
