/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.tools.adapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Method;

public class EnumAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (rawType.isEnum()) {
            return new EnumTypeAdapter();
        }
        return null;
    }

    class EnumTypeAdapter<T>
    extends TypeAdapter<T> {
        EnumTypeAdapter() {
        }

        public void write(JsonWriter out, T value) throws IOException {
            if (out == null) {
                return;
            }
            if (value == null) {
                out.nullValue();
                return;
            }
            try {
                Class<?> valueClass = value.getClass();
                Method method = valueClass.getMethod("value", new Class[0]);
                String data = (String)method.invoke(value, new Object[0]);
                out.value(data);
            }
            catch (Exception ex) {
                out.nullValue();
            }
        }

        public T read(JsonReader in) {
            return null;
        }
    }
}

