/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.tools;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import net.webpdf.wsclient.tools.XMLStatus;
import org.apache.commons.lang3.StringUtils;

class XMLValidationEventHandler
implements ValidationEventHandler {
    private List<String> messages = new ArrayList<String>();
    private XMLStatus xmlStatus = XMLStatus.OK;

    XMLValidationEventHandler() {
    }

    public boolean isValid() {
        return this.xmlStatus.equals((Object)XMLStatus.OK);
    }

    public boolean handleEvent(ValidationEvent event) {
        if (event == null) {
            return false;
        }
        XMLStatus status = XMLStatus.OK;
        switch (event.getSeverity()) {
            case 0: {
                status = XMLStatus.WARNING;
                break;
            }
            case 1: {
                status = XMLStatus.ERROR;
                break;
            }
            case 2: {
                status = XMLStatus.FATAL;
            }
        }
        if (status.ordinal() > this.xmlStatus.ordinal()) {
            this.xmlStatus = status;
        }
        String message = event.getMessage() != null ? event.getMessage() : "";
        ValidationEventLocator validationEventLocator = event.getLocator();
        if (validationEventLocator != null) {
            message = message + String.format(" (line: %d; column: %d)", validationEventLocator.getLineNumber(), validationEventLocator.getColumnNumber());
        }
        this.messages.add(message);
        return false;
    }

    public String getMessages() {
        return StringUtils.join(this.messages, (String)"\n");
    }

    public XMLStatus getXMLStatus() {
        return this.xmlStatus;
    }
}

