/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session;

import java.net.URL;
import net.webpdf.wsclient.WebServiceProtocol;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.https.TLSContext;
import net.webpdf.wsclient.session.RestSession;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.session.SoapSession;

public final class SessionFactory {
    private SessionFactory() {
    }

    public static <T extends Session> T createInstance(WebServiceProtocol webServiceProtocol, URL url) throws ResultException {
        return SessionFactory.createInstance(webServiceProtocol, url, null);
    }

    public static <T extends Session> T createInstance(WebServiceProtocol webServiceProtocol, URL url, TLSContext tlsContext) throws ResultException {
        switch (webServiceProtocol) {
            case SOAP: {
                return (T)new SoapSession(url, tlsContext);
            }
            case REST: {
                return (T)new RestSession(url, tlsContext);
            }
        }
        throw new ResultException(Result.build(Error.SESSION_CREATE));
    }
}

