/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session;

import java.io.IOException;
import java.net.URL;
import net.webpdf.wsclient.WebServiceProtocol;
import net.webpdf.wsclient.documents.DocumentManager;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.http.HttpMethod;
import net.webpdf.wsclient.http.HttpRestRequest;
import net.webpdf.wsclient.https.TLSContext;
import net.webpdf.wsclient.schema.beans.Token;
import net.webpdf.wsclient.session.AbstractSession;
import net.webpdf.wsclient.session.DataFormat;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class RestSession
extends AbstractSession {
    private static final String LOGOUT_PATH = "authentication/user/logout/";
    private static final String LOGIN_PATH = "authentication/user/login/";
    private Token token = new Token();
    private CloseableHttpClient httpClient;
    private DocumentManager documentManager = new DocumentManager(this);

    RestSession(URL url, TLSContext tlsContext) throws ResultException {
        super(url, WebServiceProtocol.REST, tlsContext);
        this.dataFormat = DataFormat.JSON;
        RequestConfig clientConfig = RequestConfig.custom().setAuthenticationEnabled(true).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(clientConfig).setDefaultCredentialsProvider(this.credentialsProvider);
        if (this.getTlsContext() != null && this.getTlsContext().getSslContext() != null) {
            httpClientBuilder.setSSLContext(this.getTlsContext().getSslContext());
        }
        this.httpClient = httpClientBuilder.build();
    }

    public Token getToken() {
        return this.token;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.token != null && !this.token.getToken().isEmpty()) {
                this.logout();
            }
        }
        catch (ResultException ex) {
            throw new IOException("Unable to logout from server", ex);
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
    }

    public void login() throws IOException {
        this.token = HttpRestRequest.createRequest(this).buildRequest(HttpMethod.GET, LOGIN_PATH, null).executeRequest(Token.class);
    }

    private void logout() throws IOException {
        HttpRestRequest.createRequest(this).buildRequest(HttpMethod.GET, LOGOUT_PATH, null).executeRequest(Object.class);
        this.token = null;
    }
}

