/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.webpdf.wsclient.WebServiceProtocol;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.https.TLSContext;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.Session;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;

abstract class AbstractSession
implements Session {
    CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    DataFormat dataFormat = DataFormat.JSON;
    private String basePath;
    private URI baseUrl;
    private WebServiceProtocol webServiceProtocol;
    private AuthScope authScope;
    private Credentials credentials;
    private TLSContext tlsContext;

    AbstractSession(URL url, WebServiceProtocol webServiceProtocol, TLSContext tlsContext) throws ResultException {
        this.webServiceProtocol = webServiceProtocol;
        this.tlsContext = tlsContext;
        this.basePath = webServiceProtocol.equals((Object)WebServiceProtocol.SOAP) ? "soap/" : "rest/";
        this.buildBaseURL(url);
    }

    @Override
    public TLSContext getTlsContext() {
        return this.tlsContext;
    }

    @Override
    public WebServiceProtocol getWebServiceProtocol() {
        return this.webServiceProtocol;
    }

    private void extractUserInfo(String userInfo) {
        String name = "";
        String password = "";
        if (userInfo != null) {
            String[] credentials = userInfo.split(":");
            if (credentials.length >= 1) {
                name = credentials[0];
            }
            if (credentials.length >= 2) {
                password = credentials[1];
            }
        }
        this.credentials = new UsernamePasswordCredentials(name, password);
    }

    private void buildBaseURL(URL url) throws ResultException {
        if (url == null) {
            throw new ResultException(Result.build(Error.INVALID_URL));
        }
        String toUrl = url.toString();
        if (!toUrl.endsWith("/")) {
            toUrl = toUrl + "/";
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(toUrl);
            String userInfo = uriBuilder.getUserInfo();
            this.baseUrl = uriBuilder.setUserInfo(null).build();
            this.authScope = new AuthScope(this.baseUrl.getHost(), this.baseUrl.getPort());
            if (userInfo != null) {
                this.extractUserInfo(userInfo);
            }
            if (this.credentials != null) {
                this.credentialsProvider.setCredentials(this.authScope, this.credentials);
            }
        }
        catch (URISyntaxException ex) {
            throw new ResultException(Result.build(Error.INVALID_URL, ex));
        }
    }

    @Override
    public URI getURI(String subPath) throws ResultException {
        try {
            return new URIBuilder(this.baseUrl).setPath(this.baseUrl.getPath() + this.basePath + subPath).build();
        }
        catch (URISyntaxException ex) {
            throw new ResultException(Result.build(Error.INVALID_URL, ex));
        }
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        if (credentials != null) {
            this.credentials = credentials;
            this.credentialsProvider.setCredentials(this.authScope, this.credentials);
        }
    }

    @Override
    public DataFormat getDataFormat() {
        return this.dataFormat;
    }
}

