/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.https;

import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.https.TLSProtocol;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class TLSContext {
    private SSLContext sslContext;
    private boolean allowSelfSigned = false;
    private File trustStore = null;
    private String trustStorePassword = null;
    private TLSProtocol protocol = TLSProtocol.TLSV1_2;

    private TLSContext() {
    }

    public static TLSContext createDefault() {
        return new TLSContext();
    }

    private void initSSLContext() throws ResultException {
        try {
            this.sslContext = this.trustStore != null ? new SSLContextBuilder().loadTrustMaterial(this.trustStore, this.trustStorePassword != null ? this.trustStorePassword.toCharArray() : null, (TrustStrategy)(this.allowSelfSigned ? new TrustSelfSignedStrategy() : null)).setProtocol(this.protocol != null ? this.protocol.getName() : null).build() : (this.allowSelfSigned ? new SSLContextBuilder().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).setProtocol(this.protocol != null ? this.protocol.getName() : null).build() : SSLContexts.createDefault());
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new ResultException(Result.build(Error.HTTPS_IO_ERROR, ex));
        }
    }

    public TLSContext setAllowSelfSigned(boolean allowSelfSigned) {
        this.allowSelfSigned = allowSelfSigned;
        return this;
    }

    public boolean isAllowSelfSigned() {
        return this.allowSelfSigned;
    }

    public TLSContext setTrustStore(File trustStore, String trustStorePassword) {
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public TLSContext setTrustStore(File trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public File getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public TLSContext setProtocol(TLSProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public TLSProtocol getProtocol() {
        return this.protocol;
    }

    public SSLContext getSslContext() throws ResultException {
        if (this.sslContext == null) {
            this.initSSLContext();
        }
        return this.sslContext;
    }
}

