/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.http.HttpMethod;
import net.webpdf.wsclient.schema.beans.ExceptionBean;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.RestSession;
import net.webpdf.wsclient.tools.SerializeHelper;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpRestRequest {
    private final CloseableHttpClient httpClient;
    private final RestSession session;
    private final DataFormat dataFormat;
    private HttpUriRequest httpUriRequest;
    private String acceptHeader;

    private HttpRestRequest(RestSession session) {
        this.session = session;
        this.httpClient = session.getHttpClient();
        this.acceptHeader = session.getDataFormat().getMimeType();
        this.dataFormat = session.getDataFormat();
    }

    public static HttpRestRequest createRequest(RestSession session) {
        return new HttpRestRequest(session);
    }

    public HttpRestRequest setAcceptHeader(String mimeType) {
        this.acceptHeader = mimeType;
        return this;
    }

    public HttpRestRequest buildRequest(HttpMethod httpMethod, String path, HttpEntity httpEntity) throws ResultException {
        RequestBuilder requestBuilder;
        if (httpMethod == null) {
            throw new ResultException(Result.build(Error.UNKNOWN_HTTP_METHOD));
        }
        URI uri = this.session.getURI(path);
        switch (httpMethod) {
            case GET: {
                requestBuilder = RequestBuilder.get((URI)uri);
                break;
            }
            case POST: {
                requestBuilder = RequestBuilder.post((URI)uri);
                break;
            }
            default: {
                throw new ResultException(Result.build(Error.UNKNOWN_HTTP_METHOD));
            }
        }
        if (this.session.getCredentials() != null) {
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])(this.session.getCredentials().getUserPrincipal().getName() + ":" + this.session.getCredentials().getPassword()).getBytes(Charset.forName("ISO-8859-1")));
            requestBuilder.addHeader("Authorization", basicAuth);
        }
        requestBuilder.addHeader("Accept", this.acceptHeader);
        if (!this.session.getToken().getToken().isEmpty()) {
            requestBuilder.addHeader("Token", this.session.getToken().getToken());
        }
        if (httpEntity != null) {
            requestBuilder.setEntity(httpEntity);
        }
        this.httpUriRequest = requestBuilder.build();
        return this;
    }

    private void checkResponse(HttpResponse httpResponse) throws ResultException {
        String responseOutput;
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() == 200) {
            return;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            throw new ResultException(Result.build(Error.HTTP_EMPTY_ENTITY));
        }
        Header header = httpEntity.getContentType();
        if (header != null && (header.getValue().equals(DataFormat.XML.getMimeType()) || header.getValue().equals(DataFormat.JSON.getMimeType()))) {
            ExceptionBean exceptionBean = this.dataFormat.equals((Object)DataFormat.XML) ? SerializeHelper.fromXML(httpEntity, ExceptionBean.class) : SerializeHelper.fromJSON(httpEntity, ExceptionBean.class);
            responseOutput = "Server error: " + exceptionBean.getErrorMessage() + " (" + exceptionBean.getErrorCode() + ")\n" + (!exceptionBean.getStackTrace().isEmpty() ? "Server stack trace: " + exceptionBean.getStackTrace() + "\n" : "");
        } else {
            try {
                responseOutput = EntityUtils.toString((HttpEntity)httpEntity);
            }
            catch (IOException ex) {
                throw new ResultException(Result.build(Error.HTTP_CUSTOM_ERROR, ex));
            }
        }
        throw new ResultException(Result.build(Error.HTTP_CUSTOM_ERROR).addMessage(statusLine.getStatusCode() + " " + statusLine.getReasonPhrase() + "\n" + responseOutput));
    }

    public void executeRequest(OutputStream outputStream) throws ResultException {
        if (outputStream == null) {
            throw new ResultException(Result.build(Error.INVALID_FILE_SOURCE));
        }
        try (CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(this.httpUriRequest);){
            closeableHttpResponse.getEntity().writeTo(outputStream);
        }
        catch (IOException ex) {
            throw new ResultException(Result.build(Error.HTTP_IO_ERROR, ex));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeRequest(Class<T> type) throws ResultException {
        try (CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(this.httpUriRequest);){
            this.checkResponse((HttpResponse)closeableHttpResponse);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            if (type == null || httpEntity.getContent().available() <= 0) {
                T t = null;
                return t;
            }
            T t = this.dataFormat.equals((Object)DataFormat.XML) ? SerializeHelper.fromXML(httpEntity, type) : SerializeHelper.fromJSON(httpEntity, type);
            return t;
        }
        catch (IOException ex) {
            throw new ResultException(Result.build(Error.HTTP_IO_ERROR, ex));
        }
    }
}

