/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.exception;

import java.util.ArrayList;
import java.util.List;
import net.webpdf.wsclient.exception.Error;
import org.apache.commons.lang3.StringUtils;

public final class Result {
    public static final Result SUCCESS = new Result(Error.NONE, 0, null);
    private Error error;
    private Exception exception;
    private List<String> messages = new ArrayList<String>();
    private boolean joinMessages = true;
    private int exitCode;

    private Result(Error error, int exitCode, Exception exception) {
        this.error = error;
        this.exitCode = exitCode;
        this.exception = exception;
    }

    public static Result build(Error error) {
        return new Result(error, 0, null);
    }

    public static Result build(Error error, int exitCode) {
        return new Result(error, exitCode, null);
    }

    public static Result build(Error error, Exception exception) {
        return new Result(error, 0, exception);
    }

    public boolean isError() {
        return !Error.NONE.equals((Object)this.error);
    }

    public boolean isSuccess() {
        return Error.NONE.equals((Object)this.error);
    }

    public boolean equalsError(Error error) {
        return this.error != null && this.error.equals((Object)error);
    }

    public Error getError() {
        return this.error;
    }

    public int getCode() {
        return this.error.getCode();
    }

    public String getMessage() {
        String errorMessage = this.error.getMessage();
        String detailMessage = StringUtils.join(this.messages, (String)"\n");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(detailMessage.isEmpty() || this.joinMessages ? errorMessage : "");
        stringBuilder.append(!detailMessage.isEmpty() && stringBuilder.length() > 0 ? "\n" : "");
        stringBuilder.append(detailMessage);
        if (this.exitCode != 0) {
            stringBuilder.append(stringBuilder.length() > 0 ? " " : "");
            stringBuilder.append("[").append(this.exitCode).append("]");
        }
        return stringBuilder.toString();
    }

    public Exception getException() {
        return this.exception;
    }

    public Result addMessage(String message) {
        if (message != null && !message.isEmpty()) {
            this.messages.add(StringUtils.capitalize((String)message));
        }
        return this;
    }
}

