/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.documents;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import net.webpdf.wsclient.documents.AbstractDocument;
import net.webpdf.wsclient.documents.InputStreamDataSource;
import org.apache.commons.io.IOUtils;

public class SoapDocument
extends AbstractDocument
implements AutoCloseable {
    private InputStream inputStream;
    private boolean closeInput = false;
    private OutputStream outputStream;
    private boolean closeOutput = false;

    public SoapDocument(InputStream inputStream, OutputStream outputStream) {
        super(null);
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public SoapDocument(URI source, File targetFile) {
        super(source);
        try {
            if (this.isFileSource()) {
                this.inputStream = new FileInputStream(new File(source));
                this.closeInput = true;
            }
            this.outputStream = targetFile != null ? new FileOutputStream(targetFile) : null;
            this.closeOutput = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DataHandler getSourceDataHandler() {
        return this.inputStream != null ? new DataHandler((DataSource)new InputStreamDataSource(this.inputStream)) : null;
    }

    public void save(DataHandler resultDataHandler) throws IOException {
        if (this.outputStream == null) {
            throw new IOException("No output stream available");
        }
        if (resultDataHandler == null) {
            throw new IOException("No document content available");
        }
        resultDataHandler.writeTo(this.outputStream);
        if (resultDataHandler instanceof Closeable) {
            ((Closeable)resultDataHandler).close();
        }
    }

    @Override
    public void close() {
        if (this.closeInput) {
            IOUtils.closeQuietly((InputStream)this.inputStream);
        }
        if (this.closeOutput) {
            IOUtils.closeQuietly((OutputStream)this.outputStream);
        }
    }
}

