/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.documents;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.webpdf.wsclient.documents.RestDocument;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.http.HttpMethod;
import net.webpdf.wsclient.http.HttpRestRequest;
import net.webpdf.wsclient.schema.beans.DocumentFileBean;
import net.webpdf.wsclient.session.RestSession;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class DocumentManager {
    private final Map<String, RestDocument> documentMap = new HashMap<String, RestDocument>();
    private final RestSession session;

    public DocumentManager(RestSession session) {
        this.session = session;
    }

    public boolean downloadDocument(RestDocument document, OutputStream outputStream) throws ResultException {
        if (document == null || outputStream == null) {
            throw new ResultException(Result.build(Error.INVALID_FILE_SOURCE));
        }
        HttpRestRequest.createRequest(this.session).setAcceptHeader("application/octet-stream").buildRequest(HttpMethod.GET, "documents/" + document.getSourceDocumentId(), null).executeRequest(outputStream);
        return true;
    }

    public RestDocument uploadDocument(File file) throws IOException {
        if (file == null) {
            throw new ResultException(Result.build(Error.INVALID_FILE_SOURCE));
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addBinaryBody("filedata", file, ContentType.DEFAULT_BINARY, file.getName());
        HttpEntity entity = builder.build();
        return this.getDocument(HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "documents/", entity).executeRequest(DocumentFileBean.class));
    }

    public RestDocument getDocument(DocumentFileBean documentFileBean) throws ResultException {
        if (documentFileBean == null || documentFileBean.getDocumentId() == null) {
            throw new ResultException(Result.build(Error.INVALID_DOCUMENT));
        }
        String id = documentFileBean.getDocumentId();
        if (this.documentMap.containsKey(id)) {
            return this.documentMap.get(id);
        }
        RestDocument restDocument = new RestDocument(id);
        this.documentMap.put(documentFileBean.getDocumentId(), new RestDocument(documentFileBean.getDocumentId()));
        return restDocument;
    }
}

