/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient;

import javax.xml.transform.stream.StreamSource;
import net.webpdf.wsclient.BarcodeRestWebService;
import net.webpdf.wsclient.BarcodeWebService;
import net.webpdf.wsclient.ConverterRestWebService;
import net.webpdf.wsclient.ConverterWebService;
import net.webpdf.wsclient.OcrRestWebService;
import net.webpdf.wsclient.OcrWebService;
import net.webpdf.wsclient.PdfaRestWebService;
import net.webpdf.wsclient.PdfaWebService;
import net.webpdf.wsclient.SignatureRestWebService;
import net.webpdf.wsclient.SignatureWebService;
import net.webpdf.wsclient.ToolboxRestWebService;
import net.webpdf.wsclient.ToolboxWebService;
import net.webpdf.wsclient.UrlConverterRestWebService;
import net.webpdf.wsclient.UrlConverterWebService;
import net.webpdf.wsclient.WebService;
import net.webpdf.wsclient.WebServiceType;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.schema.operation.OperationData;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.tools.SerializeHelper;

public final class WebServiceFactory {
    private WebServiceFactory() {
    }

    public static <T extends WebService> T createInstance(Session session, WebServiceType webServiceType) throws ResultException {
        switch (session.getWebServiceProtocol()) {
            case SOAP: {
                return WebServiceFactory.createSoapInstance(session, webServiceType, new OperationData());
            }
            case REST: {
                return WebServiceFactory.createRestInstance(session, webServiceType, new OperationData());
            }
        }
        throw new ResultException(Result.build(Error.UNKNOWN_WEBSERVICE_PROTOCOL));
    }

    public static <T extends WebService> T createInstance(Session session, StreamSource streamSource) throws ResultException {
        WebServiceType webServiceType;
        OperationData operationData;
        if (session == null) {
            throw new ResultException(Result.build(Error.SESSION_CREATE));
        }
        DataFormat dataFormat = session.getDataFormat();
        if (dataFormat == null) {
            throw new ResultException(Result.build(Error.INVALID_OPERATION_DATA));
        }
        OperationData operationData2 = operationData = dataFormat.equals((Object)DataFormat.XML) ? SerializeHelper.fromXML(streamSource, OperationData.class) : SerializeHelper.fromJSON(streamSource, OperationData.class);
        if (operationData.isSetConverter()) {
            webServiceType = WebServiceType.CONVERTER;
        } else if (operationData.isSetBarcode()) {
            webServiceType = WebServiceType.BARCODE;
        } else if (operationData.isSetOcr()) {
            webServiceType = WebServiceType.OCR;
        } else if (operationData.isSetPdfa()) {
            webServiceType = WebServiceType.PDFA;
        } else if (operationData.isSetSignature()) {
            webServiceType = WebServiceType.SIGNATURE;
        } else if (operationData.isSetToolbox()) {
            webServiceType = WebServiceType.TOOLBOX;
        } else if (operationData.isSetUrlconverter()) {
            webServiceType = WebServiceType.URLCONVERTER;
        } else {
            throw new ResultException(Result.build(Error.UNKNOWN_WEBSERVICE_TYPE));
        }
        switch (session.getWebServiceProtocol()) {
            case SOAP: {
                return WebServiceFactory.createSoapInstance(session, webServiceType, operationData);
            }
            case REST: {
                return WebServiceFactory.createRestInstance(session, webServiceType, operationData);
            }
        }
        throw new ResultException(Result.build(Error.UNKNOWN_WEBSERVICE_PROTOCOL));
    }

    private static <T extends WebService> T createSoapInstance(Session session, WebServiceType webServiceType, OperationData operationData) throws ResultException {
        if (operationData == null) {
            throw new ResultException(Result.build(Error.INVALID_OPERATION_DATA));
        }
        switch (webServiceType) {
            case CONVERTER: {
                ConverterWebService converterWebService = new ConverterWebService(session);
                converterWebService.setOperation(operationData.getConverter());
                return (T)converterWebService;
            }
            case SIGNATURE: {
                SignatureWebService signatureWebService = new SignatureWebService(session);
                signatureWebService.setOperation(operationData.getSignature());
                return (T)signatureWebService;
            }
            case PDFA: {
                PdfaWebService pdfaWebService = new PdfaWebService(session);
                pdfaWebService.setOperation(operationData.getPdfa());
                return (T)pdfaWebService;
            }
            case OCR: {
                OcrWebService ocrWebService = new OcrWebService(session);
                ocrWebService.setOperation(operationData.getOcr());
                return (T)ocrWebService;
            }
            case TOOLBOX: {
                ToolboxWebService toolboxWebService = new ToolboxWebService(session);
                toolboxWebService.setOperation(operationData.getToolbox());
                return (T)toolboxWebService;
            }
            case URLCONVERTER: {
                UrlConverterWebService urlConverterWebService = new UrlConverterWebService(session);
                urlConverterWebService.setOperation(operationData.getUrlconverter());
                return (T)urlConverterWebService;
            }
            case BARCODE: {
                BarcodeWebService barcodeWebService = new BarcodeWebService(session);
                barcodeWebService.setOperation(operationData.getBarcode());
                return (T)barcodeWebService;
            }
        }
        throw new ResultException(Result.build(Error.UNKNOWN_WEBSERVICE_TYPE));
    }

    private static <T extends WebService> T createRestInstance(Session session, WebServiceType webServiceType, OperationData operationData) throws ResultException {
        if (operationData == null) {
            throw new ResultException(Result.build(Error.INVALID_OPERATION_DATA));
        }
        switch (webServiceType) {
            case CONVERTER: {
                ConverterRestWebService converterWebService = new ConverterRestWebService(session);
                converterWebService.setOperation(operationData.getConverter());
                return (T)converterWebService;
            }
            case SIGNATURE: {
                SignatureRestWebService signatureWebService = new SignatureRestWebService(session);
                signatureWebService.setOperation(operationData.getSignature());
                return (T)signatureWebService;
            }
            case PDFA: {
                PdfaRestWebService pdfaWebService = new PdfaRestWebService(session);
                pdfaWebService.setOperation(operationData.getPdfa());
                return (T)pdfaWebService;
            }
            case OCR: {
                OcrRestWebService ocrWebService = new OcrRestWebService(session);
                ocrWebService.setOperation(operationData.getOcr());
                return (T)ocrWebService;
            }
            case TOOLBOX: {
                ToolboxRestWebService toolboxWebService = new ToolboxRestWebService(session);
                toolboxWebService.setOperation(operationData.getToolbox());
                return (T)toolboxWebService;
            }
            case URLCONVERTER: {
                UrlConverterRestWebService urlConverterWebService = new UrlConverterRestWebService(session);
                urlConverterWebService.setOperation(operationData.getUrlconverter());
                return (T)urlConverterWebService;
            }
            case BARCODE: {
                BarcodeRestWebService barcodeWebService = new BarcodeRestWebService(session);
                barcodeWebService.setOperation(operationData.getBarcode());
                return (T)barcodeWebService;
            }
        }
        throw new ResultException(Result.build(Error.UNKNOWN_WEBSERVICE_TYPE));
    }
}

